package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.*;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 建筑物区分所有权业主共有部分信息
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "QLF_FW_FDCQ_QFSYQ")
public class QlfFwFdcqQfsyq implements Serializable, AccessData {
    final static String ysdm = "6002010210";//要素代码
    private String bdcdyh;//不动产单元号
    private String ywh;//业务号
    private String qllx;//权利类型
    private String jgzwbh;//建（构）筑物编号
    private String jgzwmc;//建（构）筑物名称
    private Integer jgzwsl;//建（构）筑物数量
    private Double jgzwmj;//建（构）筑物面积
    private Double fttdmj;//分摊土地面积
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String fj;//附记
    private String qszt;//权属状态
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    private Integer id;
    private String bdcqzh;
    private String bdcqzhjc;
    private String qllxmc;
    private String qxdmmc;
    private String qsztmc;

    private String ssywh;
    private String djlx;
    @XmlAttribute(name = "SSYWH")
    public String getSsywh() {
        return ssywh;
    }

    public void setSsywh(String ssywh) {
        this.ssywh = ssywh;
    }
    @XmlAttribute(name = "DJLX")
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "QLLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlAttribute(name = "JGZWBH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJgzwbh() {
        return jgzwbh;
    }

    public void setJgzwbh(String jgzwbh) {
        this.jgzwbh = jgzwbh;
    }

    @XmlAttribute(name = "JGZWMC")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJgzwmc() {
        return jgzwmc;
    }

    public void setJgzwmc(String jgzwmc) {
        this.jgzwmc = jgzwmc;
    }

    @XmlAttribute(name = "JGZWSL")
    public Integer getJgzwsl() {
        return jgzwsl;
    }

    public void setJgzwsl(Integer jgzwsl) {
        this.jgzwsl = jgzwsl;
    }

    @XmlAttribute(name = "JGZWMJ")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getJgzwmj() {
        return jgzwmj;
    }

    public void setJgzwmj(Double jgzwmj) {
        this.jgzwmj = jgzwmj;
    }

    @XmlAttribute(name = "FTTDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getFttdmj() {
        return fttdmj;
    }

    public void setFttdmj(Double fttdmj) {
        this.fttdmj = fttdmj;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "DBR")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }
    @XmlTransient
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
    @XmlTransient
    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }
    @XmlTransient
    public String getBdcqzhjc() {
        return bdcqzhjc;
    }

    public void setBdcqzhjc(String bdcqzhjc) {
        this.bdcqzhjc = bdcqzhjc;
    }
    @XmlTransient
    public String getQllxmc() {
        return qllxmc;
    }

    public void setQllxmc(String qllxmc) {
        this.qllxmc = qllxmc;
    }
    @XmlTransient
    public String getQxdmmc() {
        return qxdmmc;
    }

    public void setQxdmmc(String qxdmmc) {
        this.qxdmmc = qxdmmc;
    }
    @XmlTransient
    public String getQsztmc() {
        return qsztmc;
    }

    public void setQsztmc(String qsztmc) {
        this.qsztmc = qsztmc;
    }
}
