package cn.gtmap.estateplat.utils;

import com.gtis.config.AppConfig;
import com.gtis.config.EncryptHelper;
import com.gtis.config.PropertyPlaceholderHelper;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import static org.springframework.util.SystemPropertyUtils.PLACEHOLDER_PREFIX;
import static org.springframework.util.SystemPropertyUtils.PLACEHOLDER_SUFFIX;

public class AppConfigPlaceholderConfigurer extends PropertyPlaceholderConfigurer {
    private static Logger log = Logger.getLogger(AppConfigPlaceholderConfigurer.class);
    private static final PropertyPlaceholderHelper HELPER = new PropertyPlaceholderHelper(PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, ":", true);

    @Override
    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) {
        try {
            DESPlus des = new DESPlus();
            String password = props.getProperty("bdcdj.db.password");
            if (password != null) {
                props.setProperty("bdcdj.db.password", des.decrypt(password));
            }
            AppConfig.setConfiguration(props);
            super.processProperties(beanFactoryToProcess, props);
        } catch (Exception e) {
            log.error("msg", e);
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    protected Properties mergeProperties() throws IOException {
        Properties props = super.mergeProperties();
        Iterator var2 = props.entrySet().iterator();

        while(var2.hasNext()) {
            Map.Entry entry = (Map.Entry)var2.next();
            String v = (String)entry.getValue();
            if (v != null && v.startsWith("!!")) {
                entry.setValue(EncryptHelper.decrypt(v));
            }
        }
        return props;
    }

    @Override
    protected String parseStringValue(String strVal, final Properties props, Set visitedPlaceholders) {
        return HELPER.replacePlaceholders(strVal, new PropertyPlaceholderHelper.PlaceholderResolver() {
            @Override
            public String resolvePlaceholder(String placeholderName) {
                return AppConfigPlaceholderConfigurer.this.resolvePlaceholder(placeholderName, props, SYSTEM_PROPERTIES_MODE_FALLBACK);
            }
        });
    }
}
