/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.log.config;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.log.config.ConfigLog;
import cn.gtmap.estateplat.log.config.ConfigLogService;
import cn.gtmap.estateplat.model.server.core.BdcXtLog;
import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.data.domain.Pageable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.ui.Model;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class ConfigLogAspect {
    private ConfigLogService configLogService;
    private SysUserService sysUserService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final String ANONYMOUS_USER_ID = "-999";
    private static final String ANONYMOUS_USER_NAME = "\u533f\u540d\u7528\u6237";
    public static final String LOGIN_USER_IP = "login_user_ip";
    public static final String LOGIN_USER_MAC = "login_user_mac";
    public static final String LOGIN_USER_COMPUTERNAME = "login_user_computername";

    public void setConfigLogService(ConfigLogService configLogService) {
        this.configLogService = configLogService;
    }

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    @Pointcut(value="@annotation(cn.gtmap.estateplat.log.config.ConfigLog)")
    public void configLogServiceAspect() {
    }

    @Before(value="configLogServiceAspect()")
    public void doBefore(JoinPoint joinPoint) {
        Method method = this.getMethod(joinPoint);
        ConfigLog configLog = method.getAnnotation(ConfigLog.class);
        String userId = StringUtils.isNotBlank((CharSequence)configLog.userId()) ? this.parseUserId(configLog.userId(), method, joinPoint.getArgs()) : null;
        List<Object> arguments = this.filterArguments(joinPoint.getArgs());
        if (CollectionUtils.isNotEmpty(arguments)) {
            for (Object argument : arguments) {
                if (argument instanceof Object[]) {
                    Object[] objects = (Object[])argument;
                    if (objects.length == 0) continue;
                    for (Object object : objects) {
                        this.configLog(configLog.name(), this.getConfigContent(object, configLog), userId);
                    }
                    continue;
                }
                this.configLog(configLog.name(), this.getConfigContent(argument, configLog), userId);
            }
        }
    }

    @After(value="configLogServiceAspect()")
    public void doAfter(JoinPoint joinPoint) {
    }

    private void configLog(String name, String content, String userId) {
        final BdcXtLog bdcXtLog = new BdcXtLog();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        bdcXtLog.setLogid(UUIDGenerator.generate());
        bdcXtLog.setCzrq(Calendar.getInstance().getTime());
        if (StringUtils.isNotBlank((CharSequence)SessionUtil.getCurrentUserId())) {
            bdcXtLog.setUserid(SessionUtil.getCurrentUserId());
            bdcXtLog.setUsername(SessionUtil.getCurrentUser().getUsername());
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            bdcXtLog.setUserid(userId);
            PfUserVo pfUserVo = this.sysUserService != null ? this.sysUserService.getUserVo(userId) : null;
            bdcXtLog.setUsername(pfUserVo != null ? pfUserVo.getUserName() : "");
        } else {
            bdcXtLog.setUserid(ANONYMOUS_USER_ID);
            bdcXtLog.setUsername(ANONYMOUS_USER_NAME);
        }
        bdcXtLog.setController(name);
        bdcXtLog.setParmjson(content);
        try {
            String ip = ClientInfoUtil.getIpAddr(request);
            bdcXtLog.setIp(ip);
            if (StringUtils.isNotBlank((CharSequence)ip) && !StringUtils.equals((CharSequence)ip, (CharSequence)"127.0.0.1")) {
                String mac = ClientInfoUtil.getMACAddress(ip);
                String computername = ClientInfoUtil.getComputerName(ip);
                bdcXtLog.setMac(mac);
                bdcXtLog.setComputername(computername);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ConfigLogAspect.this.configLogService.saveConfigLog(bdcXtLog);
            }
        });
    }

    private ConfigLog getMethodLog(JoinPoint joinPoint) {
        try {
            Method[] methods;
            String targetName = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            Object[] arguments = joinPoint.getArgs();
            Class<?> targetClass = Class.forName(targetName);
            for (Method method : methods = targetClass.getMethods()) {
                Class<?>[] classes;
                if (!method.getName().equals(methodName) || (classes = method.getParameterTypes()).length != arguments.length) continue;
                return method.getAnnotation(ConfigLog.class);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AppException(e.getMessage());
        }
        return null;
    }

    private String getConfigContent(Object argument, ConfigLog configLog) {
        HashMap contentMap = Maps.newHashMap();
        String description = StringUtils.isNotBlank((CharSequence)configLog.description()) ? configLog.description() : "\u64cd\u4f5c#className\u5185\u5bb9";
        description = StringUtils.replace((String)description, (String)"#className", (String)argument.getClass().getSimpleName());
        contentMap.put(description, argument);
        return JSON.toJSONString((Object)contentMap);
    }

    private List<Object> filterArguments(Object[] args) {
        ArrayList arguments = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof Model || arg instanceof Pageable || arg instanceof HttpServletResponse || arg instanceof HttpServletRequest) continue;
            arguments.add(arg);
        }
        return arguments;
    }

    private String parseUserId(String userId, Method method, Object[] args) {
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] paraNameArr = u.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < paraNameArr.length; ++i) {
            context.setVariable(paraNameArr[i], args[i]);
        }
        return (String)parser.parseExpression(userId).getValue((EvaluationContext)context, String.class);
    }

    private Method getMethod(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        Class[] argTypes = new Class[joinPoint.getArgs().length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Method method = null;
        try {
            method = joinPoint.getTarget().getClass().getMethod(joinPoint.getSignature().getName(), argTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return method;
    }

    private String getRemoteAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || ip.equalsIgnoreCase("unknown")) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || ip.equalsIgnoreCase("unknown")) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || ip.equalsIgnoreCase("unknown")) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

