package cn.gtmap.estateplat.model.acceptance;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2018/9/18
 * @description 收费项目信息
 */
@Table( name ="YCSL_SFXM" )
public class YcslSfxm implements Serializable {

    /**
     * 主键
     */
    @Column(name = "SFXMID" )
    @Id
    private String sfxmid;

    /**
     * 收费信息id
     */
    @Column(name = "SFXXID" )
    private String sfxxid;


    /**
     * 收费项目名称
     */
    @Column(name = "SFXMMC" )
    private String sfxmmc;


    /**
     * 序号
     */
    @Column(name = "XH" )
    private Integer xh;


    /**
     * 数量
     */
    @Column(name = "SL" )
    private Integer sl;


    /**
     * 减免金额
     */
    @Column(name = "JMJE" )
    private Double jmje;

    /**
     * 应收金额
     */
    @Column(name = "YSJE" )
    private Double ysje;


    /**
     * 实收金额
     */
    @Column(name = "SSJE" )
    private Double ssje;


    /**
     * 金额单位
     */
    @Column(name = "JEDW" )
    private String jedw;

    /**
     * 收费项目代码
     */
    @Column(name = "SFXMDM" )
    private String sfxmdm;


    /**
     * 收费标准
     */
    @Column(name = "SFBZ" )
    private String sfbz;

    /**
     * 结算方式（月结/正常）
     */
    @Column(name = "JSFS" )
    private String jsfs;

    /**
     * 原收费项目名称（宣城的SFXMMC保存的是登记SFXMMC）
     */
    @Column(name = "YSFXMMC" )
    private String ysfxmmc;

    public String getSfxmid() {
        return sfxmid;
    }

    public void setSfxmid(String sfxmid) {
        this.sfxmid = sfxmid;
    }

    public String getSfxxid() {
        return sfxxid;
    }

    public void setSfxxid(String sfxxid) {
        this.sfxxid = sfxxid;
    }

    public String getSfxmmc() {
        return sfxmmc;
    }

    public void setSfxmmc(String sfxmmc) {
        this.sfxmmc = sfxmmc;
    }

    public Integer getXh() {
        return xh;
    }

    public void setXh(Integer xh) {
        this.xh = xh;
    }

    public Integer getSl() {
        return sl;
    }

    public void setSl(Integer sl) {
        this.sl = sl;
    }

    public Double getJmje() {
        return jmje;
    }

    public void setJmje(Double jmje) {
        this.jmje = jmje;
    }

    public Double getYsje() {
        return ysje;
    }

    public void setYsje(Double ysje) {
        this.ysje = ysje;
    }

    public Double getSsje() {
        return ssje;
    }

    public void setSsje(Double ssje) {
        this.ssje = ssje;
    }

    public String getJedw() {
        return jedw;
    }

    public void setJedw(String jedw) {
        this.jedw = jedw;
    }

    public String getSfxmdm() {
        return sfxmdm;
    }

    public void setSfxmdm(String sfxmdm) {
        this.sfxmdm = sfxmdm;
    }

    public String getSfbz() {
        return sfbz;
    }

    public void setSfbz(String sfbz) {
        this.sfbz = sfbz;
    }

    public String getJsfs() {
        return jsfs;
    }

    public void setJsfs(String jsfs) {
        this.jsfs = jsfs;
    }

    public String getYsfxmmc() {
        return ysfxmmc;
    }

    public void setYsfxmmc(String ysfxmmc) {
        this.ysfxmmc = ysfxmmc;
    }
}
