package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.sql.Timestamp;
import java.util.Calendar;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/10/12
 * @description 中国移动短信服务-盐城
 */
public class CmccSmsServiceForYacImpl implements SmsService{

    private static final String PHONE_NUMBER_NULL = "电话号码为空！";

    private static final String CONTENT_NUMBER_NULL = "短信内容为空！";

    private JdbcTemplate jdbcTemplate;

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public Boolean sendSms(String phoneNum, String content) throws AppException {
        if (StringUtils.isBlank(phoneNum)) {
            throw new AppException(PHONE_NUMBER_NULL);
        }
        if (StringUtils.isBlank(content)) {
            throw new AppException(CONTENT_NUMBER_NULL);
        }
        String sql = "INSERT INTO MA_SHORT_MESSAGE (INSERTTIME, MobilePhones, Content, Priority, ModuleName, ExNumber, SMStatus) VALUES (?,?,?,?,?,?,?)";
        try {
            Object[] param = new Object[7];
            param[0] = new Timestamp(Calendar.getInstance().getTimeInMillis());
            param[1] = phoneNum;
            param[2] = content;
            param[3] = 1;
            param[4] = "bdcdj";
            param[5] = 333;
            param[6] = 100;
            jdbcTemplate.update(sql, param);
        } catch (Exception e) {
            throw new AppException(e.getMessage());
        }
        return true;
    }
}
