package cn.gtmap.estateplat.utils;

import com.gtis.generic.util.Struts2Utils;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/11/2
 * @description 获取客户端的信息
 */
public class ClientInfoUtil {

    //得到客户端IP地址
    public static String getIpAddr(HttpServletRequest request) {
        /*
         *zdd 2018-12-13 完善IP获取方式  后期可以调用平台的 Struts2Utils.getRemoteAddr();
         */
        String remoteAddr = "";
        if (request != null) {
            remoteAddr = request.getHeader("x-forwarded-for");
            if (remoteAddr!=null && remoteAddr.length() > 15) {
                String[] ips = remoteAddr.split(",");
                for (int index = 0; index < ips.length; index++) {
                    String strIp = (String) ips[index];
                    if (!("unknown".equalsIgnoreCase(strIp))) {
                        remoteAddr = strIp;
                        break;
                    }
                }
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("Proxy-Client-IP");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("WL-Proxy-Client-IP");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("HTTP_CLIENT_IP");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getHeader("X-Real-IP");
            }
            if (remoteAddr == null || remoteAddr.length() == 0 || "unknown".equalsIgnoreCase(remoteAddr)) {
                remoteAddr = request.getRemoteAddr();
            }

        }
        return remoteAddr;
    }

    //得到客户端MAC地址
    public static String getMACAddress(String ip) {
        String str = "";
        String macAddress = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(new InputStreamReader(p.getInputStream(), "GBK"));
            for (int i = 1; i < 100; i++) {
                str = input.readLine();
                str = new String(str.getBytes(), "utf-8");
                if (str != null) {
                    if (str.indexOf("MAC") > 1) {
                        macAddress = str.substring(str.indexOf("=") + 2, str.length());
                        break;
                    }
                }
            }
        } catch (IOException e) {
//            e.printStackTrace(System.out);
        }
        return macAddress;
    }

    //得到客户端计算机名
    public static String getComputerName(String ip) {
        String computerName = "";
        String str = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(new InputStreamReader(p.getInputStream(), "GBK"));
            for (int i = 1; i < 100; i++) {
                str = input.readLine();
                str = new String(str.getBytes(), "utf-8");
                if (str != null) {
                    str = str.trim().replaceAll("\\s{1,}", "");
                    if (str.indexOf("<") > 1) {
                        computerName = str.substring(0, str.indexOf("<"));
                        break;
                    }
                }
            }
        } catch (IOException e) {
//            e.printStackTrace();
        }
        return computerName;
    }
}
