package cn.gtmap.estateplat.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.*;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2020-10-22
 * @description
 */
public class CompareXmlUtil {
    private static Map<String, String> pxMap;
    private static Map<String, String> qcMap;

    /**
     * xml转map 不带属性
     *
     * @param xmlStr
     * @param needRootKey 是否需要在返回的map里加根节点键
     * @return
     * @throws DocumentException
     */
    public static Map xml2map(String xmlStr, boolean needRootKey) throws DocumentException {
        getPxZd();
        getQcZd();
        Document doc = DocumentHelper.parseText(xmlStr);
        Element root = doc.getRootElement();
        Map<String, Object> map = (Map<String, Object>) xml2map(root, pxMap);
        if (root.elements().size() == 0 && root.attributes().size() == 0) {
            return map;
        }
        if (needRootKey) {
            //在返回的map里加根节点键（如果需要）
            Map<String, Object> rootMap = new TreeMap<String, Object>(new Comparator<String>() {
                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            rootMap.put(root.getName(), map);
            return rootMap;
        }
        return map;
    }

    /**
     * xml转map 不带属性
     *
     * @param e
     * @return
     */
    private static Map xml2map(Element e, Map<String, String> pxMap) {
        Map map = new TreeMap<String, String>(new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                Element iter = (Element) list.get(i);
                if (!StringUtils.equals(iter.getQName().getName(), "Head")) {
                    List mapList = new ArrayList();
                    if (iter.elements().size() > 0) {
                        Map m = xml2map(iter, pxMap);
                        if (map.get(iter.getName()) != null) {
                            Object obj = map.get(iter.getName());
                            if (!(obj instanceof List)) {
                                mapList = new ArrayList();
                                mapList.add(obj);
                                mapList.add(m);
                            }
                            if (obj instanceof List) {
                                mapList = (List) obj;
                                mapList.add(m);
                            }
                            map.put(iter.getName(), mapList);
                        } else {
                            map.put(iter.getName(), m);
                        }
                    } else {
                        if (map.get(iter.getName()) != null) {
                            Object obj = map.get(iter.getName());
                            if (!(obj instanceof List)) {
                                mapList = new ArrayList();
                                mapList.add(obj);
                                if (iter.attributes() != null && iter.attributes().size() > 0) {
                                    TreeMap elementmap = elementmap(iter);
                                    mapList.add(elementmap);
                                } else {
                                    mapList.add(iter.getText());
                                }
                            }
                            if (obj instanceof List) {
                                mapList = (List) obj;
                                if (iter.attributes() != null && iter.attributes().size() > 0) {
                                    TreeMap elementmap = elementmap(iter);
                                    mapList.add(elementmap);
                                } else {
                                    mapList.add(iter.getText());
                                }
                            }
                            String zd = "";
                            if (pxMap.containsKey(iter.getName())) {
                                zd = pxMap.get(iter.getName());
                                sortList(mapList, zd);
                            }
                            map.put(iter.getName(), mapList);
                        } else {
                            map.put(iter.getName(), iter.getText());
                            if (iter.attributes() != null && iter.attributes().size() > 0) {
                                TreeMap elementmap = elementmap(iter);
                                map.put(iter.getName(), elementmap);
                            }
                        }
                    }
                }
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static List sortList(List list, final String zd) {
        List<String> zdList = Arrays.asList(zd.split(","));
        if (zdList != null && zdList.size() > 0) {
            for (String pxzd : zdList) {
                sortListTreeMap(list, pxzd);
            }
        }
        return list;
    }

    private static List sortListTreeMap(List list, final String zd) {
        Collections.sort(list, new Comparator<TreeMap>() {
            @Override
            public int compare(TreeMap o1, TreeMap o2) {
                String str1 = "";
                if (o1.containsKey(zd)) {
                    str1 = o1.get(zd).toString();
                } else {
                    str1 = "";
                }
                String str2 = "";
                if (o2.containsKey(zd)) {
                    str2 = o2.get(zd).toString();
                } else {
                    str2 = "";
                }
                return str1.compareTo(str2);
            }
        });
        return list;
    }

    private static TreeMap elementmap(Element element) {
        TreeMap map = new TreeMap<String, String>(new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        if (element.attributes() != null && element.attributes().size() > 0) {
            List<Attribute> attributeList = element.attributes();
            for (Attribute attribute : attributeList) {
                if (!qcMap.containsKey(attribute.getName())) {
                    map.put(attribute.getName(), attribute.getValue());
                }
            }
        }
        return map;
    }

    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description map转xml map中没有根节点的键
     */
    public static Document map2xml(Map<String, Object> map, String rootName) {
        Document doc = DocumentHelper.createDocument();
        Element root = DocumentHelper.createElement(rootName);
        doc.add(root);
        map2xml(map, root);
        return doc;
    }

    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description map转xml
     */
    private static Element map2xml(Map<String, Object> map, Element body) {
        Iterator<Map.Entry<String, Object>> entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, Object> entry = entries.next();
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith("@")) {    //属性
                body.addAttribute(key.substring(1, key.length()), value.toString());
            } else if (key.equals("#text")) {    //有属性时的文本
                body.setText(value.toString());
            } else {
                if (value instanceof java.util.List) {
                    List list = (List) value;
                    Object obj;
                    for (int i = 0; i < list.size(); i++) {
                        obj = list.get(i);
                        //list里是map或String，不会存在list里直接是list的，
                        if (obj instanceof java.util.Map) {
                            Element subElement = body.addElement(key);
                            setAttributes((Map) list.get(i), subElement);
                        } else {
                            body.addElement(key).setText((String) list.get(i));
                        }
                    }
                } else if (value instanceof java.util.Map) {
                    Element subElement = body.addElement(key);
                    setAttributes((Map) value, subElement);
                } else {
                    body.addElement(key).setText(value.toString());
                }
            }
        }
        return body;
    }

    public static Element setAttributes(Map map, Element subElement) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = (String) entry.getKey();
            if (subElement.getName().equals("Head") || entry.getValue() instanceof java.util.Map) {
                map2xml(map, subElement);
                break;
            } else if (entry.getValue() instanceof String) {
                String integ = (String) entry.getValue();
                subElement.setAttributeValue(key, integ);
            }
        }
        return subElement;
    }

    public static String chomp(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static void main(String[] args) {
        getPxZd();
    }

    public static Map<String, String> getPxZd() {
        if (MapUtils.isEmpty(pxMap)) {
            pxMap = Maps.newHashMap();
            List<JSONObject> jsonObjectList = (List<JSONObject>) JSON.parse(pzJson);
            if (jsonObjectList != null && jsonObjectList.size() > 0) {
                for (int i = 0; i < jsonObjectList.size(); i++) {
                    JSONObject jsonObject = jsonObjectList.get(i);
                    pxMap.put(jsonObject.getString("jdmc"), jsonObject.getString("pxzd"));
                }
            }
        }
        return pxMap;
    }

    public static Map<String, String> getQcZd() {
        if (MapUtils.isEmpty(qcMap)) {
            qcMap = Maps.newHashMap();
            List<JSONObject> jsonObjectList = (List<JSONObject>) JSON.parse(qcJson);
            if (jsonObjectList != null && jsonObjectList.size() > 0) {
                for (int i = 0; i < jsonObjectList.size(); i++) {
                    JSONObject jsonObject = jsonObjectList.get(i);
                    qcMap.put(jsonObject.getString("qczd"), jsonObject.getString("qczd"));
                }
            }
        }
        return qcMap;
    }


    private static String qcJson = "[{\"qczd\":\"YSDM\"}]";
    private static String pzJson = "[{\"jdmc\":\"ZTT_GY_QLR\",\"pxzd\":\"DFGYFSDM,DFGYFSMC,DFQLRLXDM,DFQLRLXMC,DFZJZLMC,BDCDYH,BDCQZH,DH,GJ,GYFS,GYQK,QLRLX,QLRMC,QXDM,QZYSXLH,SFCZR,SXH,YSDM,ZJH,ZJZL\"},{\"jdmc\":\"KTT_ZDJBXX\",\"pxzd\":\"DFDJDM,DFDJMC,DFQLLXDM,DFQLLXMC,DFQLXZDM,DFQLXZMC,DFYTDM,DFYTMC,BDCDYH,BSM,DAH,DBR,DJ,DJH,DJJGBM,DJJGMC,DJSJ,JDH,JFH,JG,JZMD,MJDW,QLLX,QLSDFS,QLXZ,QXDM,RJL,YSDM,YT,ZDDM,ZDMJ,ZDSZB,ZDSZD,ZDSZN,ZDSZX,ZDT,ZDTZM,ZH,ZT\"},{\"jdmc\":\"QLF_QL_JSYDSYQ\",\"pxzd\":\"DFDJLXDM,DFDJLXMC,FQLLXDM,DFQLLXMC,BDCDYH,BDCQZH,DBR,DJJG,DJLX,DJSJ,DJYY,QDJG,QLLX,QSZT,QXDM,SYQJSSJ,SYQMJ,YSDM,YWH,ZDDM\"},{\"jdmc\":\"QLT_FW_FDCQ_YZ\",\"pxzd\":\"DFDJLXDM,DFDJLXMC,DFFWJGDM,DFFWJGMC,DFGHYTDM,DFGHYTMC,DFQLLXDM,DFQLLXMC,BDCDYH,BDCQZH,DBR,DJJG,DJLX,DJSJ,DJYY,FDCJYJG,FDZL,FWJG,GHYT,JZMJ,QLLX,QSZT,QXDM,SZC,TDSYJSSJ,TDSYQR,TDSYQSSJ,YSDM,YWH,ZCS\"},{\"jdmc\":\"QLT_FW_FDCQ_DZ\",\"pxzd\":\"DFDJLXDM,DFDJLXMC,DFQLLXDM,DFQLLXMC,BDCDYH,BDCQZH,DBR,DJJG,DJLX,DJSJ,DJYY,DYTDMJ,FJ,QLLX,QSZT,QXDM,TDSYJSSJ,TDSYQR,TDSYQSSJ,YSDM,YWH\"},{\"jdmc\":\"QLF_FW_FDCQ_DZ_XM\",\"pxzd\":\"DFFWJGDM,DFFWJGMC,DFGHYTDM,DFGHYTMC,BDCDYH,FWJG,,JZMJ,QXDM,XMMC,ZCS,ZH,ZTS\"},{\"jdmc\":\"QLF_QL_DYAQ\",\"pxzd\":\"DFDJLXDM,DFDJLXMC,DFDYBDCLXMC,DFDYFSDM,DFDYFSMC,BDBZZQSE,BDCDJZMH,BDCDYH,DBR,DJJG,DJLX,DJSJ,DJYY,DYBDCLX,DYFS,DYJELX,DYR,QSZT,QXDM,SCYWH,YSDM,YWH,ZGZQSE,ZWLXJSSJ,ZWLXQSSJ\"},{\"jdmc\":\"QLF_QL_YGDJ\",\"pxzd\":\"DFDJLXDM,DFDJLXMC,DFFWXZDM,DFFWXZMC,DFGHYTDM,DFGHYTMC,DFYGDJZLDM,DFYGDJZLMC,DFYWRZJZLDM,DFYWRZJZLMC,BDCDJZMH,BDCDYH,BDCZL,DBR,DJLX,DJSJ,DJYY,FJ,FWXZ,GHYT,JZMJ,QSZT,QXDM,SCYWH,SZC,TDSYQR,YGDJZL,YSDM,YWH,YWR,YWRZJH,YWRZJZL,ZCS\"},{\"jdmc\":\"DJT_DJ_SLSQ\",\"pxzd\":\"DFAJZTMC,DFDJDLDM,DFDJDLMC,AJZT,BZ,DJDL,DJXL,JSSJ,QXDM,SFWTAJ,SLRY,SLSJ,SQFBCZ,SQZSBS,YSDM,YWH,ZL\"},{\"jdmc\":\"DJF_DJ_SJ\",\"pxzd\":\"DFSJLXMC,QXDM,SFBCSJ,SFEWSJ,SFSJSY,SJLX,SJMC,SJSJ,SJSL,YS,YSDM,YWH\"},{\"jdmc\":\"DJF_DJ_SH\",\"pxzd\":\"DFCZJGMC,CZJG,JDMC,QXDM,SHJSSJ,SHKSSJ,SHRYXM,SHYJ,SXH,YSDM,YWH\"},{\"jdmc\":\"DJF_DJ_SZ\",\"pxzd\":\"BZ,QXDM,SZMC,SZRY,SZSJ,SZZH,YSDM,YSXLH,YWH\"},{\"jdmc\":\"DJF_DJ_SQR\",\"pxzd\":\"DFQLRZJZLDM,DFQLRZJZLMC,BZ,QLRDLRDH,QLRFRDH,QLRMC,QLRZJH,QLRZJZL,QXDM,YSDM,YWH\"}]";

}
