package cn.gtmap.estateplat.model.exchange.national;


import cn.gtmap.estateplat.utils.JaxbDoubleThreeAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;


/**
 * 层信息
 * Created by xhc on 2015/11/19.
 */

@XmlRootElement(name = "KTT_FW_C")
public class KttFwC implements Serializable, AccessData {
    final static String ysdm = "6001030130";//要素代码
    private String ch;//层号
    private String zrzh;//自然幢号
    private Integer sjc;//实际层
    private String myc;//名义层
    private Double cjzmj;//层建筑面积
    private Double ctnjzmj;//层套内建筑面积
    private Double cytmj;//层阳台面积
    private Double cgyjzmj;//层共有建筑面积
    private Double cftjzmj;//层分摊建筑面积
    private Double cbqmj;//层半墙面积
    private Double cg;//层高
    private Double sptymj;//水平投影面积
    private String qxdm;//区县代码
    private String bdcdyh;//不动产单元号
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @description 逻辑幢编号
     */
    private String ljzbh;

    @XmlTransient
    public String getLjzbh() {
        return ljzbh;
    }

    public void setLjzbh(String ljzbh) {
        this.ljzbh = ljzbh;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "CH")
    public String getCh() {
        return ch;
    }

    public void setCh(String ch) {
        this.ch = ch;
    }

    @XmlAttribute(name = "ZRZH")
    public String getZrzh() {
        return zrzh;
    }

    public void setZrzh(String zrzh) {
        this.zrzh = zrzh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "SJC")
    public Integer getSjc() {
        return sjc;
    }

    public void setSjc(Integer sjc) {
        this.sjc = sjc;
    }

    @XmlAttribute(name = "MYC")
    public String getMyc() {
        return myc;
    }

    public void setMyc(String myc) {
        this.myc = myc;
    }

    @XmlAttribute(name = "CJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getCjzmj() {
        return cjzmj;
    }

    public void setCjzmj(Double cjzmj) {
        this.cjzmj = cjzmj;
    }

    @XmlAttribute(name = "CTNJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getCtnjzmj() {
        return ctnjzmj;
    }

    public void setCtnjzmj(Double ctnjzmj) {
        this.ctnjzmj = ctnjzmj;
    }

    @XmlAttribute(name = "CYTMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getCytmj() {
        return cytmj;
    }

    public void setCytmj(Double cytmj) {
        this.cytmj = cytmj;
    }

    @XmlAttribute(name = "CGYJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getCgyjzmj() {
        return cgyjzmj;
    }

    public void setCgyjzmj(Double cgyjzmj) {
        this.cgyjzmj = cgyjzmj;
    }

    @XmlAttribute(name = "CFTJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getCftjzmj() {
        return cftjzmj;
    }

    public void setCftjzmj(Double cftjzmj) {
        this.cftjzmj = cftjzmj;
    }

    @XmlAttribute(name = "CBQMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getCbqmj() {
        return cbqmj;
    }

    public void setCbqmj(Double cbqmj) {
        this.cbqmj = cbqmj;
    }

    @XmlAttribute(name = "CG")
    public Double getCg() {
        return cg;
    }

    public void setCg(Double cg) {
        this.cg = cg;
    }

    @XmlAttribute(name = "SPTYMJ")
    public Double getSptymj() {
        return sptymj;
    }

    public void setSptymj(Double sptymj) {
        this.sptymj = sptymj;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlTransient
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }
}
