package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 房地产权_项目内多幢房屋_项目属性
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "QLF_FW_FDCQ_DZ_XM")
public class QlfFwFdcqDzXm implements Serializable, AccessData {
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 业务号
     */
    private String ywh;
    private String bdcdyh;//不动产单元号
    private String zh;//幢号
    private String xmmc;//项目名称
    private Integer zcs;//总层数
    private String ghyt;//规划用途
    private String fwjg;//房屋结构
    private Double jzmj;//建筑面积
    private String jgsj;//竣工时间
    private Integer zts;//总套数
    private String qxdm;//区县代码

    /**
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description 插入更新时间
     */
    private Date updatetime;
    /**
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description 插入创建时间
     */
    private Date createtime;

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @description 房屋类型
     */
    private String fwlx;

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @description 房屋性质
     */
    private String fwxz;

    private Integer id;
    private String fwjgmc;
    private String ghytmc;

    /**
     * @author <a href="mailto:zhuruijie@gtmap.cn">zhuruijie</a>
     * @description 项目编码
     */
    private String xmbm;//项目编码

    @XmlTransient
    public String getXmbm() {
        return xmbm;
    }

    public void setXmbm(String xmbm) {
        this.xmbm = xmbm;
    }

    @XmlTransient
    public String getFwlx() {
        return fwlx;
    }

    public void setFwlx(String fwlx) {
        this.fwlx = fwlx;
    }

    @XmlTransient
    public String getFwxz() {
        return fwxz;
    }

    public void setFwxz(String fwxz) {
        this.fwxz = fwxz;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlTransient
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "ZH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZh() {
        return zh;
    }

    public void setZh(String zh) {
        this.zh = zh;
    }

    @XmlAttribute(name = "XMMC")
    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    @XmlAttribute(name = "ZCS")
    public Integer getZcs() {
        return zcs;
    }

    public void setZcs(Integer zcs) {
        this.zcs = zcs;
    }

    @XmlAttribute(name = "GHYT")
    public String getGhyt() {
        return ghyt;
    }

    public void setGhyt(String ghyt) {
        this.ghyt = ghyt;
    }

    @XmlAttribute(name = "FWJG")
    public String getFwjg() {
        return fwjg;
    }

    public void setFwjg(String fwjg) {
        this.fwjg = fwjg;
    }

    @XmlAttribute(name = "JZMJ")
    public Double getJzmj() {
        return jzmj;
    }

    public void setJzmj(Double jzmj) {
        this.jzmj = jzmj;
    }

    @XmlAttribute(name = "JGSJ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJgsj() {
        return jgsj;
    }

    public void setJgsj(String jgsj) {
        this.jgsj = jgsj;
    }

    @XmlAttribute(name = "ZTS")
    public Integer getZts() {
        return zts;
    }

    public void setZts(Integer zts) {
        this.zts = zts;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }
    @XmlTransient
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
    @XmlTransient
    public String getFwjgmc() {
        return fwjgmc;
    }

    public void setFwjgmc(String fwjgmc) {
        this.fwjgmc = fwjgmc;
    }
    @XmlTransient
    public String getGhytmc() {
        return ghytmc;
    }

    public void setGhytmc(String ghytmc) {
        this.ghytmc = ghytmc;
    }
}
