package cn.gtmap.estateplat.service.exchange;


import cn.gtmap.estateplat.model.server.core.*;

import java.util.List;

/**
 * 不动产结果数据接口
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2015/12/4
 */
public interface BdcJgsjService {
    /**
     * 将不动产数据推送到房屋信息
     *
     * @param proid
     * @return
     */
    public String bdcJgsjToFwxx(String proid);

    /**
     * 将不动产数据推送到土地信息
     *
     * @param proid
     * @return
     */
    public String bdcJgsjToTdxx(String proid);

    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @data:2016/4/19
     * @param:proid
     * @return: List<BdcXm>
     * @description: 根据proid获取项目, 然后根据项的wiid获取所有的信息
     */
    public List<BdcXm> getBdcXmsByProid(String proid);

    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @data:2016/4/19
     * @param:proid
     * @return: List<BdcQlr>
     * @description:根据proid获取权利人信息
     */
    public List<BdcQlr> getBdcQlrByProid(String proid);


    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @data:2016/4/19
     * @param:proid
     * @return:BdcZs
     * @description: 根据qlrid获取相应的证书信息
     */
    public BdcZs getBdcZsByQlrid(String proid);

    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @data:2016/4/19
     * @param:bdcdyid
     * @return:BdcBdcdy
     * @description:根据bdcdyid获取bdcdy
     */
    public BdcBdcdy getBdcdyById(String bdcdyid);

    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @data:2016/4/20
     * @param:proid
     * @return: List<BdcXmrel>
     * @description:根据proid获得bdc_xm_rel表
     */
    public List<BdcXmRel> getBdcXmRelByProid(String proid);
}
