/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import cn.gtmap.estateplat.utils.DESPlus;
import com.gtis.config.AppConfig;
import com.gtis.config.EncryptHelper;
import com.gtis.config.PropertyPlaceholderHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class AppConfigPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static Logger log = Logger.getLogger(AppConfigPlaceholderConfigurer.class);
    private static final PropertyPlaceholderHelper HELPER = new PropertyPlaceholderHelper("${", "}", ":", true);

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) {
        try {
            DESPlus des = new DESPlus();
            String password = props.getProperty("bdcdj.db.password");
            if (password != null) {
                props.setProperty("bdcdj.db.password", des.decrypt(password));
            }
            AppConfig.setConfiguration((Map)props);
            super.processProperties(beanFactoryToProcess, props);
        }
        catch (Exception e) {
            log.error((Object)"msg", (Throwable)e);
        }
    }

    protected Properties mergeProperties() throws IOException {
        Properties props = super.mergeProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String v = (String)entry.getValue();
            if (v == null || !v.startsWith("!!")) continue;
            entry.setValue(EncryptHelper.decrypt((String)v));
        }
        return props;
    }

    protected String parseStringValue(String strVal, final Properties props, Set visitedPlaceholders) {
        return HELPER.replacePlaceholders(strVal, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                return AppConfigPlaceholderConfigurer.this.resolvePlaceholder(placeholderName, props, 1);
            }
        });
    }
}

