package cn.gtmap.estateplat.service.config;
/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/12/11
 * @description 权利状态服务
 */

import cn.gtmap.estateplat.model.config.BdcCxBdcdyZt;
import cn.gtmap.estateplat.model.server.core.BdcCxZszmZt;
import cn.gtmap.estateplat.model.server.core.BdcZs;

import java.util.List;
import java.util.Map;

public interface QlztService {

    /**
     * @param cqzh(不动产权证号，房产证号，土地证号）；xmly：数据来源
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新证书证明查询表权利状态
     */
    Boolean updateZszmZtByCqzh(String cqzh, String xmly);

    /**
     * @param proid 项目主键
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新证书证明查询表权利状态
     */
    Boolean updateZszmZtByProid(String proid);

    /**
     * @param fwid 房屋id
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新证书证明查询表权利状态
     */
    Boolean updateZszmZtByFwid(String fwid);

    /**
     * @param tdid
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新证书证明查询表权利状态
     */
    Boolean updateZszmZtByTdid(String tdid);

    /**
     * @param bdcdyhList(不动产单元号）bdclx：不动产类型
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新不动产单元表权利状态
     */
    String updateBdcdyZtByBdcdyh(List<String> bdcdyhList, String bdclx);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * json List<BdcCxBdcdyZt> bdcCxBdcdyZtList(1为可售)
     * @Description:更新可售预售状态
     * @Date 11:04 2018/5/3
     */
    String updateKsYsByBdcdyh(String json);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:List<bdcZs>
     * @Description:通过参数证书删除证书证明状态管理记录
     * @Date 9:57 2018/1/2
     */
    Boolean updateZszmZtByDeleteEnvent(List<BdcZs> bdcZsList);


    /**
     * @param wiid 流程id
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 获取流程所有相关证号
     */
    List<Map<String, Object>> listCqzt(String wiid);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:常州云平台管理调用的获取状态方法
     * @Description:
     * @Date 8:58 2018/1/17
     */
    BdcCxZszmZt getZsZmztByCqzh(String cqzh);

    /**
     * @param json 不动产单元集合
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 不动产单元锁定
     */
    String bdcdySd(String json);


    /**
     * @param json 不动产单元集合
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 不动产单元解锁
     */
    String bdcdyJs(String json);

    /**
     * @Author:<a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @param:
     * @Description:查询不动产单元状态表
     * @Date 11:28 2019/02/26
     */
    List<BdcCxBdcdyZt> getBdcCxBdcdyZtList(Map map);

    /**
     * @param json 不动产单元集合
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @description 不动产单元是否备案
     */
    String bdcdySfba(String json);

    /**
     * @param bdcdyh 不动产单元号
     * @param djzt   登记状态
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 保存登记状态
     */
    void saveBdcDjzt(String bdcdyh, String djzt);
}
