package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.transition.QzFdcq2;

import java.util.List;

/**
 * 房地产权（独幢、层、套、间房屋）信息
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 15-11-19
 */
public interface QzFdcq2Service {

    /**
     * 根据权利编号和表名（视图名）获取房地产权（独幢、层、套、间房屋）信息
     *
     * @param qlbh
     * @param table
     * @return
     */
    public QzFdcq2 getQzFdcq2ByQlbh(String qlbh, String table);

    /**
     * 根据不动产单元编号和表名（视图名）获取房地产权（独幢、层、套、间房屋）信息
     *
     * @param bdcdybh
     * @param table
     * @return
     */
    public List<QzFdcq2> getQzFdcq2ListByBdcdybh(String bdcdybh, String table);

    /**
     * 根据业务信息业务号和表名（视图名）获取房地产权（独幢、层、套、间房屋）信息
     *
     * @param ywh
     * @param table
     * @return
     */
    public List<QzFdcq2> getQzFdcq2ListByYwh(String ywh, String table);
}
