package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.transition.QzTdsyq;

import java.util.List;

/**
 * 土地所有权信息接口
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 15-11-19
 */
public interface QzTdsyqService {

    /**
     * 根据权利编号和表名（视图名）获取土地使用权信息
     *
     * @param qlbh
     * @param table
     * @return
     */
    public QzTdsyq getQzTdsyqByQlbh(String qlbh, String table);

    /**
     * 根据不动产单元编号和表名（视图名）获取土地使用权信息
     *
     * @param bdcdybh
     * @param table
     * @return
     */
    public List<QzTdsyq> getQzTdsyqListByBdcdybh(String bdcdybh, String table);

    /**
     * 根据业务信息业务号和表名（视图名）获取土地使用权信息
     *
     * @param ywh
     * @param table
     * @return
     */
    public List<QzTdsyq> getQzTdsyqListByYwh(String ywh, String table);
}
