package cn.gtmap.estateplat.utils;

import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.*;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author hqz
 * @version 1.0, 2017/8/25
 * @description RSA加密工具类生成海洋局访问token
 */
public class RSATokenUtil {

    private static int MAXENCRYPTSIZE = 117;


    /**
     * 根据egov.home里的参数生成海洋局获取的token
     * @return token字符串
     */
    public static String getRSAToken(){
        String userId = AppConfig.getProperty("user.id");
        String token = "";
        if(StringUtils.isNotBlank(userId)){
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String nowStr = sm.format(now);
            String strMsg = userId + "|" + nowStr;
            try {
                PublicKey publicKey = getPublicKey();
                token  = encrypt(strMsg.getBytes(Charset.forName("utf-8")), publicKey);
                token = URLEncoder.encode(token,"utf-8");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return token;
    }



    public static PublicKey getPublicKey(){
        try{
            String modulus =AppConfig.getProperty("user.modulus");
            String exponent = AppConfig.getProperty("user.exponent");;
            byte[] m = decodeBase64(modulus);
            byte[] e = decodeBase64(exponent);
            BigInteger b1 = new BigInteger(1, m);
            BigInteger b2 = new BigInteger(1, e);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return keyFactory.generatePublic(keySpec);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }
    public static byte[] decodeBase64(String input) throws Exception{
        Class clazz=Class.forName("com.sun.org.apache.xerces.internal.impl.dv.util.Base64");
        Method mainMethod= clazz.getMethod("decode", String.class);
        mainMethod.setAccessible(true);
        Object retObj = mainMethod.invoke(null, input);
        return (byte[])retObj;
    }

    public static String encrypt(byte[] source, PublicKey publicKey) throws Exception {
        String encryptData ="";
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(Cipher.ENCRYPT_MODE, publicKey);
            int length = source.length;
            int offset = 0;
            byte[] cache;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            int i = 0;
            while (length - offset > 0) {
                if (length - offset > MAXENCRYPTSIZE){
                    cache = cipher.doFinal(source, offset, MAXENCRYPTSIZE);
                } else {
                    cache = cipher.doFinal(source, offset, length - offset);
                }
                outStream.write(cache, 0, cache.length);
                i++;
                offset = i * MAXENCRYPTSIZE;
            }
            return encodeBase64(outStream.toByteArray());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        } catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return encryptData;
    }

    public static String encodeBase64(byte[] input) throws Exception  {
        Class clazz = Class.forName("com.sun.org.apache.xerces.internal.impl.dv.util.Base64");
        Method mainMethod = clazz.getMethod("encode", byte[].class);
        mainMethod.setAccessible(true);
        Object retObj = mainMethod.invoke(null, new Object[] { input });
        return (String) retObj;
    }


}
