package cn.gtmap.estateplat.core.i18n;

import java.util.Locale;


/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-8-13
 */
public final class NLS {

    private static MessageProvider messageProvider = null;

    public void setMessageProvider(MessageProvider messageProvider) {
        NLS.messageProvider = messageProvider;
    }

    public static String get(String key) {
        return messageProvider == null ? null : messageProvider.getMessage(key, null, null, null);
    }

    public static String get(String key, Object... args) {
        return messageProvider == null ? null : messageProvider.getMessage(key, args, null, null);
    }

    public static String get(String key, String defaultMessage, Object... args) {
        return messageProvider == null ? null : messageProvider.getMessage(key, args, defaultMessage, null);
    }

    public static String get(String key, String defaultMessage, Locale locale, Object... args) {
        return messageProvider == null ? null : messageProvider.getMessage(key, args, defaultMessage, locale);
    }

}
