/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.log.resources;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.log.resources.ZrzyLog;
import cn.gtmap.estateplat.log.resources.ZrzyLogService;
import cn.gtmap.estateplat.model.resources.core.ZrzyXtRz;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.data.domain.Pageable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.ui.Model;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Aspect
public class ZrzyLogAspect {
    private ZrzyLogService zrzyLogService;
    private SysUserService sysUserService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final String ANONYMOUS_USER_ID = "-999";
    private static final String ANONYMOUS_USER_NAME = "\u533f\u540d\u7528\u6237";
    public static final String LOGIN_USER_IP = "login_user_ip";
    public static final String LOGIN_USER_MAC = "login_user_mac";
    public static final String LOGIN_USER_COMPUTERNAME = "login_user_computername";

    public void setZrzyLogService(ZrzyLogService zrzyLogService) {
        this.zrzyLogService = zrzyLogService;
    }

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    @Pointcut(value="@annotation(cn.gtmap.estateplat.log.resources.ZrzyLog)")
    public void zrzyLogServiceAspect() {
    }

    @Before(value="zrzyLogServiceAspect()")
    public void doBefore(JoinPoint joinPoint) {
        Method method = this.getMethod(joinPoint);
        ZrzyLog auditMethodLog = method.getAnnotation(ZrzyLog.class);
        String userId = StringUtils.isNotBlank((CharSequence)auditMethodLog.userId()) ? this.parseUserId(auditMethodLog.userId(), method, joinPoint.getArgs()) : null;
        this.zrzyLog(auditMethodLog.name(), this.getAuditContent(joinPoint, auditMethodLog), userId);
    }

    @After(value="zrzyLogServiceAspect()")
    public void doAfter(JoinPoint joinPoint) {
    }

    private void zrzyLog(String name, String content, String userId) {
        final ZrzyXtRz zrzyXtRz = new ZrzyXtRz();
        zrzyXtRz.setRzid(UUIDGenerator.generate());
        zrzyXtRz.setCzrq(Calendar.getInstance().getTime());
        if (StringUtils.isNotBlank((CharSequence)SessionUtil.getCurrentUserId())) {
            zrzyXtRz.setYhid(SessionUtil.getCurrentUserId());
            zrzyXtRz.setYhmc(SessionUtil.getCurrentUser().getUsername());
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            PfUserVo pfUserVo;
            zrzyXtRz.setYhid(userId);
            if (this.sysUserService != null && (pfUserVo = this.sysUserService.getUserVo(userId)) != null) {
                zrzyXtRz.setYhmc(pfUserVo.getUserName());
            }
        } else {
            zrzyXtRz.setYhid(ANONYMOUS_USER_ID);
            zrzyXtRz.setYhmc(ANONYMOUS_USER_NAME);
        }
        zrzyXtRz.setDyczff(name);
        zrzyXtRz.setFfcs(content);
        try {
            RequestAttributes ra = RequestContextHolder.getRequestAttributes();
            ServletRequestAttributes sra = (ServletRequestAttributes)ra;
            HttpServletRequest request = sra.getRequest();
            String ip = this.getRemoteAddress(request);
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                zrzyXtRz.setIp(ip);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                ZrzyLogAspect.this.zrzyLogService.saveZrzyXtRz(zrzyXtRz);
            }
        });
    }

    private ZrzyLog getMethodLog(JoinPoint joinPoint) {
        try {
            Method[] methods;
            String targetName = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            Object[] arguments = joinPoint.getArgs();
            Class<?> targetClass = Class.forName(targetName);
            for (Method method : methods = targetClass.getMethods()) {
                Class<?>[] clazzs;
                if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
                return method.getAnnotation(ZrzyLog.class);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AppException(e.getMessage());
        }
        return null;
    }

    private String getAuditContent(JoinPoint joinPoint, ZrzyLog zrzyLog) {
        HashMap contentMap = Maps.newHashMap();
        String description = null;
        description = StringUtils.isNotBlank((CharSequence)zrzyLog.description()) ? zrzyLog.description() : "\u64cd\u4f5c\u5185\u5bb9";
        contentMap.put(description, this.filterArguments(joinPoint.getArgs()));
        return JSON.toJSONString((Object)contentMap);
    }

    private Object filterArguments(Object[] args) {
        ArrayList arguments = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof Model || arg instanceof Pageable || arg instanceof RedirectAttributes || arg instanceof HttpServletResponse || arg instanceof HttpServletRequest) continue;
            arguments.add(arg);
        }
        return arguments;
    }

    private String parseUserId(String userId, Method method, Object[] args) {
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] paraNameArr = u.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < paraNameArr.length; ++i) {
            context.setVariable(paraNameArr[i], args[i]);
        }
        return (String)parser.parseExpression(userId).getValue((EvaluationContext)context, String.class);
    }

    private Method getMethod(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        Class[] argTypes = new Class[joinPoint.getArgs().length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Method method = null;
        try {
            method = joinPoint.getTarget().getClass().getMethod(joinPoint.getSignature().getName(), argTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return method;
    }

    private String getRemoteAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || ip.equalsIgnoreCase("unknown")) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || ip.equalsIgnoreCase("unknown")) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || ip.equalsIgnoreCase("unknown")) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

