package cn.gtmap.estateplat.service.exchange.share;

import cn.gtmap.estateplat.model.exchange.national.DataModel;
import cn.gtmap.estateplat.model.exchange.national.DjfDjYwxx;
import cn.gtmap.estateplat.model.exchange.national.QlfQlZxdj;

import java.util.List;
import java.util.Map;

/**
 * 不动产登记数据共享服务
 * @author <a href="mailto:shenjian@gtmap.cn">jane</a>
 * @version 1.0, 2015/12/20
 */
public interface RealEstateShareService {

    /**
     * 工作流程办结后将完整的不动产登记项目数据共享到共享库中
     * @param proid 不动产登记项目ID
     */
    void share2Database(String proid);

    /**
     * 工作流程办结后将完整的不动产登记项目数据共享到共享库中
     * @param wiid 不动产登记工作流项目ID
     */
    void share2DatabaseByWiid(String wiid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/3/15
     * @param proid 不动产登记项目ID
     * @description 根据不动产项目ID将在办项目的基本信息推送到共享库，不会插入权利信息，只会插入项目基本信息
     */
    void shareRunningProject2Db(String proid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param proid 不动产登记项目ID
     * @return
     * @description 根据不动产项目ID将在办、已登簿的项目的基本信息、权利信息、不动产单元信息推送到共享库
     */
    void shareRegisteredProject2Db(String proid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param wiid 不动产项目共组了实例ID
     * @return
     * @description 根据不动产项目工作流实例ID将在办、已登簿的项目的基本信息、权利信息、不动产单元信息推送到共享库
     */
    void shareRegisteredProject2DbByWiid(String wiid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/3/15
     * @param proid 不动产登记项目ID
     * @description 根据不动产项目ID将办结不动产登记项目的所有信息推送到共享库，如果共享库中项目已经存在，会更新项目基本信息
     */
    void shareFinishedProject2Db(String proid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/3/15
     * @param wiid 不动产登记工作流项目ID
     * @description 根据工作流项目ID将办结不动产登记项目的所有信息推送到共享库，如果共享库中项目已经存在，会更新项目基本信息
     */
    void shareFinishedProject2DbByWiid(String wiid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/3/15
     * @param proid 不动产登记项目ID
     * @param status 项目状态，其值参考字典项
     * @description 将不动产登记项目的当前状态共享到共享库中。可用于在流程办结、暂停或删除时更新共享库中不动产登记项目状态
     */
    void shareProjectStatus2Db(String proid,String status);


    /**
     * zdd 将国家汇交的业务信息对象   以及业务办理的项目信息  插入共享数据库   并更新原权利对应的权属状态
     * 此方法包含synchronizeDb(DjfDjYwxx djYwxx)  synchronizeQszt(String bdcqzh,Integer qszt)
     * @param dataModel 数据集插入共享数据库
     * @param djYwxx
     * @param recType 汇交国家业务类型
     * @throws Exception
     */
    void shareNationalDataModel2Db(DataModel dataModel, DjfDjYwxx djYwxx, String recType);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2017/4/6
     * @param proid 不动产登记项目ID
     * @param yBdcdyh 原不动产单元号
     * @param bdcdyh 不动产单元号
     * @return
     * @description 对共享库中不动产登记项目的不动产单元号进行更正，用bdcdyh替换yBdcdyh
     */
    void shareCorrectiveBdcdyh2Db(String proid,String yBdcdyh,String bdcdyh);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param wiid 不动产登记工作流项目ID
     * @rerutn
     * @description  根据工作流项目ID将公告信息推送到共享库
     */
    void shareAnnouncement2DbByWiid(String wiid);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param qlfQlZxdjList 注销数据集合
     * @rerutn
     * @description 通过参数存储注销数据并修改上一手权利状态
     */
    void shareCancellationData2Db(List<QlfQlZxdj> qlfQlZxdjList);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param proidList 当前项目proid集合
     * @param yproidList 上一手权利proid集合
     * @rerutn
     * @description 删除项目，更新当前项目信息终止，更新原权属状态
     */
    void shareDeleteProjectData2Db(List<String> proidList,List<String> yproidList);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param proidList 当前项目proid集合
     * @param yproidList 上一手权利proid集合
     * @rerutn
     * @description 退回项目，更新当前项目信息，更新原权属状态
     */
    void shareReturnProjectData2Db(List<String> proidList,List<String> yproidList);

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param proidList 需要查找的proid集合
     * @rerutn K-proid,V-qszt
     * @description 根据业务号查出共享库中对应权利数据的权属状态
     */
    List<Map<String,String>> queryQsztByYwh(List<String> proidList);


    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @param wiid 不动产登记工作流项目ID
     * @rerutn
     * @description  根据工作流项目ID将收费信息（包括业务信息、权利人信息）推送到共享库
     */
    void shareBdcSfxx2DbByWiid(String wiid);
}
