/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.ex;

import cn.gtmap.estateplat.core.ex.ErrorCode;
import cn.gtmap.estateplat.utils.Codecs;
import cn.gtmap.estateplat.utils.ExUtils;

public class AppException
extends RuntimeException
implements ErrorCode {
    private static final long serialVersionUID = 5052516665736233092L;
    private String id = Codecs.uuid(8);
    private int code = 1;
    private String message;
    private Object[] args;

    public AppException() {
    }

    public AppException(String message) {
        this.message = message;
    }

    public AppException(Throwable cause) {
        super(cause);
        this.code = ExUtils.parseCode(cause);
    }

    public AppException(String message, Throwable cause) {
        this(cause);
        this.message = message;
    }

    public AppException(int code, Object ... args) {
        this.code = code;
        this.args = args;
    }

    public AppException(String message, int code, Object ... args) {
        this(code, args);
        this.message = message;
    }

    public AppException(Throwable cause, int code, Object ... args) {
        super(cause);
        this.code = code;
        this.args = args;
    }

    public AppException(String message, Throwable cause, int code, Object ... args) {
        super(cause);
        this.message = message;
        this.code = code;
        this.args = args;
    }

    public String getId() {
        return this.id;
    }

    public int getCode() {
        return this.code;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getStack() {
        return ExUtils.buildStackTrace(this);
    }

    @Override
    public String getMessage() {
        return ExUtils.buildMessage(this.code, this.args, this.message, this.getCause());
    }

    public String getSimpleMessage() {
        return ExUtils.buildMessage(this.code, this.args, this.message, null);
    }

    public String getSourceMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

