/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import com.google.common.collect.Lists;
import com.lambdaworks.redis.event.DefaultEventBus;
import com.lambdaworks.redis.event.DefaultEventPublisherOptions;
import com.lambdaworks.redis.event.EventBus;
import com.lambdaworks.redis.event.EventPublisherOptions;
import com.lambdaworks.redis.event.metrics.DefaultCommandLatencyEventPublisher;
import com.lambdaworks.redis.event.metrics.MetricEventPublisher;
import com.lambdaworks.redis.metrics.CommandLatencyCollector;
import com.lambdaworks.redis.metrics.CommandLatencyCollectorOptions;
import com.lambdaworks.redis.metrics.DefaultCommandLatencyCollector;
import com.lambdaworks.redis.metrics.DefaultCommandLatencyCollectorOptions;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.DefaultEventLoopGroupProvider;
import com.lambdaworks.redis.resource.EventLoopGroupProvider;
import com.lambdaworks.redis.resource.Futures;
import com.lambdaworks.redis.resource.RxJavaEventExecutorGroupScheduler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class DefaultClientResources
implements ClientResources {
    protected static final InternalLogger logger;
    public static final int MIN_IO_THREADS = 3;
    public static final int MIN_COMPUTATION_THREADS = 3;
    public static final int DEFAULT_IO_THREADS;
    public static final int DEFAULT_COMPUTATION_THREADS;
    private final boolean sharedEventLoopGroupProvider;
    private final EventLoopGroupProvider eventLoopGroupProvider;
    private final boolean sharedEventExecutor;
    private final EventExecutorGroup eventExecutorGroup;
    private final EventBus eventBus;
    private final CommandLatencyCollector commandLatencyCollector;
    private final boolean sharedCommandLatencyCollector;
    private final EventPublisherOptions commandLatencyPublisherOptions;
    private final MetricEventPublisher metricEventPublisher;
    private volatile boolean shutdownCalled = false;

    protected DefaultClientResources(Builder builder) {
        if (builder.eventLoopGroupProvider == null) {
            int ioThreadPoolSize = builder.ioThreadPoolSize;
            if (ioThreadPoolSize < 3) {
                logger.info("ioThreadPoolSize is less than {} ({}), setting to: {}", new Object[]{3, ioThreadPoolSize, 3});
                ioThreadPoolSize = 3;
            }
            this.sharedEventLoopGroupProvider = false;
            this.eventLoopGroupProvider = new DefaultEventLoopGroupProvider(ioThreadPoolSize);
        } else {
            this.sharedEventLoopGroupProvider = true;
            this.eventLoopGroupProvider = builder.eventLoopGroupProvider;
        }
        if (builder.eventExecutorGroup == null) {
            int computationThreadPoolSize = builder.computationThreadPoolSize;
            if (computationThreadPoolSize < 3) {
                logger.info("computationThreadPoolSize is less than {} ({}), setting to: {}", new Object[]{3, computationThreadPoolSize, 3});
                computationThreadPoolSize = 3;
            }
            this.eventExecutorGroup = DefaultEventLoopGroupProvider.createEventLoopGroup(DefaultEventExecutorGroup.class, computationThreadPoolSize);
            this.sharedEventExecutor = false;
        } else {
            this.sharedEventExecutor = true;
            this.eventExecutorGroup = builder.eventExecutorGroup;
        }
        this.eventBus = builder.eventBus == null ? new DefaultEventBus(new RxJavaEventExecutorGroupScheduler(this.eventExecutorGroup)) : builder.eventBus;
        if (builder.commandLatencyCollector == null) {
            this.commandLatencyCollector = builder.commandLatencyCollectorOptions != null ? new DefaultCommandLatencyCollector(builder.commandLatencyCollectorOptions) : new DefaultCommandLatencyCollector(DefaultCommandLatencyCollectorOptions.create());
            this.sharedCommandLatencyCollector = false;
        } else {
            this.sharedCommandLatencyCollector = true;
            this.commandLatencyCollector = builder.commandLatencyCollector;
        }
        this.commandLatencyPublisherOptions = builder.commandLatencyPublisherOptions;
        this.metricEventPublisher = this.commandLatencyCollector.isEnabled() && this.commandLatencyPublisherOptions != null ? new DefaultCommandLatencyEventPublisher(this.eventExecutorGroup, this.commandLatencyPublisherOptions, this.eventBus, this.commandLatencyCollector) : null;
    }

    protected void finalize() throws Throwable {
        if (!this.shutdownCalled) {
            logger.warn(this.getClass().getName() + " was not shut down properly, shutdown() was not called before it's garbage-collected. Call shutdown() or shutdown(long,long,TimeUnit) ");
        }
        super.finalize();
    }

    @Override
    public Future<Boolean> shutdown() {
        return this.shutdown(2L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public Future<Boolean> shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        Future shutdown;
        this.shutdownCalled = true;
        DefaultPromise overall = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        DefaultPromise lastRelease = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        Futures.PromiseAggregator aggregator = new Futures.PromiseAggregator(overall);
        aggregator.expectMore(1);
        if (!this.sharedEventLoopGroupProvider) {
            aggregator.expectMore(1);
        }
        if (!this.sharedEventExecutor) {
            aggregator.expectMore(1);
        }
        aggregator.arm();
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.shutdown();
        }
        if (!this.sharedEventLoopGroupProvider) {
            shutdown = this.eventLoopGroupProvider.shutdown(quietPeriod, timeout, timeUnit);
            if (shutdown instanceof Promise) {
                aggregator.add((Promise)shutdown);
            } else {
                aggregator.add(Futures.toBooleanPromise(shutdown));
            }
        }
        if (!this.sharedEventExecutor) {
            shutdown = this.eventExecutorGroup.shutdownGracefully(quietPeriod, timeout, timeUnit);
            aggregator.add(Futures.toBooleanPromise(shutdown));
        }
        if (!this.sharedCommandLatencyCollector) {
            this.commandLatencyCollector.shutdown();
        }
        aggregator.add(new Promise[]{lastRelease});
        lastRelease.setSuccess(null);
        return Futures.toBooleanPromise(overall);
    }

    @Override
    public EventLoopGroupProvider eventLoopGroupProvider() {
        return this.eventLoopGroupProvider;
    }

    @Override
    public EventExecutorGroup eventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    @Override
    public int ioThreadPoolSize() {
        return this.eventLoopGroupProvider.threadPoolSize();
    }

    @Override
    public int computationThreadPoolSize() {
        return Lists.newArrayList((Iterator)this.eventExecutorGroup.iterator()).size();
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public CommandLatencyCollector commandLatencyCollector() {
        return this.commandLatencyCollector;
    }

    @Override
    public EventPublisherOptions commandLatencyPublisherOptions() {
        return this.commandLatencyPublisherOptions;
    }

    public static DefaultClientResources create() {
        return new Builder().build();
    }

    static {
        int threads;
        logger = InternalLoggerFactory.getInstance(DefaultClientResources.class);
        DEFAULT_IO_THREADS = threads = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)Runtime.getRuntime().availableProcessors()));
        DEFAULT_COMPUTATION_THREADS = threads;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)threads);
        }
    }

    public static class Builder {
        private int ioThreadPoolSize = DEFAULT_IO_THREADS;
        private int computationThreadPoolSize = DEFAULT_COMPUTATION_THREADS;
        private EventExecutorGroup eventExecutorGroup;
        private EventLoopGroupProvider eventLoopGroupProvider;
        private EventBus eventBus;
        private CommandLatencyCollectorOptions commandLatencyCollectorOptions = DefaultCommandLatencyCollectorOptions.create();
        private CommandLatencyCollector commandLatencyCollector;
        private EventPublisherOptions commandLatencyPublisherOptions = DefaultEventPublisherOptions.create();

        public Builder ioThreadPoolSize(int ioThreadPoolSize) {
            this.ioThreadPoolSize = ioThreadPoolSize;
            return this;
        }

        public Builder eventLoopGroupProvider(EventLoopGroupProvider eventLoopGroupProvider) {
            this.eventLoopGroupProvider = eventLoopGroupProvider;
            return this;
        }

        public Builder computationThreadPoolSize(int computationThreadPoolSize) {
            this.computationThreadPoolSize = computationThreadPoolSize;
            return this;
        }

        public Builder eventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
            this.eventExecutorGroup = eventExecutorGroup;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Builder commandLatencyPublisherOptions(EventPublisherOptions commandLatencyPublisherOptions) {
            this.commandLatencyPublisherOptions = commandLatencyPublisherOptions;
            return this;
        }

        public Builder commandLatencyCollectorOptions(CommandLatencyCollectorOptions commandLatencyCollectorOptions) {
            this.commandLatencyCollectorOptions = commandLatencyCollectorOptions;
            return this;
        }

        public Builder commandLatencyCollector(CommandLatencyCollector commandLatencyCollector) {
            this.commandLatencyCollector = commandLatencyCollector;
            return this;
        }

        public DefaultClientResources build() {
            return new DefaultClientResources(this);
        }
    }
}

