/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisClusterConnection;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.ClusterClientOptions;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.ClusterNodeCommandHandler;
import com.lambdaworks.redis.cluster.ClusterTopologyRefresh;
import com.lambdaworks.redis.cluster.PooledClusterConnectionProvider;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterAsyncConnection;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterAsyncConnectionImpl;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterConnection;
import com.lambdaworks.redis.cluster.event.ClusterTopologyChangedEvent;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RedisClusterClient
extends AbstractRedisClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClusterClient.class);
    protected AtomicBoolean clusterTopologyRefreshActivated = new AtomicBoolean(false);
    private ClusterTopologyRefresh refresh = new ClusterTopologyRefresh(this);
    private Partitions partitions;
    private Iterable<RedisURI> initialUris = ImmutableSet.of();

    private RedisClusterClient() {
        this.setOptions(ClusterClientOptions.create());
    }

    @Deprecated
    public RedisClusterClient(RedisURI initialUri) {
        this((List<RedisURI>)ImmutableList.of((Object)Preconditions.checkNotNull((Object)initialUri, (Object)"RedisURI (initial uri) must not be null")));
    }

    @Deprecated
    public RedisClusterClient(List<RedisURI> redisURIs) {
        this(null, redisURIs);
    }

    protected RedisClusterClient(ClientResources clientResources, Iterable<RedisURI> redisURIs) {
        super(clientResources);
        RedisClusterClient.assertNotEmpty(redisURIs);
        this.initialUris = redisURIs;
        this.setDefaultTimeout(this.getFirstUri().getTimeout(), this.getFirstUri().getUnit());
        this.setOptions(new ClusterClientOptions.Builder().build());
    }

    public static RedisClusterClient create(RedisURI redisURI) {
        RedisClusterClient.assertNotNull(redisURI);
        return RedisClusterClient.create((Iterable<RedisURI>)ImmutableList.of((Object)redisURI));
    }

    public static RedisClusterClient create(Iterable<RedisURI> redisURIs) {
        RedisClusterClient.assertNotEmpty(redisURIs);
        return new RedisClusterClient(null, redisURIs);
    }

    public static RedisClusterClient create(String uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        return RedisClusterClient.create(RedisURI.create(uri));
    }

    public static RedisClusterClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisClusterClient.assertNotNull(clientResources);
        RedisClusterClient.assertNotNull(redisURI);
        return RedisClusterClient.create(clientResources, (Iterable<RedisURI>)ImmutableList.of((Object)redisURI));
    }

    public static RedisClusterClient create(ClientResources clientResources, String uri) {
        RedisClusterClient.assertNotNull(clientResources);
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        return RedisClusterClient.create(clientResources, RedisURI.create(uri));
    }

    public static RedisClusterClient create(ClientResources clientResources, Iterable<RedisURI> redisURIs) {
        RedisClusterClient.assertNotNull(clientResources);
        RedisClusterClient.assertNotEmpty(redisURIs);
        return new RedisClusterClient(clientResources, redisURIs);
    }

    public RedisAdvancedClusterConnection<String, String> connectCluster() {
        return this.connectCluster(this.newStringStringCodec());
    }

    public <K, V> RedisAdvancedClusterConnection<K, V> connectCluster(RedisCodec<K, V> codec) {
        RedisClusterClient.assertNotNull(codec);
        return (RedisAdvancedClusterConnection)RedisClusterClient.syncHandler(this.connectClusterAsyncImpl(codec), RedisAdvancedClusterConnection.class, RedisClusterConnection.class);
    }

    public RedisAdvancedClusterAsyncConnection<String, String> connectClusterAsync() {
        return this.connectClusterAsyncImpl(this.newStringStringCodec(), this.getSocketAddressSupplier());
    }

    public <K, V> RedisAdvancedClusterAsyncConnection<K, V> connectClusterAsync(RedisCodec<K, V> codec) {
        RedisClusterClient.assertNotNull(codec);
        return this.connectClusterAsyncImpl(codec, this.getSocketAddressSupplier());
    }

    protected RedisAsyncConnectionImpl<String, String> connectAsyncImpl(final SocketAddress socketAddress) {
        return this.connectNode(this.newStringStringCodec(), socketAddress.toString(), null, new Supplier<SocketAddress>(){

            public SocketAddress get() {
                return socketAddress;
            }
        });
    }

    <K, V> RedisAsyncConnectionImpl<K, V> connectNode(RedisCodec<K, V> codec, String nodeId, RedisChannelWriter<K, V> clusterWriter, Supplier<SocketAddress> socketAddressSupplier) {
        logger.debug("connectNode(" + nodeId + ")");
        ArrayDeque queue = new ArrayDeque();
        ClusterNodeCommandHandler handler = new ClusterNodeCommandHandler(this.clientOptions, this.clientResources, queue, clusterWriter);
        RedisAsyncConnectionImpl connection = this.newRedisAsyncConnectionImpl(handler, codec, this.timeout, this.unit);
        this.connectAsyncImpl(handler, connection, socketAddressSupplier);
        connection.registerCloseables(this.closeableResources, connection);
        RedisURI redisURI = this.initialUris.iterator().next();
        if (redisURI.getPassword() != null && redisURI.getPassword().length != 0) {
            connection.auth(new String(redisURI.getPassword()));
        }
        return connection;
    }

    <K, V> RedisAsyncConnectionImpl<K, V> connectClusterAsyncImpl(RedisCodec<K, V> codec) {
        return this.connectClusterAsyncImpl(codec, this.getSocketAddressSupplier());
    }

    <K, V> RedisAdvancedClusterAsyncConnectionImpl<K, V> connectClusterAsyncImpl(RedisCodec<K, V> codec, Supplier<SocketAddress> socketAddressSupplier) {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        this.activateTopologyRefreshIfNeeded();
        logger.debug("connectCluster(" + socketAddressSupplier.get() + ")");
        ArrayDeque queue = new ArrayDeque();
        CommandHandler handler = new CommandHandler(this.clientOptions, this.clientResources, queue);
        ClusterDistributionChannelWriter clusterWriter = new ClusterDistributionChannelWriter(handler);
        PooledClusterConnectionProvider pooledClusterConnectionProvider = new PooledClusterConnectionProvider(this, clusterWriter, codec);
        clusterWriter.setClusterConnectionProvider(pooledClusterConnectionProvider);
        RedisAdvancedClusterAsyncConnectionImpl connection = this.newRedisAdvancedClusterAsyncConnectionImpl(clusterWriter, codec, this.timeout, this.unit);
        connection.setReadFrom(ReadFrom.MASTER);
        connection.setPartitions(this.partitions);
        this.connectAsyncImpl(handler, connection, socketAddressSupplier);
        connection.registerCloseables(this.closeableResources, connection, clusterWriter, pooledClusterConnectionProvider);
        if (this.getFirstUri().getPassword() != null) {
            connection.auth(new String(this.getFirstUri().getPassword()));
        }
        return connection;
    }

    public void reloadPartitions() {
        if (this.partitions == null) {
            this.initializePartitions();
            this.partitions.updateCache();
        } else {
            Partitions loadedPartitions = this.loadPartitions();
            if (ClusterTopologyRefresh.isChanged(this.getPartitions(), loadedPartitions)) {
                ImmutableList before = ImmutableList.copyOf((Collection)this.getPartitions());
                ImmutableList after = ImmutableList.copyOf((Collection)loadedPartitions);
                this.getResources().eventBus().publish(new ClusterTopologyChangedEvent((List<RedisClusterNode>)before, (List<RedisClusterNode>)after));
            }
            this.partitions.getPartitions().clear();
            this.partitions.getPartitions().addAll(loadedPartitions.getPartitions());
            this.partitions.reload(loadedPartitions.getPartitions());
        }
        this.updatePartitionsInConnections();
    }

    protected void updatePartitionsInConnections() {
        this.forEachClusterConnection(new Predicate<RedisAdvancedClusterAsyncConnectionImpl<?, ?>>(){

            public boolean apply(RedisAdvancedClusterAsyncConnectionImpl<?, ?> input) {
                input.setPartitions(RedisClusterClient.this.partitions);
                return true;
            }
        });
    }

    protected void initializePartitions() {
        Partitions loadedPartitions;
        this.partitions = loadedPartitions = this.loadPartitions();
    }

    public Partitions getPartitions() {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        return this.partitions;
    }

    protected Partitions loadPartitions() {
        Map<RedisURI, Partitions> partitions = this.refresh.loadViews(this.initialUris);
        if (partitions.isEmpty()) {
            throw new RedisException("Cannot retrieve initial cluster partitions from initial URIs " + this.initialUris);
        }
        Partitions loadedPartitions = partitions.values().iterator().next();
        RedisURI viewedBy = this.refresh.getViewedBy(partitions, loadedPartitions);
        for (RedisClusterNode partition : loadedPartitions) {
            if (viewedBy == null || viewedBy.getPassword() == null) continue;
            partition.getUri().setPassword(new String(viewedBy.getPassword()));
        }
        this.activateTopologyRefreshIfNeeded();
        return loadedPartitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateTopologyRefreshIfNeeded() {
        ClusterClientOptions options;
        if (this.getOptions() instanceof ClusterClientOptions && (options = (ClusterClientOptions)this.getOptions()).isRefreshClusterView()) {
            AtomicBoolean atomicBoolean = this.clusterTopologyRefreshActivated;
            synchronized (atomicBoolean) {
                if (!this.clusterTopologyRefreshActivated.get()) {
                    ClusterTopologyRefreshTask r = new ClusterTopologyRefreshTask();
                    this.genericWorkerPool.scheduleAtFixedRate((Runnable)r, options.getRefreshPeriod(), options.getRefreshPeriod(), options.getRefreshPeriodUnit());
                    this.clusterTopologyRefreshActivated.set(true);
                }
            }
        }
    }

    protected boolean isEventLoopActive() {
        return !this.genericWorkerPool.isShuttingDown() && !this.genericWorkerPool.isShutdown() && !this.genericWorkerPool.isTerminated();
    }

    protected <K, V> RedisAsyncConnectionImpl<K, V> newRedisAsyncConnectionImpl(RedisChannelWriter<K, V> channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new RedisAsyncConnectionImpl<K, V>(channelWriter, codec, timeout, unit);
    }

    protected <K, V> RedisAdvancedClusterAsyncConnectionImpl<K, V> newRedisAdvancedClusterAsyncConnectionImpl(RedisChannelWriter<K, V> channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new RedisAdvancedClusterAsyncConnectionImpl<K, V>(channelWriter, codec, timeout, unit);
    }

    protected RedisURI getFirstUri() {
        RedisClusterClient.assertNotEmpty(this.initialUris);
        Iterator<RedisURI> iterator = this.initialUris.iterator();
        return iterator.next();
    }

    private Supplier<SocketAddress> getSocketAddressSupplier() {
        return new Supplier<SocketAddress>(){

            public SocketAddress get() {
                if (RedisClusterClient.this.partitions != null) {
                    List ordered = RedisClusterClient.this.getOrderedPartitions(RedisClusterClient.this.partitions);
                    for (RedisClusterNode partition : ordered) {
                        if (partition.getUri() == null || partition.getUri().getResolvedAddress() == null) continue;
                        SocketAddress resolvedAddress = partition.getUri().getResolvedAddress();
                        logger.debug("Resolved SocketAddress {} using for Cluster node {}", (Object)resolvedAddress, (Object)partition.getNodeId());
                        return resolvedAddress;
                    }
                }
                SocketAddress socketAddress = RedisClusterClient.this.getFirstUri().getResolvedAddress();
                logger.debug("Resolved SocketAddress {} using {}", (Object)socketAddress, (Object)RedisClusterClient.this.getFirstUri());
                return socketAddress;
            }
        };
    }

    private List<RedisClusterNode> getOrderedPartitions(Iterable<RedisClusterNode> clusterNodes) {
        ArrayList ordered = Lists.newArrayList(clusterNodes);
        Collections.sort(ordered, new Comparator<RedisClusterNode>(){

            @Override
            public int compare(RedisClusterNode o1, RedisClusterNode o2) {
                return ClusterTopologyRefresh.RedisUriComparator.INSTANCE.compare(o1.getUri(), o2.getUri());
            }
        });
        return ordered;
    }

    protected Utf8StringCodec newStringStringCodec() {
        return new Utf8StringCodec();
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    protected void forEachClusterConnection(Predicate<RedisAdvancedClusterAsyncConnectionImpl<?, ?>> function) {
        this.forEachCloseable((Predicate<? super Closeable>)new Predicate<Closeable>(){

            public boolean apply(Closeable input) {
                return input instanceof RedisAdvancedClusterAsyncConnectionImpl;
            }
        }, function);
    }

    protected <T extends Closeable> void forEachCloseable(Predicate<? super Closeable> selector, Predicate<T> function) {
        for (Closeable c : this.closeableResources) {
            if (!selector.apply((Object)c)) continue;
            function.apply((Object)c);
        }
    }

    public void setOptions(ClusterClientOptions clientOptions) {
        super.setOptions(clientOptions);
    }

    ClusterClientOptions getClusterClientOptions() {
        if (this.getOptions() instanceof ClusterClientOptions) {
            return (ClusterClientOptions)this.getOptions();
        }
        return null;
    }

    boolean expireStaleConnections() {
        return this.getClusterClientOptions() == null || this.getClusterClientOptions().isCloseStaleConnections();
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
    }

    private static void assertNotEmpty(Iterable<RedisURI> redisURIs) {
        Preconditions.checkArgument((redisURIs != null ? 1 : 0) != 0, (Object)"RedisURIs must not be null");
        Preconditions.checkArgument((boolean)redisURIs.iterator().hasNext(), (Object)"RedisURIs must not be empty");
    }

    private static void assertNotNull(RedisURI redisURI) {
        Preconditions.checkArgument((redisURI != null ? 1 : 0) != 0, (Object)"RedisURI must not be null");
    }

    private static void assertNotNull(ClientResources clientResources) {
        Preconditions.checkArgument((clientResources != null ? 1 : 0) != 0, (Object)"ClientResources must not be null");
    }

    private class CloseStaleConnectionsTask
    implements Runnable {
        private CloseStaleConnectionsTask() {
        }

        @Override
        public void run() {
            if (RedisClusterClient.this.isEventLoopActive() && RedisClusterClient.this.expireStaleConnections()) {
                RedisClusterClient.this.forEachClusterConnection(new Predicate<RedisAdvancedClusterAsyncConnectionImpl<?, ?>>(){

                    public boolean apply(RedisAdvancedClusterAsyncConnectionImpl<?, ?> input) {
                        ClusterDistributionChannelWriter writer = (ClusterDistributionChannelWriter)input.getChannelWriter();
                        writer.getClusterConnectionProvider().closeStaleConnections();
                        return true;
                    }
                });
            }
        }
    }

    private class ClusterTopologyRefreshTask
    implements Runnable {
        @Override
        public void run() {
            Iterable seed;
            logger.debug("ClusterTopologyRefreshTask.run()");
            if (RedisClusterClient.this.isEventLoopActive() && RedisClusterClient.this.getClusterClientOptions() != null) {
                if (!RedisClusterClient.this.getClusterClientOptions().isRefreshClusterView()) {
                    logger.debug("ClusterTopologyRefreshTask is disabled");
                    return;
                }
            } else {
                logger.debug("ClusterTopologyRefreshTask is disabled");
                return;
            }
            if (RedisClusterClient.this.partitions == null || RedisClusterClient.this.partitions.size() == 0) {
                seed = RedisClusterClient.this.initialUris;
            } else {
                ArrayList uris = Lists.newArrayList();
                for (RedisClusterNode partition : RedisClusterClient.this.getOrderedPartitions(RedisClusterClient.this.partitions)) {
                    uris.add(partition.getUri());
                }
                seed = uris;
            }
            logger.debug("ClusterTopologyRefreshTask requesting partitions from {}", (Object)seed);
            Map<RedisURI, Partitions> partitions = RedisClusterClient.this.refresh.loadViews(seed);
            ArrayList values = Lists.newArrayList(partitions.values());
            if (!values.isEmpty() && ClusterTopologyRefresh.isChanged(RedisClusterClient.this.getPartitions(), (Partitions)values.get(0))) {
                logger.debug("Using a new cluster topology");
                ImmutableList before = ImmutableList.copyOf((Collection)RedisClusterClient.this.getPartitions());
                ImmutableList after = ImmutableList.copyOf(((Partitions)values.get(0)).getPartitions());
                RedisClusterClient.this.getResources().eventBus().publish(new ClusterTopologyChangedEvent((List<RedisClusterNode>)before, (List<RedisClusterNode>)after));
                RedisClusterClient.this.getPartitions().reload(((Partitions)values.get(0)).getPartitions());
                RedisClusterClient.this.updatePartitionsInConnections();
                if (RedisClusterClient.this.isEventLoopActive() && RedisClusterClient.this.expireStaleConnections()) {
                    RedisClusterClient.this.genericWorkerPool.submit((Runnable)new CloseStaleConnectionsTask());
                }
            }
        }
    }
}

