/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.CloseEvents;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisClusterConnection;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisConnectionProvider;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisSentinelAsyncConnection;
import com.lambdaworks.redis.RedisSentinelAsyncConnectionImpl;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.SslConnectionBuilder;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubConnectionImpl;
import com.lambdaworks.redis.resource.ClientResources;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RedisClient
extends AbstractRedisClient {
    private final RedisURI redisURI;

    protected RedisClient(ClientResources clientResources, RedisURI redisURI) {
        super(clientResources);
        this.redisURI = redisURI;
    }

    @Deprecated
    public RedisClient() {
        super(null);
        this.redisURI = null;
        this.setDefaultTimeout(60L, TimeUnit.MINUTES);
    }

    @Deprecated
    public RedisClient(String host) {
        this(host, 6379);
    }

    @Deprecated
    public RedisClient(String host, int port) {
        this(RedisURI.Builder.redis(host, port).build());
    }

    @Deprecated
    public RedisClient(RedisURI redisURI) {
        this.redisURI = redisURI;
        this.setDefaultTimeout(redisURI.getTimeout(), redisURI.getUnit());
    }

    public static RedisClient create() {
        return new RedisClient(null, null);
    }

    public static RedisClient create(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(null, redisURI);
    }

    public static RedisClient create(String uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        return new RedisClient(null, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources) {
        RedisClient.assertNotNull(clientResources);
        return new RedisClient(clientResources, null);
    }

    public static RedisClient create(ClientResources clientResources, String uri) {
        RedisClient.assertNotNull(clientResources);
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        return RedisClient.create(clientResources, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisClient.assertNotNull(clientResources);
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(clientResources, redisURI);
    }

    public RedisConnectionPool<RedisConnection<String, String>> pool() {
        return this.pool(5, 20);
    }

    public RedisConnectionPool<RedisConnection<String, String>> pool(int maxIdle, int maxActive) {
        return this.pool(this.newStringStringCodec(), maxIdle, maxActive);
    }

    public <K, V> RedisConnectionPool<RedisConnection<K, V>> pool(final RedisCodec<K, V> codec, int maxIdle, int maxActive) {
        this.checkForRedisURI();
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        long maxWait = this.makeTimeout();
        RedisConnectionPool<RedisConnection<K, V>> pool = new RedisConnectionPool<RedisConnection<K, V>>(new RedisConnectionProvider<RedisConnection<K, V>>(){

            @Override
            public RedisConnection<K, V> createConnection() {
                return RedisClient.this.connect(codec, RedisClient.this.redisURI);
            }

            @Override
            public Class<? extends RedisConnection<K, V>> getComponentType() {
                return RedisConnection.class;
            }
        }, maxActive, maxIdle, maxWait);
        pool.addListener(new CloseEvents.CloseListener(){

            @Override
            public void resourceClosed(Object resource) {
                RedisClient.this.closeableResources.remove(resource);
            }
        });
        this.closeableResources.add(pool);
        return pool;
    }

    protected long makeTimeout() {
        return TimeUnit.MILLISECONDS.convert(this.timeout, this.unit);
    }

    private void checkForRedisURI() {
        Preconditions.checkState((this.redisURI != null ? 1 : 0) != 0, (Object)"RedisURI is not available. Use RedisClient(Host), RedisClient(Host, Port) or RedisClient(RedisURI) to construct your client.");
        this.checkValidRedisURI(this.redisURI);
    }

    public RedisConnectionPool<RedisAsyncConnection<String, String>> asyncPool() {
        return this.asyncPool(5, 20);
    }

    public RedisConnectionPool<RedisAsyncConnection<String, String>> asyncPool(int maxIdle, int maxActive) {
        return this.asyncPool(this.newStringStringCodec(), maxIdle, maxActive);
    }

    public <K, V> RedisConnectionPool<RedisAsyncConnection<K, V>> asyncPool(final RedisCodec<K, V> codec, int maxIdle, int maxActive) {
        this.checkForRedisURI();
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        long maxWait = this.makeTimeout();
        RedisConnectionPool<RedisAsyncConnection<K, V>> pool = new RedisConnectionPool<RedisAsyncConnection<K, V>>(new RedisConnectionProvider<RedisAsyncConnection<K, V>>(){

            @Override
            public RedisAsyncConnection<K, V> createConnection() {
                return RedisClient.this.connectAsync(codec, RedisClient.this.redisURI);
            }

            @Override
            public Class<? extends RedisAsyncConnection<K, V>> getComponentType() {
                return RedisAsyncConnection.class;
            }
        }, maxActive, maxIdle, maxWait);
        pool.addListener(new CloseEvents.CloseListener(){

            @Override
            public void resourceClosed(Object resource) {
                RedisClient.this.closeableResources.remove(resource);
            }
        });
        this.closeableResources.add(pool);
        return pool;
    }

    public RedisConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> RedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connect(codec, this.redisURI);
    }

    public RedisConnection<String, String> connect(RedisURI redisURI) {
        return this.connect(this.newStringStringCodec(), redisURI);
    }

    public <K, V> RedisConnection connect(RedisCodec<K, V> codec, RedisURI redisURI) {
        return (RedisConnection)RedisClient.syncHandler((RedisChannelHandler)((Object)this.connectAsync(codec, redisURI)), RedisConnection.class, RedisClusterConnection.class);
    }

    public RedisAsyncConnection<String, String> connectAsync() {
        return this.connectAsync(this.newStringStringCodec());
    }

    public <K, V> RedisAsyncConnection<K, V> connectAsync(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectAsync(codec, this.redisURI);
    }

    public RedisAsyncConnection<String, String> connectAsync(RedisURI redisURI) {
        this.checkValidRedisURI(redisURI);
        return this.connectAsync(this.newStringStringCodec(), redisURI);
    }

    public <K, V> RedisAsyncConnection<K, V> connectAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        this.checkValidRedisURI(redisURI);
        ArrayDeque queue = new ArrayDeque();
        CommandHandler handler = new CommandHandler(this.clientOptions, this.clientResources, queue);
        RedisAsyncConnectionImpl connection = this.newRedisAsyncConnectionImpl(handler, codec, this.timeout, this.unit);
        this.connectAsync(handler, connection, redisURI);
        return connection;
    }

    private <K, V> void connectAsync(CommandHandler<K, V> handler, RedisAsyncConnectionImpl<K, V> connection, RedisURI redisURI) {
        ConnectionBuilder connectionBuilder;
        if (redisURI.isSsl()) {
            SslConnectionBuilder sslConnectionBuilder = SslConnectionBuilder.sslConnectionBuilder();
            sslConnectionBuilder.ssl(redisURI);
            connectionBuilder = sslConnectionBuilder;
        } else {
            connectionBuilder = ConnectionBuilder.connectionBuilder();
        }
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        this.connectionBuilder(handler, connection, this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        this.channelType(connectionBuilder, redisURI);
        this.initializeChannel(connectionBuilder);
        if (redisURI.getPassword() != null && redisURI.getPassword().length != 0) {
            connection.auth(new String(redisURI.getPassword()));
        }
        if (redisURI.getDatabase() != 0) {
            connection.select(redisURI.getDatabase());
        }
    }

    public RedisPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub(this.newStringStringCodec());
    }

    public RedisPubSubConnection<String, String> connectPubSub(RedisURI redisURI) {
        this.checkValidRedisURI(redisURI);
        return this.connectPubSub(this.newStringStringCodec(), redisURI);
    }

    public <K, V> RedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectPubSub(codec, this.redisURI);
    }

    public <K, V> RedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec, RedisURI redisURI) {
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        this.checkValidRedisURI(redisURI);
        ArrayDeque queue = new ArrayDeque();
        PubSubCommandHandler handler = new PubSubCommandHandler(this.clientOptions, this.clientResources, queue, codec);
        RedisPubSubConnectionImpl connection = this.newRedisPubSubConnectionImpl(handler, codec, this.timeout, this.unit);
        this.connectAsync(handler, connection, redisURI);
        return connection;
    }

    public RedisSentinelAsyncConnection<String, String> connectSentinelAsync() {
        return this.connectSentinelAsync(this.newStringStringCodec());
    }

    public <K, V> RedisSentinelAsyncConnection<K, V> connectSentinelAsync(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectSentinelAsyncImpl(codec, this.redisURI);
    }

    public RedisSentinelAsyncConnection<String, String> connectSentinelAsync(RedisURI redisURI) {
        return this.connectSentinelAsyncImpl(this.newStringStringCodec(), redisURI);
    }

    public <K, V> RedisSentinelAsyncConnection<K, V> connectSentinelAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectSentinelAsyncImpl(codec, redisURI);
    }

    private <K, V> RedisSentinelAsyncConnection<K, V> connectSentinelAsyncImpl(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        ArrayDeque queue = new ArrayDeque();
        ConnectionBuilder connectionBuilder = ConnectionBuilder.connectionBuilder();
        connectionBuilder.clientOptions(ClientOptions.copyOf(this.getOptions()));
        connectionBuilder.clientResources(this.clientResources);
        CommandHandler commandHandler = new CommandHandler(this.clientOptions, this.clientResources, queue);
        RedisSentinelAsyncConnectionImpl connection = this.newRedisSentinelAsyncConnectionImpl(commandHandler, codec, this.timeout, this.unit);
        logger.debug("Trying to get a Sentinel connection for one of: " + redisURI.getSentinels());
        this.connectionBuilder(commandHandler, connection, this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        if (redisURI.getSentinels().isEmpty() && (LettuceStrings.isNotEmpty(redisURI.getHost()) || !LettuceStrings.isEmpty(redisURI.getSocket()))) {
            this.channelType(connectionBuilder, redisURI);
            this.initializeChannel(connectionBuilder);
        } else {
            boolean connected = false;
            boolean first = true;
            Exception causingException = null;
            this.validateUrisAreOfSameConnectionType(redisURI.getSentinels());
            for (RedisURI uri : redisURI.getSentinels()) {
                if (first) {
                    this.channelType(connectionBuilder, uri);
                    first = false;
                }
                connectionBuilder.socketAddressSupplier(this.getSocketAddressSupplier(uri));
                logger.debug("Connecting to Sentinel, address: " + uri.getResolvedAddress());
                try {
                    this.initializeChannel(connectionBuilder);
                    connected = true;
                    break;
                }
                catch (Exception e) {
                    logger.warn("Cannot connect sentinel at " + uri + ": " + e.toString());
                    causingException = e;
                    if (!(e instanceof ConnectException)) continue;
                }
            }
            if (!connected) {
                throw new RedisConnectionException("Cannot connect to a sentinel: " + redisURI.getSentinels(), causingException);
            }
        }
        return connection;
    }

    private void validateUrisAreOfSameConnectionType(List<RedisURI> redisUris) {
        boolean unixDomainSocket = false;
        boolean inetSocket = false;
        for (RedisURI sentinel : redisUris) {
            if (sentinel.getSocket() != null) {
                unixDomainSocket = true;
            }
            if (sentinel.getHost() == null) continue;
            inetSocket = true;
        }
        if (unixDomainSocket && inetSocket) {
            throw new RedisConnectionException("You cannot mix unix domain socket and IP socket URI's");
        }
    }

    protected <K, V> RedisAsyncConnectionImpl<K, V> newRedisAsyncConnectionImpl(RedisChannelWriter<K, V> channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new RedisAsyncConnectionImpl<K, V>(channelWriter, codec, timeout, unit);
    }

    protected <K, V> RedisSentinelAsyncConnectionImpl<K, V> newRedisSentinelAsyncConnectionImpl(RedisChannelWriter<K, V> channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new RedisSentinelAsyncConnectionImpl<K, V>(channelWriter, codec, timeout, unit);
    }

    protected <K, V> RedisPubSubConnectionImpl<K, V> newRedisPubSubConnectionImpl(RedisChannelWriter<K, V> channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new RedisPubSubConnectionImpl<K, V>(channelWriter, codec, timeout, unit);
    }

    private Supplier<SocketAddress> getSocketAddressSupplier(final RedisURI redisURI) {
        return new Supplier<SocketAddress>(){

            public SocketAddress get() {
                try {
                    SocketAddress socketAddress = RedisClient.this.getSocketAddress(redisURI);
                    AbstractRedisClient.logger.debug("Resolved SocketAddress {} using {}", (Object)socketAddress, (Object)redisURI);
                    return socketAddress;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RedisException(e);
                }
                catch (TimeoutException e) {
                    throw new RedisException(e);
                }
                catch (ExecutionException e) {
                    throw new RedisException(e);
                }
            }
        };
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    protected SocketAddress getSocketAddress(RedisURI redisURI) throws InterruptedException, TimeoutException, ExecutionException {
        SocketAddress redisAddress;
        if (redisURI.getSentinelMasterId() != null && !redisURI.getSentinels().isEmpty()) {
            logger.debug("Connecting to Redis using Sentinels {}, MasterId {}", redisURI.getSentinels(), (Object)redisURI.getSentinelMasterId());
            redisAddress = this.lookupRedis(redisURI);
            if (redisAddress == null) {
                throw new RedisConnectionException("Cannot provide redisAddress using sentinel for masterId " + redisURI.getSentinelMasterId());
            }
        } else {
            redisAddress = redisURI.getResolvedAddress();
        }
        return redisAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress lookupRedis(RedisURI redisURI) throws InterruptedException, TimeoutException, ExecutionException {
        RedisSentinelAsyncConnection<String, String> connection = this.connectSentinelAsync(redisURI);
        try {
            SocketAddress socketAddress = connection.getMasterAddrByName(redisURI.getSentinelMasterId()).get(this.timeout, this.unit);
            return socketAddress;
        }
        finally {
            connection.close();
        }
    }

    private void checkValidRedisURI(RedisURI redisURI) {
        Preconditions.checkArgument((redisURI != null ? 1 : 0) != 0, (Object)"A valid RedisURI is needed");
        if (redisURI.getSentinels().isEmpty()) {
            if (LettuceStrings.isEmpty(redisURI.getHost()) && LettuceStrings.isEmpty(redisURI.getSocket())) {
                throw new IllegalArgumentException("RedisURI for Redis Standalone does not contain a host or a socket");
            }
        } else {
            if (LettuceStrings.isEmpty(redisURI.getSentinelMasterId())) {
                throw new IllegalArgumentException("TRedisURI for Redis Sentinel requires a masterId");
            }
            for (RedisURI sentinel : redisURI.getSentinels()) {
                if (!LettuceStrings.isEmpty(sentinel.getHost()) || !LettuceStrings.isEmpty(sentinel.getSocket())) continue;
                throw new IllegalArgumentException("RedisURI for Redis Sentinel does not contain a host or a socket");
            }
        }
    }

    protected Utf8StringCodec newStringStringCodec() {
        return new Utf8StringCodec();
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
    }

    private static void assertNotNull(RedisURI redisURI) {
        Preconditions.checkArgument((redisURI != null ? 1 : 0) != 0, (Object)"RedisURI must not be null");
    }

    private static void assertNotNull(ClientResources clientResources) {
        Preconditions.checkArgument((clientResources != null ? 1 : 0) != 0, (Object)"ClientResources must not be null");
    }
}

