/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SVGOMCSSImportedElementRoot;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class SVGUseElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "use";
    }

    public Bridge getInstance() {
        return new SVGUseElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        Element localRefElement;
        if (!SVGUtilities.matchUserAgent(e, ctx.getUserAgent())) {
            return null;
        }
        String uri = XLinkSupport.getXLinkHref(e);
        if (uri.length() == 0) {
            throw new BridgeException(e, "uri.malformed", new Object[]{uri});
        }
        Element refElement = ctx.getReferencedElement(e, uri);
        SVGOMDocument document = (SVGOMDocument)e.getOwnerDocument();
        SVGOMDocument refDocument = (SVGOMDocument)refElement.getOwnerDocument();
        boolean isLocal = refDocument == document;
        Element element = localRefElement = isLocal ? (Element)refElement.cloneNode(true) : (Element)document.importNode(refElement, true);
        if ("symbol".equals(localRefElement.getLocalName())) {
            Element svgElement = document.createElementNS("http://www.w3.org/2000/svg", "svg");
            NamedNodeMap attrs = localRefElement.getAttributes();
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                Attr attr = (Attr)attrs.item(i);
                svgElement.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
                ++i;
            }
            Node n = localRefElement.getFirstChild();
            while (n != null) {
                svgElement.appendChild(n);
                n = localRefElement.getFirstChild();
            }
            localRefElement = svgElement;
        }
        if ("svg".equals(localRefElement.getLocalName())) {
            String hStr;
            String wStr = e.getAttributeNS(null, "width");
            if (wStr.length() != 0) {
                localRefElement.setAttributeNS(null, "width", wStr);
            }
            if ((hStr = e.getAttributeNS(null, "height")).length() != 0) {
                localRefElement.setAttributeNS(null, "height", hStr);
            }
        }
        SVGOMCSSImportedElementRoot root = new SVGOMCSSImportedElementRoot(document, e);
        root.appendChild(localRefElement);
        SVGOMUseElement ue = (SVGOMUseElement)e;
        ue.setCSSImportedElementRoot(root);
        Element g = localRefElement;
        CSSUtilities.computeStyleAndURIs(refElement, localRefElement, uri);
        GVTBuilder builder = ctx.getGVTBuilder();
        GraphicsNode refNode = builder.build(ctx, g);
        CompositeGraphicsNode gn = new CompositeGraphicsNode();
        gn.getChildren().add(refNode);
        gn.setTransform(this.computeTransform(e));
        gn.setVisible(CSSUtilities.convertVisibility(e));
        Rectangle2D r = CSSUtilities.convertEnableBackground(e);
        if (r != null) {
            gn.setBackgroundEnable(r);
        }
        return gn;
    }

    protected AffineTransform computeTransform(Element e) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(this.ctx, e);
        float x = 0.0f;
        String s = e.getAttributeNS(null, "x");
        if (s.length() != 0) {
            x = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x", uctx);
        }
        float y = 0.0f;
        s = e.getAttributeNS(null, "y");
        if (s.length() != 0) {
            y = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y", uctx);
        }
        s = e.getAttributeNS(null, "transform");
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        if (s.length() != 0) {
            at.preConcatenate(SVGUtilities.convertTransform(e, "transform", s));
        }
        return at;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("x") || attrName.equals("y") || attrName.equals("transform")) {
            String s = evt.getNewValue();
            this.node.setTransform(this.computeTransform(this.e));
            this.handleGeometryChanged();
        }
    }
}

