/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.weaver.AnnotationNameValuePair;

public class AnnotationAJ {
    private String type;
    private boolean isRuntimeVisible;
    private List nvPairs = null;

    public AnnotationAJ(String type, boolean isRuntimeVisible) {
        this.type = type;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public String getTypeSignature() {
        return this.type;
    }

    public List getNameValuePairs() {
        return this.nvPairs;
    }

    public boolean hasNameValuePairs() {
        return this.nvPairs != null && this.nvPairs.size() != 0;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public String stringify() {
        return "xxxxxxxxxxx";
    }

    public String getStringValueOf(Object name) {
        if (!this.hasNameValuePairs()) {
            return null;
        }
        Iterator iter = this.nvPairs.iterator();
        while (iter.hasNext()) {
            AnnotationNameValuePair nvpair = (AnnotationNameValuePair)iter.next();
            if (!nvpair.getName().equals(name)) continue;
            return nvpair.getValue().stringify();
        }
        return null;
    }

    public void addNameValuePair(AnnotationNameValuePair pair) {
        if (this.nvPairs == null) {
            this.nvPairs = new ArrayList();
        }
        this.nvPairs.add(pair);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ANNOTATION [" + this.getTypeSignature() + "] [" + (this.isRuntimeVisible ? "runtimeVisible" : "runtimeInvisible") + "] [");
        if (this.nvPairs != null) {
            Iterator iter = this.nvPairs.iterator();
            while (iter.hasNext()) {
                AnnotationNameValuePair element = (AnnotationNameValuePair)iter.next();
                sb.append(element.toString());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

