/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.SetQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkPool<K, W> {
    private static final int MAX_QUEUE_LENGTH = 1000;
    private final SetQueue<K> ready = new SetQueue();
    private final Set<K> inProgress = new HashSet<K>();
    private final Map<K, WorkQueue> pool = new HashMap<K, WorkQueue>();
    private Semaphore semaphore = new Semaphore(1);
    private AtomicInteger unlimitedQueues = new AtomicInteger(0);

    private void acquireSemaphore() throws InterruptedException {
        if (this.unlimitedQueues.get() == 0) {
            this.semaphore.acquire();
        }
    }

    private void releaseSemaphore() {
        this.semaphore.release();
    }

    private void increaseUnlimited() {
        this.unlimitedQueues.getAndIncrement();
        this.semaphore.release();
    }

    private void decreaseUnlimited() {
        this.unlimitedQueues.getAndDecrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerKey(K key) {
        WorkPool workPool = this;
        synchronized (workPool) {
            if (!this.pool.containsKey(key)) {
                this.pool.put(key, new WorkQueue(1000));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlimit(K key, boolean unlimited) {
        WorkPool workPool = this;
        synchronized (workPool) {
            WorkQueue queue = this.pool.get(key);
            if (queue != null) {
                queue.setUnlimited(unlimited);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterKey(K key) {
        WorkPool workPool = this;
        synchronized (workPool) {
            this.pool.remove(key);
            this.ready.remove(key);
            this.inProgress.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllKeys() {
        WorkPool workPool = this;
        synchronized (workPool) {
            this.pool.clear();
            this.ready.clear();
            this.inProgress.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K nextWorkBlock(Collection<W> to, int size) {
        WorkPool workPool = this;
        synchronized (workPool) {
            K nextKey = this.readyToInProgress();
            if (nextKey != null) {
                WorkQueue queue = this.pool.get(nextKey);
                this.drainTo(queue, to, size);
            }
            return nextKey;
        }
    }

    private int drainTo(WorkQueue deList, Collection<W> c, int maxElements) {
        Object first;
        int n;
        for (n = 0; n < maxElements && (first = deList.poll()) != null; ++n) {
            c.add(first);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWorkItem(K key, W item) {
        WorkQueue queue;
        WorkPool workPool = this;
        synchronized (workPool) {
            queue = this.pool.get(key);
        }
        if (queue != null) {
            try {
                queue.put(item);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            workPool = this;
            synchronized (workPool) {
                if (this.isDormant(key)) {
                    this.dormantToReady(key);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWorkBlock(K key) {
        WorkPool workPool = this;
        synchronized (workPool) {
            if (!this.isRegistered(key)) {
                return false;
            }
            if (!this.inProgress.contains(key)) {
                throw new IllegalStateException("Client " + key + " not in progress");
            }
            if (this.moreWorkItems(key)) {
                this.inProgressToReady(key);
                return true;
            }
            this.inProgressToDormant(key);
            return false;
        }
    }

    private boolean moreWorkItems(K key) {
        WorkQueue leList = this.pool.get(key);
        return leList != null && !leList.isEmpty();
    }

    private boolean isInProgress(K key) {
        return this.inProgress.contains(key);
    }

    private boolean isReady(K key) {
        return this.ready.contains(key);
    }

    private boolean isRegistered(K key) {
        return this.pool.containsKey(key);
    }

    private boolean isDormant(K key) {
        return !this.isInProgress(key) && !this.isReady(key) && this.isRegistered(key);
    }

    private void inProgressToReady(K key) {
        this.inProgress.remove(key);
        this.ready.addIfNotPresent(key);
    }

    private void inProgressToDormant(K key) {
        this.inProgress.remove(key);
    }

    private void dormantToReady(K key) {
        this.ready.addIfNotPresent(key);
    }

    private K readyToInProgress() {
        K key = this.ready.poll();
        if (key != null) {
            this.inProgress.add(key);
        }
        return key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkQueue {
        private LinkedList<W> list = new LinkedList();
        private boolean unlimited = false;
        private int maxLengthWhenLimited;

        private WorkQueue(int maxLengthWhenLimited) {
            this.maxLengthWhenLimited = maxLengthWhenLimited;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(W w) throws InterruptedException {
            if (this.list.size() > this.maxLengthWhenLimited) {
                WorkPool.this.acquireSemaphore();
            }
            WorkQueue workQueue = this;
            synchronized (workQueue) {
                this.list.add(w);
            }
        }

        public synchronized W poll() {
            Object res = this.list.poll();
            if (this.list.size() <= this.maxLengthWhenLimited) {
                WorkPool.this.releaseSemaphore();
            }
            return res;
        }

        public void setUnlimited(boolean unlimited) {
            assert (this.unlimited != unlimited);
            this.unlimited = unlimited;
            if (unlimited) {
                WorkPool.this.increaseUnlimited();
            } else {
                WorkPool.this.decreaseUnlimited();
            }
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }
}

