/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import com.mycila.xmltool.CachedEntityResolver;
import com.mycila.xmltool.XMLDocumentException;
import com.mycila.xmltool.XMLErrorHandler;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class XMLDocumentBuilderFactory {
    private static ObjectPool<DocumentBuilder> ignoreNamespaceDocumentBuilderPool;
    private static ObjectPool<DocumentBuilder> namespaceAwareDocumentBuilderPool;

    static {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMinIdle(0);
        config.setMaxIdle(Runtime.getRuntime().availableProcessors());
        config.setMaxTotal(Runtime.getRuntime().availableProcessors() * 4);
        config.setMaxWaitMillis(-1L);
        XMLDocumentBuilderFactory.setPoolConfig(config);
    }

    public static void setPoolConfig(GenericObjectPoolConfig config) {
        ignoreNamespaceDocumentBuilderPool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<DocumentBuilder>(){

            public DocumentBuilder create() throws Exception {
                return XMLDocumentBuilderFactory.newDocumentBuilder(true);
            }

            public PooledObject<DocumentBuilder> wrap(DocumentBuilder obj) {
                return new DefaultPooledObject((Object)obj);
            }
        }, config);
        namespaceAwareDocumentBuilderPool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<DocumentBuilder>(){

            public DocumentBuilder create() throws Exception {
                return XMLDocumentBuilderFactory.newDocumentBuilder(false);
            }

            public PooledObject<DocumentBuilder> wrap(DocumentBuilder obj) {
                return new DefaultPooledObject((Object)obj);
            }
        }, config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> V withDocumentBuilder(boolean ignoreNamespaces, Callback<V> c) {
        try {
            if (ignoreNamespaces) {
                DocumentBuilder documentBuilder = null;
                try {
                    documentBuilder = (DocumentBuilder)ignoreNamespaceDocumentBuilderPool.borrowObject();
                    V v = c.apply(documentBuilder);
                    return v;
                }
                finally {
                    if (documentBuilder != null) {
                        ignoreNamespaceDocumentBuilderPool.returnObject((Object)documentBuilder);
                    }
                }
            }
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = (DocumentBuilder)namespaceAwareDocumentBuilderPool.borrowObject();
                V v = c.apply(documentBuilder);
                return v;
            }
            finally {
                if (documentBuilder != null) {
                    namespaceAwareDocumentBuilderPool.returnObject((Object)documentBuilder);
                }
            }
        }
        catch (TimeoutException e) {
            throw new XMLDocumentException("Error creating XMLDoc: timed out.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new XMLDocumentException("Error creating XMLDoc: interrupted.", e);
        }
        catch (Exception e) {
            throw new XMLDocumentException("Error creating XMLDoc. Please verify that the input source can be read and is well formed.", e);
        }
    }

    public static DocumentBuilder newDocumentBuilder(boolean ignoreNamespaces) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(!ignoreNamespaces);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new XMLErrorHandler(true));
            builder.setEntityResolver(CachedEntityResolver.instance);
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    static interface Callback<V> {
        public V apply(DocumentBuilder var1) throws Exception;
    }
}

