/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import com.mycila.xmltool.SoftHashMap;
import com.mycila.xmltool.Utils;
import com.mycila.xmltool.XMLDocDefinition;
import com.mycila.xmltool.XMLDocumentException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class XMLDocPath {
    private final XPath xpath;
    private final Map<String, XPathExpression> compiled = new SoftHashMap<String, XPathExpression>();

    XMLDocPath(XMLDocDefinition context) {
        try {
            this.xpath = XPathFactory.newInstance().newXPath();
            this.xpath.setNamespaceContext(context);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    String rawXpathString(Node root, String relativeXpath, Object ... arguments) {
        return (String)this.eval(this.getExpr(relativeXpath, arguments), root, XPathConstants.STRING);
    }

    Number rawXpathNumber(Node root, String relativeXpath, Object ... arguments) {
        return (Number)this.eval(this.getExpr(relativeXpath, arguments), root, XPathConstants.NUMBER);
    }

    Boolean rawXpathBoolean(Node root, String relativeXpath, Object ... arguments) {
        return (Boolean)this.eval(this.getExpr(relativeXpath, arguments), root, XPathConstants.BOOLEAN);
    }

    Node rawXpathNode(Node root, String relativeXpath, Object ... arguments) {
        return (Node)this.eval(this.getExpr(relativeXpath, arguments), root, XPathConstants.NODE);
    }

    NodeList rawXpathNodeSet(Node root, String relativeXpath, Object ... arguments) {
        return (NodeList)this.eval(this.getExpr(relativeXpath, arguments), root, XPathConstants.NODESET);
    }

    Node[] findNodes(Node root, String xpathExpr, Object ... args) {
        try {
            NodeList list = this.rawXpathNodeSet(root, xpathExpr, args);
            Node[] nodes = new Node[list.getLength()];
            int i = 0;
            while (i < list.getLength()) {
                nodes[i] = list.item(i);
                ++i;
            }
            return nodes;
        }
        catch (Exception exception) {
            return new Node[0];
        }
    }

    Node findNode(Node root, String xpathExpr, Object ... args) {
        Node n = (Node)this.eval(this.getExpr(xpathExpr, args), root, XPathConstants.NODE);
        if (n == null) {
            throw new XMLDocumentException(String.format("Error executing xpath '%s' from node '%s': Inexisting target node.", String.format(xpathExpr, args), root.getNodeName()), new Object[0]);
        }
        return n;
    }

    private <T> T eval(XPathExpression expr, Node root, QName retType) {
        Utils.notNull("Node", root);
        Utils.notNull("Return type", retType);
        try {
            return (T)expr.evaluate(root, retType);
        }
        catch (XPathExpressionException e) {
            throw new XMLDocumentException(String.format("Error executing xpath from node '%s': %s", root.getNodeName(), e.getMessage()), e);
        }
    }

    private XPathExpression getExpr(String xpathExpr, Object ... args) {
        Utils.notEmpty("XPath expression", xpathExpr);
        try {
            xpathExpr = String.format(xpathExpr, args);
            XPathExpression expr = this.compiled.get(xpathExpr);
            if (expr == null) {
                expr = this.xpath.compile(xpathExpr);
                this.compiled.put(xpathExpr, expr);
            }
            return expr;
        }
        catch (Exception e) {
            throw new XMLDocumentException(String.format("Error compiling xpath '%s'", String.format(xpathExpr, args)), e);
        }
    }
}

