/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.reactive;

import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.reactive.TransactionCallback;
import org.springframework.transaction.reactive.TransactionalOperatorImpl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface TransactionalOperator {
    default public <T> Flux<T> transactional(Flux<T> flux) {
        return this.execute(it -> flux);
    }

    default public <T> Mono<T> transactional(Mono<T> mono) {
        return this.execute(it -> mono).next();
    }

    public <T> Flux<T> execute(TransactionCallback<T> var1) throws TransactionException;

    public static TransactionalOperator create(ReactiveTransactionManager transactionManager) {
        return TransactionalOperator.create(transactionManager, TransactionDefinition.withDefaults());
    }

    public static TransactionalOperator create(ReactiveTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        return new TransactionalOperatorImpl(transactionManager, transactionDefinition);
    }
}

