/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca.tuscany;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tuscany.common.monitor.MonitorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsLoggingMonitorFactory
implements MonitorFactory {
    private final Map<Class<?>, WeakReference<?>> proxies = new WeakHashMap();

    public <T> T getMonitor(Class<T> monitorInterface) {
        T proxy = this.getCachedMonitor(monitorInterface);
        if (proxy == null) {
            proxy = this.createMonitor(monitorInterface);
            this.proxies.put(monitorInterface, new WeakReference<T>(proxy));
        }
        return proxy;
    }

    private <T> T getCachedMonitor(Class<T> monitorInterface) {
        WeakReference<?> ref = this.proxies.get(monitorInterface);
        return ref != null ? (T)ref.get() : null;
    }

    private <T> T createMonitor(Class<T> monitorInterface) {
        String className = monitorInterface.getName();
        Log logger = LogFactory.getLog((String)className);
        LoggingHandler handler = new LoggingHandler(logger);
        return (T)Proxy.newProxyInstance(monitorInterface.getClassLoader(), new Class[]{monitorInterface}, (InvocationHandler)handler);
    }

    private static final class LoggingHandler
    implements InvocationHandler {
        private final Log logger;

        public LoggingHandler(Log logger) {
            this.logger = logger;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String sourceMethod = method.getName();
            if (this.logger.isDebugEnabled()) {
                if (args != null && args.length == 1 && args[0] instanceof Throwable) {
                    this.logger.debug((Object)sourceMethod, (Throwable)args[0]);
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(sourceMethod);
                    sb.append("(");
                    for (int i = 0; i < args.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(args[i]);
                    }
                    sb.append(")");
                    this.logger.debug((Object)sb.toString());
                }
            }
            return null;
        }
    }
}

