/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.servicemix.sca.handler.ExternalJbiServiceClient;
import org.apache.tuscany.core.context.ExternalServiceContext;
import org.apache.tuscany.core.context.InstanceContext;
import org.apache.tuscany.core.context.QualifiedName;
import org.apache.tuscany.core.context.ScopeContext;
import org.apache.tuscany.core.context.TargetException;
import org.apache.tuscany.core.invocation.Interceptor;
import org.apache.tuscany.core.invocation.TargetInvoker;
import org.apache.tuscany.core.message.Message;

public class ExternalJbiServiceTargetInvoker
implements TargetInvoker {
    private QualifiedName serviceName;
    private String esName;
    private Method method;
    private ScopeContext container;
    private ExternalServiceContext context;

    public ExternalJbiServiceTargetInvoker(QualifiedName serviceName, Method method, ScopeContext container) {
        assert (serviceName != null) : "No service name specified";
        assert (method != null) : "No method specified";
        assert (container != null) : "No scope container specified";
        this.serviceName = serviceName;
        this.esName = serviceName.getPartName();
        this.method = method;
        this.container = container;
    }

    public Object invokeTarget(Object payload) throws InvocationTargetException {
        if (this.context == null) {
            InstanceContext iContext = this.container.getContext(this.esName);
            if (!(iContext instanceof ExternalServiceContext)) {
                TargetException te = new TargetException("Unexpected target context type");
                te.setIdentifier(iContext.getClass().getName());
                te.addContextName(iContext.getName());
                throw te;
            }
            this.context = (ExternalServiceContext)iContext;
        }
        ExternalJbiServiceClient client = (ExternalJbiServiceClient)this.context.getImplementationInstance(true);
        if (payload != null) {
            return client.invoke(this.method, (Object[])payload);
        }
        return client.invoke(this.method, null);
    }

    public boolean isCacheable() {
        return false;
    }

    public Message invoke(Message msg) {
        try {
            Object resp = this.invokeTarget(msg.getBody());
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            msg.setBody((Object)e.getCause());
        }
        catch (Throwable e) {
            msg.setBody((Object)e);
        }
        return msg;
    }

    public void setNext(Interceptor next) {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        try {
            ExternalJbiServiceTargetInvoker invoker = (ExternalJbiServiceTargetInvoker)super.clone();
            invoker.container = this.container;
            invoker.context = this.context;
            invoker.esName = this.esName;
            invoker.method = this.method;
            invoker.serviceName = this.serviceName;
            return invoker;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

