/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca.builder;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import org.apache.servicemix.sca.assembly.JbiBinding;
import org.apache.servicemix.sca.config.JbiServiceEntryPointContextFactory;
import org.apache.tuscany.core.builder.BuilderException;
import org.apache.tuscany.core.builder.ContextFactoryBuilder;
import org.apache.tuscany.core.config.JavaIntrospectionHelper;
import org.apache.tuscany.core.context.AggregateContext;
import org.apache.tuscany.core.context.QualifiedName;
import org.apache.tuscany.core.invocation.Interceptor;
import org.apache.tuscany.core.invocation.InvocationConfiguration;
import org.apache.tuscany.core.invocation.InvocationRuntimeException;
import org.apache.tuscany.core.invocation.ProxyConfiguration;
import org.apache.tuscany.core.invocation.TargetInvoker;
import org.apache.tuscany.core.invocation.spi.ProxyFactory;
import org.apache.tuscany.core.invocation.spi.ProxyFactoryFactory;
import org.apache.tuscany.core.message.Message;
import org.apache.tuscany.core.message.MessageFactory;
import org.apache.tuscany.core.runtime.RuntimeContext;
import org.apache.tuscany.core.system.annotation.Autowire;
import org.apache.tuscany.model.assembly.AssemblyModelObject;
import org.apache.tuscany.model.assembly.ConfiguredService;
import org.apache.tuscany.model.assembly.EntryPoint;
import org.apache.tuscany.model.assembly.Service;
import org.apache.tuscany.model.assembly.ServiceContract;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="MODULE")
public class JbiServiceEntryPointBuilder
implements ContextFactoryBuilder<AggregateContext> {
    private RuntimeContext runtimeContext;
    private ProxyFactoryFactory proxyFactoryFactory;
    private MessageFactory messageFactory;
    private ContextFactoryBuilder policyBuilder;

    @Init(eager=true)
    public void init() {
        this.runtimeContext.addBuilder((ContextFactoryBuilder)this);
    }

    @Autowire
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    @Autowire
    public void setProxyFactoryFactory(ProxyFactoryFactory factory) {
        this.proxyFactoryFactory = factory;
    }

    @Autowire
    public void setMessageFactory(MessageFactory msgFactory) {
        this.messageFactory = msgFactory;
    }

    public void setPolicyBuilder(ContextFactoryBuilder builder) {
        this.policyBuilder = builder;
    }

    public void build(AssemblyModelObject object) throws BuilderException {
        if (!(object instanceof EntryPoint)) {
            return;
        }
        EntryPoint entryPoint = (EntryPoint)object;
        if (entryPoint.getBindings().size() < 1 || !(entryPoint.getBindings().get(0) instanceof JbiBinding)) {
            return;
        }
        JbiServiceEntryPointContextFactory config = new JbiServiceEntryPointContextFactory(entryPoint.getName(), entryPoint.getConfiguredService().getService().getName(), this.messageFactory);
        ConfiguredService configuredService = entryPoint.getConfiguredService();
        Service service = configuredService.getService();
        ServiceContract serviceContract = service.getServiceContract();
        HashMap<Method, InvocationConfiguration> iConfigMap = new HashMap<Method, InvocationConfiguration>();
        ProxyFactory proxyFactory = this.proxyFactoryFactory.createProxyFactory();
        Set javaMethods = JavaIntrospectionHelper.getAllUniqueMethods((Class)serviceContract.getInterface());
        for (Method method : javaMethods) {
            InvocationConfiguration iConfig = new InvocationConfiguration(method);
            iConfigMap.put(method, iConfig);
        }
        QualifiedName qName = new QualifiedName(((ConfiguredService)entryPoint.getConfiguredReference().getTargetConfiguredServices().get(0)).getAggregatePart().getName() + "/" + service.getName());
        ProxyConfiguration pConfiguration = new ProxyConfiguration(qName, iConfigMap, serviceContract.getInterface().getClassLoader(), this.messageFactory);
        proxyFactory.setBusinessInterface(serviceContract.getInterface());
        proxyFactory.setProxyConfiguration(pConfiguration);
        config.addSourceProxyFactory(service.getName(), proxyFactory);
        configuredService.setProxyFactory((Object)proxyFactory);
        if (this.policyBuilder != null) {
            this.policyBuilder.build((AssemblyModelObject)configuredService);
        }
        for (InvocationConfiguration iConfig : iConfigMap.values()) {
            iConfig.addTargetInterceptor((Interceptor)new EntryPointInvokerInterceptor());
        }
        entryPoint.getConfiguredReference().setContextFactory((Object)config);
    }

    public class EntryPointInvokerInterceptor
    implements Interceptor {
        public Message invoke(Message msg) throws InvocationRuntimeException {
            TargetInvoker invoker = msg.getTargetInvoker();
            if (invoker == null) {
                throw new InvocationRuntimeException("No target invoker specified on message");
            }
            return invoker.invoke(msg);
        }

        public void setNext(Interceptor next) {
        }
    }
}

