/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca.assembly.impl;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.servicemix.sca.assembly.JbiBinding;
import org.apache.tuscany.model.assembly.AssemblyModelContext;
import org.apache.tuscany.model.assembly.impl.BindingImpl;

public class JbiBindingImpl
extends BindingImpl
implements JbiBinding {
    private String portURI;
    private QName serviceName;
    private String endpointName;
    private QName interfaceName;
    private Definition definition;
    private Service service;
    private PortType portType;
    private Port port;

    protected JbiBindingImpl() {
    }

    public String getPortURI() {
        return this.portURI;
    }

    public void setPortURI(String portURI) {
        this.portURI = portURI;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public Service getService() {
        return this.service;
    }

    public Port getPort() {
        return this.port;
    }

    public PortType getPortType() {
        return this.portType;
    }

    public void initialize(AssemblyModelContext modelContext) {
        if (this.isInitialized()) {
            return;
        }
        super.initialize(modelContext);
        String[] parts = this.split(this.portURI);
        this.serviceName = new QName(parts[0], parts[1]);
        this.endpointName = parts[2];
        List definitions = modelContext.getAssemblyLoader().loadDefinitions(parts[0]);
        if (definitions != null) {
            for (Definition definition : definitions) {
                Port port;
                Service service = definition.getService(this.serviceName);
                if (service == null || (port = service.getPort(this.endpointName)) == null) continue;
                this.service = service;
                this.port = port;
                this.portType = port.getBinding().getPortType();
                this.interfaceName = this.portType.getQName();
                this.definition = definition;
                return;
            }
        }
    }

    protected String[] split(String uri) {
        int sep = (uri = uri.trim()).indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        int idx2 = uri.lastIndexOf(sep, idx1 - 1);
        String epName = uri.substring(idx1 + 1);
        String svcName = uri.substring(idx2 + 1, idx1);
        String nsUri = uri.substring(0, idx2);
        return new String[]{nsUri, svcName, epName};
    }
}

