/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.sca.ScaEndpoint;
import org.apache.servicemix.sca.assembly.JbiBinding;
import org.apache.servicemix.sca.tuscany.CommonsLoggingMonitorFactory;
import org.apache.servicemix.sca.tuscany.TuscanyRuntime;
import org.apache.tuscany.model.assembly.Binding;
import org.apache.tuscany.model.assembly.EntryPoint;
import org.apache.tuscany.model.assembly.Module;

public class ScaServiceUnit
extends ServiceUnit {
    protected static final ThreadLocal<ScaServiceUnit> SERVICE_UNIT = new ThreadLocal();
    protected TuscanyRuntime tuscanyRuntime;
    protected ClassLoader classLoader;

    public static ScaServiceUnit getCurrentScaServiceUnit() {
        return SERVICE_UNIT.get();
    }

    public void init() throws Exception {
        SERVICE_UNIT.set(this);
        this.createScaRuntime();
        this.createEndpoints();
        SERVICE_UNIT.set(null);
    }

    protected void createScaRuntime() throws Exception {
        File root = new File(this.getRootPath());
        File[] files = root.listFiles(new JarFileFilter());
        URL[] urls = new URL[files.length + 1];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURL();
        }
        urls[urls.length - 1] = root.toURL();
        this.classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        this.tuscanyRuntime = new TuscanyRuntime(this.getName(), this.getRootPath(), this.classLoader, new CommonsLoggingMonitorFactory());
    }

    protected void createEndpoints() throws Exception {
        Module module = this.tuscanyRuntime.getModuleComponent().getModuleImplementation();
        for (EntryPoint entryPoint : module.getEntryPoints()) {
            Binding binding = (Binding)entryPoint.getBindings().get(0);
            if (!(binding instanceof JbiBinding)) continue;
            JbiBinding jbiBinding = (JbiBinding)binding;
            ScaEndpoint endpoint = new ScaEndpoint(entryPoint);
            endpoint.setServiceUnit(this);
            endpoint.setService(jbiBinding.getServiceName());
            endpoint.setEndpoint(jbiBinding.getEndpointName());
            endpoint.setInterfaceName(jbiBinding.getInterfaceName());
            Definition definition = jbiBinding.getDefinition();
            if (definition != null) {
                endpoint.setDefinition(definition);
                endpoint.setDescription(WSDLFactory.newInstance().newWSDLWriter().getDocument(definition));
            }
            this.addEndpoint(endpoint);
        }
    }

    public TuscanyRuntime getTuscanyRuntime() {
        return this.tuscanyRuntime;
    }

    public void start() throws Exception {
        this.tuscanyRuntime.start();
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.tuscanyRuntime.stop();
    }

    private static class JarFileFilter
    implements FilenameFilter {
        private JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

