/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.geom;

import com.esri.sde.sdk.geom.Geometry;
import com.esri.sde.sdk.geom.GeometryException;
import com.esri.sde.sdk.geom.Linestring;
import com.esri.sde.sdk.geom.Point;
import com.esri.sde.sdk.geom.Polygon;
import com.esri.sde.sdk.geom.SeCoordRef;
import com.esri.sde.sdk.geom.SeEnvelope;
import com.esri.sde.sdk.geom.SeGeometryException;
import com.esri.sde.sdk.geom.SePoint;
import com.esri.sde.sdk.geom.SeSurface;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.esri.sde.sdk.sg.SgCoordRef;
import com.esri.sde.sdk.sg.SgException;
import com.esri.sde.sdk.sg.SgShape;
import com.esri.sde.sdk.sg.SgShapeEnvelope;
import com.esri.sde.sdk.sg.SgSimpleShapePoint;
import java.io.Serializable;

public class SePolygon
extends SeSurface
implements Polygon,
Cloneable,
Serializable {
    protected SgSimpleShapePoint[] u;
    protected int[] v;
    protected double[] w;
    protected double[] x;

    public SePolygon() throws SeGeometryException {
        try {
            SgCoordRef sgCoordRef = SgCoordRef.create();
            SeCoordRef seCoordRef = new SeCoordRef();
            seCoordRef.a(sgCoordRef);
            this.j = 0;
            SgSimpleShapePoint[] sgSimpleShapePointArray = new SgSimpleShapePoint[]{};
            this.setCoordRef(seCoordRef);
            SgShape sgShape = this.a();
            this.a(sgShape, true);
        }
        catch (SgException sgException) {
            throw new SeGeometryException(sgException);
        }
    }

    public SePolygon(SeCoordRef seCoordRef, SeEnvelope seEnvelope) throws SeGeometryException {
        int n2;
        int n3 = GeometryException.a;
        SgSimpleShapePoint[] sgSimpleShapePointArray = new SgSimpleShapePoint[]{new SgSimpleShapePoint(seEnvelope.getMinX(), seEnvelope.getMinY()), new SgSimpleShapePoint(seEnvelope.getMaxX(), seEnvelope.getMaxY())};
        this.j = n2 = 5;
        this.u = new SgSimpleShapePoint[5];
        this.u[0] = new SgSimpleShapePoint(sgSimpleShapePointArray[0].getX(), sgSimpleShapePointArray[0].getY());
        this.u[1] = new SgSimpleShapePoint(sgSimpleShapePointArray[1].getX(), sgSimpleShapePointArray[0].getY());
        this.u[2] = new SgSimpleShapePoint(sgSimpleShapePointArray[1].getX(), sgSimpleShapePointArray[1].getY());
        this.u[3] = new SgSimpleShapePoint(sgSimpleShapePointArray[0].getX(), sgSimpleShapePointArray[1].getY());
        this.u[4] = new SgSimpleShapePoint(sgSimpleShapePointArray[0].getX(), sgSimpleShapePointArray[0].getY());
        try {
            this.setCoordRef(seCoordRef);
            SgShape sgShape = this.a();
            SgShapeEnvelope sgShapeEnvelope = new SgShapeEnvelope(seEnvelope.getMinX(), seEnvelope.getMinY(), seEnvelope.getMaxX(), seEnvelope.getMaxY());
            sgShape.generateRectangle(sgShapeEnvelope);
            this.a(sgShape, true);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        if (n3 != 0) {
            PeProjectionException.b = !PeProjectionException.b;
        }
    }

    public SePolygon(SeCoordRef seCoordRef, SePoint[] sePointArray) throws SeGeometryException {
        int n2;
        int n3 = GeometryException.a;
        if (sePointArray[0].is3D() && sePointArray[0].isMeasured()) {
            int n4;
            this.j = n4 = sePointArray.length;
            this.u = new SgSimpleShapePoint[n4];
            this.x = new double[n4];
            this.w = new double[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                this.u[i2] = new SgSimpleShapePoint(sePointArray[i2].X(), sePointArray[i2].Y());
                this.x[i2] = sePointArray[i2].v;
                this.w[i2] = sePointArray[i2].w;
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(this.j, 1, null, this.u, this.x, this.w);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        if (sePointArray[0].isMeasured()) {
            int n5;
            this.j = n5 = sePointArray.length;
            this.u = new SgSimpleShapePoint[n5];
            this.w = new double[n5];
            for (int i3 = 0; i3 < n5; ++i3) {
                this.u[i3] = new SgSimpleShapePoint(sePointArray[i3].X(), sePointArray[i3].Y());
                this.w[i3] = sePointArray[i3].w;
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(this.j, 1, null, this.u, null, this.w);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        if (sePointArray[0].is3D()) {
            int n6;
            this.j = n6 = sePointArray.length;
            this.u = new SgSimpleShapePoint[n6];
            this.x = new double[n6];
            for (int i4 = 0; i4 < n6; ++i4) {
                this.u[i4] = new SgSimpleShapePoint(sePointArray[i4].X(), sePointArray[i4].Y());
                this.x[i4] = sePointArray[i4].v;
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(this.j, 1, null, this.u, this.x, null);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        this.j = n2 = sePointArray.length;
        this.u = new SgSimpleShapePoint[n2];
        for (int i5 = 0; i5 < n2; ++i5) {
            this.u[i5] = new SgSimpleShapePoint(sePointArray[i5].X(), sePointArray[i5].Y());
            if (n3 == 0) continue;
        }
        try {
            this.setCoordRef(seCoordRef);
            SgShape sgShape = this.a();
            sgShape.generatePolygon(this.j, 1, null, this.u, null, null);
            this.a(sgShape, true);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
    }

    public SePolygon(SeCoordRef seCoordRef, SePoint[][] sePointArray) throws SeGeometryException {
        int n2;
        int n3 = GeometryException.a;
        if (sePointArray[0][0].is3D() && sePointArray[0][0].isMeasured()) {
            int n4;
            int n5 = sePointArray.length;
            int n6 = 0;
            this.v = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                this.v[n4] = n6;
                n6 += sePointArray[n4].length;
                if (n3 == 0) continue;
            }
            this.j = n6;
            this.u = new SgSimpleShapePoint[n6];
            this.w = new double[n6];
            this.x = new double[n6];
            n4 = 0;
            for (int i2 = 0; i2 < n5; ++i2) {
                int n7 = sePointArray[i2].length;
                for (int i3 = 0; i3 < n7; ++i3) {
                    this.u[n4] = new SgSimpleShapePoint(sePointArray[i2][i3].X(), sePointArray[i2][i3].Y());
                    this.w[n4] = sePointArray[i2][i3].getM();
                    this.x[n4] = sePointArray[i2][i3].getZ();
                    ++n4;
                    if (n3 == 0) continue;
                }
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(n6, 1, this.v, this.u, this.x, this.w);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        if (sePointArray[0][0].is3D()) {
            int n8;
            int n9 = sePointArray.length;
            int n10 = 0;
            this.v = new int[n9];
            for (n8 = 0; n8 < n9; ++n8) {
                this.v[n8] = n10;
                n10 += sePointArray[n8].length;
                if (n3 == 0) continue;
            }
            this.j = n10;
            this.u = new SgSimpleShapePoint[n10];
            this.x = new double[n10];
            n8 = 0;
            for (int i4 = 0; i4 < n9; ++i4) {
                int n11 = sePointArray[i4].length;
                for (int i5 = 0; i5 < n11; ++i5) {
                    this.u[n8] = new SgSimpleShapePoint(sePointArray[i4][i5].X(), sePointArray[i4][i5].Y());
                    this.x[n8] = sePointArray[i4][i5].getZ();
                    ++n8;
                    if (n3 == 0) continue;
                }
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(n10, 1, this.v, this.u, this.x, null);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        if (sePointArray[0][0].isMeasured()) {
            int n12;
            int n13 = sePointArray.length;
            int n14 = 0;
            this.v = new int[n13];
            for (n12 = 0; n12 < n13; ++n12) {
                this.v[n12] = n14;
                n14 += sePointArray[n12].length;
                if (n3 == 0) continue;
            }
            this.j = n14;
            this.u = new SgSimpleShapePoint[n14];
            this.w = new double[n14];
            n12 = 0;
            for (int i6 = 0; i6 < n13; ++i6) {
                int n15 = sePointArray[i6].length;
                for (int i7 = 0; i7 < n15; ++i7) {
                    this.u[n12] = new SgSimpleShapePoint(sePointArray[i6][i7].X(), sePointArray[i6][i7].Y());
                    this.w[n12] = sePointArray[i6][i7].getM();
                    ++n12;
                    if (n3 == 0) continue;
                }
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(n14, 1, this.v, this.u, null, this.w);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        int n16 = sePointArray.length;
        int n17 = 0;
        this.v = new int[n16];
        for (n2 = 0; n2 < n16; ++n2) {
            this.v[n2] = n17;
            n17 += sePointArray[n2].length;
            if (n3 == 0) continue;
        }
        this.j = n17;
        this.u = new SgSimpleShapePoint[n17];
        n2 = 0;
        for (int i8 = 0; i8 < n16; ++i8) {
            int n18 = sePointArray[i8].length;
            for (int i9 = 0; i9 < n18; ++i9) {
                this.u[n2] = new SgSimpleShapePoint(sePointArray[i8][i9].X(), sePointArray[i8][i9].Y());
                ++n2;
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        try {
            this.setCoordRef(seCoordRef);
            SgShape sgShape = this.a();
            sgShape.generatePolygon(n17, 1, this.v, this.u, null, null);
            this.a(sgShape, true);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
    }

    SePolygon(SgSimpleShapePoint[] sgSimpleShapePointArray) {
        int n2 = sgSimpleShapePointArray.length;
        this.u = new SgSimpleShapePoint[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.u[i2] = new SgSimpleShapePoint(sgSimpleShapePointArray[i2].getX(), sgSimpleShapePointArray[i2].getY());
            if (GeometryException.a == 0) continue;
        }
    }

    SePolygon(SgSimpleShapePoint[] sgSimpleShapePointArray, double[] dArray) {
        int n2 = sgSimpleShapePointArray.length;
        this.u = new SgSimpleShapePoint[n2];
        this.w = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.u[i2] = new SgSimpleShapePoint(sgSimpleShapePointArray[i2].getX(), sgSimpleShapePointArray[i2].getY());
            this.w[i2] = dArray[i2];
            if (GeometryException.a == 0) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    SePolygon(SgSimpleShapePoint[] sgSimpleShapePointArray, double[] dArray, double[] dArray2) {
        int n2;
        int n3;
        int n4 = GeometryException.a;
        if (dArray2 == null) {
            n3 = sgSimpleShapePointArray.length;
            this.u = new SgSimpleShapePoint[n3];
            this.x = new double[n3];
            n2 = 0;
            do {
                if (n2 >= n3) return;
                this.u[n2] = new SgSimpleShapePoint(sgSimpleShapePointArray[n2].getX(), sgSimpleShapePointArray[n2].getY());
                this.x[n2] = dArray[n2];
                ++n2;
            } while (n4 == 0);
        }
        n3 = sgSimpleShapePointArray.length;
        this.u = new SgSimpleShapePoint[n3];
        this.x = new double[n3];
        this.w = new double[n3];
        n2 = 0;
        do {
            if (n2 >= n3) return;
            this.u[n2] = new SgSimpleShapePoint(sgSimpleShapePointArray[n2].getX(), sgSimpleShapePointArray[n2].getY());
            this.x[n2] = dArray[n2];
            this.w[n2] = dArray2[n2];
            ++n2;
        } while (n4 == 0);
    }

    public double area() throws SeGeometryException {
        double d2 = 0.0;
        try {
            SgShape sgShape = this.a();
            d2 = sgShape.getArea(0);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.area(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return d2;
    }

    public double perimeter() {
        return 0.0;
    }

    public Linestring exteriorRing() throws SeGeometryException {
        Linestring[] linestringArray = new Linestring[]{null};
        try {
            SgShape sgShape = this.a();
            int[] nArray = sgShape.getNumParts();
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (n2 >= 1 || n3 > 0) {
                SgShape sgShape2 = sgShape.asLine();
                sgShape = sgShape2.generateFromPart(1);
            }
            linestringArray[0] = (Linestring)((Object)SeSurface.b(sgShape));
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.exteriorRing(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return linestringArray[0];
    }

    public int numInteriorRings() throws SeGeometryException {
        int n2 = 0;
        if (this.u == null) {
            return 0;
        }
        try {
            SgShape sgShape = this.a();
            int[] nArray = sgShape.getNumParts();
            for (int i2 = 0; i2 < nArray[0]; ++i2) {
                n2 += sgShape.getNumSubParts(i2) - 1;
                if (GeometryException.a == 0) continue;
                break;
            }
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.numInteriorRings(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return n2;
    }

    public Linestring interiorRingN(int n2) throws SeGeometryException {
        Linestring[] linestringArray = new Linestring[]{null};
        if (n2 < 0) {
            return null;
        }
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape;
            block9: {
                block8: {
                    sgShape = this.a();
                    int[] nArray = sgShape.getNumParts();
                    int n3 = nArray[0];
                    int n4 = nArray[1];
                    if (n3 > 1) {
                        return null;
                    }
                    if (n4 <= n2) break block8;
                    SgShape sgShape2 = sgShape.asLine();
                    sgShape = sgShape2.generateFromPart(n2 + 1);
                    if (GeometryException.a == 0) break block9;
                }
                return null;
            }
            linestringArray[0] = (Linestring)((Object)SeSurface.b(sgShape));
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.interiorRingN(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return linestringArray[0];
    }

    public Point centroid() throws SeGeometryException {
        SePoint sePoint = null;
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape = this.a();
            SgShapeEnvelope sgShapeEnvelope = sgShape.getExtent(0);
            SeCoordRef seCoordRef = new SeCoordRef();
            seCoordRef.a(sgShape.getCoordRef());
            sePoint = new SePoint(seCoordRef, (sgShapeEnvelope.getMaxX() - sgShapeEnvelope.getMinX()) / 2.0 + sgShapeEnvelope.getMinX(), (sgShapeEnvelope.getMaxY() - sgShapeEnvelope.getMinY()) / 2.0 + sgShapeEnvelope.getMinY());
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.centroid(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return sePoint;
    }

    public Point pointOnSurface() throws SeGeometryException {
        SePoint sePoint = null;
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape = this.a();
            SgSimpleShapePoint sgSimpleShapePoint = sgShape.generateLabelPoint();
            SeCoordRef seCoordRef = new SeCoordRef();
            seCoordRef.a(sgShape.getCoordRef());
            sePoint = new SePoint(seCoordRef, sgSimpleShapePoint.getX(), sgSimpleShapePoint.getY());
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.pointOnSurface(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return sePoint;
    }

    public Geometry interior() {
        return null;
    }

    public Geometry exterior() {
        return null;
    }

    public Geometry boundary() throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = sgShape.asLine();
            geometryArray[0] = SeSurface.b(sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.boundary(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public Geometry buffer(double d2) throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = sgShape.generateBuffer(d2, 125000);
            geometryArray[0] = SeSurface.b(sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.buffer(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isEmpty() {
        boolean bl2 = false;
        if (this.u == null) {
            bl2 = true;
        }
        return bl2;
    }

    public int numPoints() throws SeGeometryException {
        int n2 = 0;
        try {
            SgShape sgShape = this.a();
            n2 = sgShape.getNumPoints(0, 0);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.numPoints(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return n2;
    }

    public Geometry envelope() throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape;
            block7: {
                SgSimpleShapePoint[] sgSimpleShapePointArray;
                block6: {
                    SgShape sgShape2 = this.a();
                    sgShape = SgShape.create(sgShape2.getCoordRef());
                    if (this.l != this.n && this.m != this.o) break block6;
                    sgSimpleShapePointArray = new SgSimpleShapePoint[]{new SgSimpleShapePoint(this.l, this.m), new SgSimpleShapePoint(this.n, this.o)};
                    sgShape.generateSimpleLine(2, 1, null, sgSimpleShapePointArray, null, null);
                    if (GeometryException.a == 0) break block7;
                }
                sgSimpleShapePointArray = new SgShapeEnvelope(this.l, this.m, this.n, this.o);
                sgShape.generateRectangle((SgShapeEnvelope)sgSimpleShapePointArray);
            }
            geometryArray[0] = SePolygon.b(sgShape);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.envelope(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public int dimension() {
        return 2;
    }

    public boolean isMeasured() {
        return this.w != null;
    }

    public boolean is3D() {
        return this.x != null;
    }

    public String geometryType() {
        return "Polygon";
    }

    public Geometry convexhull() throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.u == null) {
            return geometryArray[0];
        }
        if (this.j < 3) {
            return geometryArray[0];
        }
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = sgShape.generateConvexHull();
            geometryArray[0] = SeSurface.b(sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.convexhull(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public Geometry locateAlong(double d2) throws SeGeometryException {
        int n2 = GeometryException.a;
        Geometry[] geometryArray = new Geometry[]{null};
        try {
            SgShape sgShape = this.a();
            SgShape[] sgShapeArray = sgShape.findAlong(d2);
            if (sgShapeArray == null) {
                return null;
            }
            SgShape sgShape2 = null;
            for (int i2 = 0; i2 < sgShapeArray.length; ++i2) {
                int n3 = sgShapeArray[i2].getType();
                if ((2 & n3) != 0 || (4 & n3) != 0) {
                    sgShape2 = sgShapeArray[i2];
                    if (n2 == 0) break;
                }
                sgShape2 = sgShapeArray[i2];
                if (n2 == 0) continue;
            }
            if (sgShape2 != null) {
                geometryArray[0] = SePolygon.b(sgShape2);
            }
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.locateAlong(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public Geometry locateBetween(double d2, double d3) throws SeGeometryException {
        int n2 = GeometryException.a;
        Geometry[] geometryArray = new Geometry[]{null};
        try {
            SgShape sgShape = this.a();
            SgShape[] sgShapeArray = sgShape.findBetween(d2, d3);
            if (sgShapeArray == null) {
                return null;
            }
            SgShape sgShape2 = null;
            for (int i2 = 0; i2 < sgShapeArray.length; ++i2) {
                int n3 = sgShapeArray[i2].getType();
                if ((2 & n3) == 1 || (4 & n3) == 1) {
                    sgShape2 = sgShapeArray[i2];
                    if (n2 == 0) break;
                }
                sgShape2 = sgShapeArray[i2];
                if (n2 == 0) continue;
            }
            if (sgShape2 != null) {
                geometryArray[0] = SePolygon.b(sgShape2);
            }
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SePolygon.locateBetween(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public SePoint[] getXYs() {
        SePoint[] sePointArray = new SePoint[this.u.length];
        for (int i2 = 0; i2 < this.u.length; ++i2) {
            sePointArray[i2] = new SePoint(this.u[i2].getX(), this.u[i2].getY());
            if (GeometryException.a == 0) continue;
        }
        return sePointArray;
    }

    public double[] getMs() {
        double[] dArray = new double[this.w.length];
        for (int i2 = 0; i2 < this.w.length; ++i2) {
            dArray[i2] = this.w[i2];
            if (GeometryException.a == 0) continue;
        }
        return dArray;
    }

    public double[] getZs() {
        double[] dArray = new double[this.x.length];
        for (int i2 = 0; i2 < this.x.length; ++i2) {
            dArray[i2] = this.x[i2];
            if (GeometryException.a == 0) continue;
        }
        return dArray;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public String toString() {
        int n2;
        int n3 = GeometryException.a;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.u == null) {
            stringBuffer.append("SePolygon Empty");
            if (n3 == 0) return new String(stringBuffer);
        }
        stringBuffer.append("SePolygon:\n");
        if (this.is3D() && this.isMeasured()) {
            n2 = 0;
            do {
                if (n2 >= this.u.length) return new String(stringBuffer);
                stringBuffer.append("(SePoint : ").append(n2).append(" dx=").append(this.u[n2].getX()).append(",dy=").append(this.u[n2].getY()).append(",z=").append(this.x[n2]).append(" m=").append(this.w[n2]).append(")\n");
                ++n2;
            } while (n3 == 0);
        }
        if (this.is3D()) {
            n2 = 0;
            do {
                if (n2 >= this.u.length) return new String(stringBuffer);
                stringBuffer.append("(SePoint : ").append(n2).append(" dx=").append(this.u[n2].getX()).append(",dy=").append(this.u[n2].getY()).append(",z=").append(this.x[n2]).append(")\n");
                ++n2;
            } while (n3 == 0);
        }
        if (this.isMeasured()) {
            n2 = 0;
            do {
                if (n2 >= this.u.length) return new String(stringBuffer);
                stringBuffer.append("(SePoint : ").append(n2).append(" dx=").append(this.u[n2].getX()).append(",dy=").append(this.u[n2].getY()).append(",ms=").append(this.w[n2]).append(")\n");
                ++n2;
            } while (n3 == 0);
        }
        n2 = 0;
        do {
            if (n2 >= this.u.length) return new String(stringBuffer);
            stringBuffer.append("(SePoint : ").append(n2).append(" dx=").append(this.u[n2].getX()).append(",dy=").append(this.u[n2].getY()).append(")\n");
            ++n2;
        } while (n3 == 0);
        return new String(stringBuffer);
    }
}

