/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.geom;

import com.esri.sde.sdk.geom.Geometry;
import com.esri.sde.sdk.geom.GeometryException;
import com.esri.sde.sdk.geom.MultiPolygon;
import com.esri.sde.sdk.geom.Point;
import com.esri.sde.sdk.geom.SeCoordRef;
import com.esri.sde.sdk.geom.SeGeometryException;
import com.esri.sde.sdk.geom.SeMultiSurface;
import com.esri.sde.sdk.geom.SePoint;
import com.esri.sde.sdk.geom.SePolygon;
import com.esri.sde.sdk.sg.SgCoordRef;
import com.esri.sde.sdk.sg.SgException;
import com.esri.sde.sdk.sg.SgShape;
import com.esri.sde.sdk.sg.SgShapeEnvelope;
import com.esri.sde.sdk.sg.SgSimpleShapePoint;
import java.io.Serializable;

public class SeMultiPolygon
extends SeMultiSurface
implements MultiPolygon,
Cloneable,
Serializable {
    protected double[] v;
    protected double[] w;
    protected int[] x;

    public SeMultiPolygon() throws SeGeometryException {
        try {
            SgCoordRef sgCoordRef = SgCoordRef.create();
            SeCoordRef seCoordRef = new SeCoordRef();
            seCoordRef.a(sgCoordRef);
            this.j = 0;
            SgSimpleShapePoint[] sgSimpleShapePointArray = new SgSimpleShapePoint[]{};
            this.setCoordRef(seCoordRef);
            SgShape sgShape = this.a();
            this.a(sgShape, true);
        }
        catch (SgException sgException) {
            throw new SeGeometryException(sgException);
        }
    }

    public SeMultiPolygon(SeCoordRef seCoordRef, SePolygon[] sePolygonArray) throws SeGeometryException {
        int n2;
        int n3 = GeometryException.a;
        if (sePolygonArray[0].is3D() && sePolygonArray[0].isMeasured()) {
            int n4;
            int n5 = 0;
            int n6 = sePolygonArray.length;
            this.x = new int[n6];
            for (n4 = 0; n4 < n6; ++n4) {
                this.x[n4] = n5;
                n5 += sePolygonArray[n4].numPoints();
                if (n3 == 0) continue;
            }
            this.j = n5;
            this.u = new SgSimpleShapePoint[n5];
            this.v = new double[n5];
            this.w = new double[n5];
            n4 = 0;
            for (int i2 = 0; i2 < n6; ++i2) {
                SePoint[] sePointArray = sePolygonArray[i2].getXYs();
                double[] dArray = sePolygonArray[i2].getZs();
                double[] dArray2 = sePolygonArray[i2].getMs();
                for (int i3 = 0; i3 < sePointArray.length; ++i3) {
                    this.u[n4] = new SgSimpleShapePoint(sePointArray[i3].X(), sePointArray[i3].Y());
                    this.v[n4] = dArray[i3];
                    this.w[n4++] = dArray2[i3];
                    if (n3 == 0) continue;
                }
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(n5, n6, this.x, this.u, this.v, this.w);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SeMultiPolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        if (sePolygonArray[0].is3D()) {
            int n7 = 0;
            int n8 = sePolygonArray.length;
            this.x = new int[n8];
            int n9 = 0;
            int n10 = 1;
            while (n9 < n8) {
                this.x[n9] = n7;
                n7 += sePolygonArray[n9].numPoints();
                ++n9;
                ++n10;
                if (n3 == 0) continue;
            }
            this.j = n7;
            this.u = new SgSimpleShapePoint[n7];
            this.v = new double[n7];
            n9 = 0;
            for (n10 = 0; n10 < n8; ++n10) {
                SePoint[] sePointArray = sePolygonArray[n10].getXYs();
                double[] dArray = sePolygonArray[n10].getZs();
                for (int i4 = 0; i4 < sePointArray.length; ++i4) {
                    this.u[n9] = new SgSimpleShapePoint(sePointArray[i4].X(), sePointArray[i4].Y());
                    this.v[n9++] = dArray[i4];
                    if (n3 == 0) continue;
                }
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(n7, n8, this.x, this.u, this.v, null);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SeMultiPolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        if (sePolygonArray[0].isMeasured()) {
            int n11 = 0;
            int n12 = sePolygonArray.length;
            this.x = new int[n12];
            int n13 = 0;
            int n14 = 1;
            while (n13 < n12) {
                this.x[n13] = n11;
                n11 += sePolygonArray[n13].numPoints();
                ++n13;
                ++n14;
                if (n3 == 0) continue;
            }
            this.j = n11;
            this.u = new SgSimpleShapePoint[n11];
            this.w = new double[n11];
            n13 = 0;
            for (n14 = 0; n14 < n12; ++n14) {
                SePoint[] sePointArray = sePolygonArray[n14].getXYs();
                double[] dArray = sePolygonArray[n14].getMs();
                for (int i5 = 0; i5 < sePointArray.length; ++i5) {
                    this.u[n13] = new SgSimpleShapePoint(sePointArray[i5].X(), sePointArray[i5].Y());
                    this.w[n13++] = dArray[i5];
                    if (n3 == 0) continue;
                }
                if (n3 == 0) continue;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgShape sgShape = this.a();
                sgShape.generatePolygon(n11, n12, this.x, this.u, null, this.w);
                this.a(sgShape, true);
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SeMultiPolygon(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        int n15 = 0;
        int n16 = sePolygonArray.length;
        this.x = new int[n16];
        for (n2 = 0; n2 < n16; ++n2) {
            this.x[n2] = n15;
            n15 += sePolygonArray[n2].numPoints();
            if (n3 == 0) continue;
        }
        this.j = n15;
        this.u = new SgSimpleShapePoint[n15];
        n2 = 0;
        for (int i6 = 0; i6 < n16; ++i6) {
            SePoint[] sePointArray = sePolygonArray[i6].getXYs();
            for (int i7 = 0; i7 < sePointArray.length; ++i7) {
                this.u[n2++] = new SgSimpleShapePoint(sePointArray[i7].X(), sePointArray[i7].Y());
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        try {
            this.setCoordRef(seCoordRef);
            SgShape sgShape = this.a();
            sgShape.generatePolygon(n15, n16, this.x, this.u, null, null);
            this.a(sgShape, true);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
    }

    SeMultiPolygon(int[] nArray, SgSimpleShapePoint[] sgSimpleShapePointArray) {
        int n2 = GeometryException.a;
        int n3 = sgSimpleShapePointArray.length - (nArray.length - 1);
        this.x = new int[nArray.length];
        int n4 = 0;
        int n5 = 0;
        while (n4 < nArray.length) {
            this.x[n4] = nArray[n4] - n5;
            ++n4;
            ++n5;
            if (n2 == 0) continue;
        }
        this.u = new SgSimpleShapePoint[n3];
        n4 = sgSimpleShapePointArray.length;
        n5 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            block6: {
                block5: {
                    if (i2 != nArray.length - 1) break block5;
                    n4 = sgSimpleShapePointArray.length;
                    if (n2 == 0) break block6;
                }
                n4 = nArray[i2 + 1] - 1;
            }
            for (int i3 = nArray[i2]; i3 < n4; ++i3) {
                this.u[n5] = new SgSimpleShapePoint(sgSimpleShapePointArray[i3].getX(), sgSimpleShapePointArray[i3].getY());
                ++n5;
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
    }

    SeMultiPolygon(int[] nArray, SgSimpleShapePoint[] sgSimpleShapePointArray, double[] dArray) {
        int n2 = GeometryException.a;
        int n3 = sgSimpleShapePointArray.length - (nArray.length - 1);
        this.x = new int[nArray.length];
        int n4 = 0;
        int n5 = 0;
        while (n4 < nArray.length) {
            this.x[n4] = nArray[n4] - n5;
            ++n4;
            ++n5;
            if (n2 == 0) continue;
        }
        this.u = new SgSimpleShapePoint[n3];
        this.w = new double[n3];
        n4 = sgSimpleShapePointArray.length;
        n5 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            block6: {
                block5: {
                    if (i2 != nArray.length - 1) break block5;
                    n4 = sgSimpleShapePointArray.length;
                    if (n2 == 0) break block6;
                }
                n4 = nArray[i2 + 1] - 1;
            }
            for (int i3 = nArray[i2]; i3 < n4; ++i3) {
                this.u[n5] = new SgSimpleShapePoint(sgSimpleShapePointArray[i3].getX(), sgSimpleShapePointArray[i3].getY());
                this.w[n5] = dArray[i3];
                ++n5;
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    SeMultiPolygon(int[] nArray, SgSimpleShapePoint[] sgSimpleShapePointArray, double[] dArray, double[] dArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        block10: {
            n7 = GeometryException.a;
            if (dArray2 != null) break block10;
            n6 = sgSimpleShapePointArray.length - (nArray.length - 1);
            this.x = new int[nArray.length];
            n5 = 0;
            for (n4 = 0; n4 < nArray.length; ++n4, ++n5) {
                this.x[n4] = nArray[n4] - n5;
                if (n7 == 0) continue;
            }
            this.u = new SgSimpleShapePoint[n6];
            this.v = new double[n6];
            n4 = sgSimpleShapePointArray.length;
            n5 = 0;
            n3 = 0;
            do {
                block12: {
                    block11: {
                        if (n3 >= nArray.length) return;
                        if (n3 != nArray.length - 1) break block11;
                        n4 = sgSimpleShapePointArray.length;
                        if (n7 == 0) break block12;
                    }
                    n4 = nArray[n3 + 1] - 1;
                }
                for (n2 = nArray[n3]; n2 < n4; ++n5, ++n2) {
                    this.u[n5] = new SgSimpleShapePoint(sgSimpleShapePointArray[n2].getX(), sgSimpleShapePointArray[n2].getY());
                    this.v[n5] = dArray[n2];
                    if (n7 == 0) continue;
                }
                ++n3;
            } while (n7 == 0);
        }
        n6 = sgSimpleShapePointArray.length - (nArray.length - 1);
        this.x = new int[nArray.length];
        n5 = 0;
        for (n4 = 0; n4 < nArray.length; ++n4, ++n5) {
            this.x[n4] = nArray[n4] - n5;
            if (n7 == 0) continue;
        }
        this.u = new SgSimpleShapePoint[n6];
        this.v = new double[n6];
        this.w = new double[n6];
        n4 = sgSimpleShapePointArray.length;
        n5 = 0;
        n3 = 0;
        do {
            block14: {
                block13: {
                    if (n3 >= nArray.length) return;
                    if (n3 != nArray.length - 1) break block13;
                    n4 = sgSimpleShapePointArray.length;
                    if (n7 == 0) break block14;
                }
                n4 = nArray[n3 + 1] - 1;
            }
            for (n2 = nArray[n3]; n2 < n4; ++n5, ++n2) {
                this.u[n5] = new SgSimpleShapePoint(sgSimpleShapePointArray[n2].getX(), sgSimpleShapePointArray[n2].getY());
                this.v[n5] = dArray[n2];
                this.w[n5] = dArray2[n2];
                if (n7 == 0) continue;
            }
            ++n3;
        } while (n7 == 0);
    }

    public double area() throws SeGeometryException {
        double d2 = 0.0;
        try {
            SgShape sgShape = this.a();
            d2 = sgShape.getArea(0);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon.area(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return d2;
    }

    public Point centroid() throws SeGeometryException {
        SePoint sePoint = null;
        try {
            SgShape sgShape = this.a();
            SgShapeEnvelope sgShapeEnvelope = sgShape.getExtent(0);
            SeCoordRef seCoordRef = new SeCoordRef();
            seCoordRef.a(sgShape.getCoordRef());
            sePoint = new SePoint(seCoordRef, (sgShapeEnvelope.getMaxX() - sgShapeEnvelope.getMinX()) / 2.0 + sgShapeEnvelope.getMinX(), (sgShapeEnvelope.getMaxY() - sgShapeEnvelope.getMinY()) / 2.0 + sgShapeEnvelope.getMinY());
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon.centroid(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return sePoint;
    }

    public Point pointOnSurface() throws SeGeometryException {
        SePoint sePoint = null;
        try {
            SgShape sgShape = this.a();
            SgSimpleShapePoint sgSimpleShapePoint = sgShape.generateLabelPoint();
            SeCoordRef seCoordRef = new SeCoordRef();
            seCoordRef.a(sgShape.getCoordRef());
            sePoint = new SePoint(seCoordRef, sgSimpleShapePoint.getX(), sgSimpleShapePoint.getY());
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon.pointOnSurface(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return sePoint;
    }

    public Geometry envelope() throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape;
            block7: {
                SgSimpleShapePoint[] sgSimpleShapePointArray;
                block6: {
                    SgShape sgShape2 = this.a();
                    sgShape = SgShape.create(sgShape2.getCoordRef());
                    if (this.l != this.n && this.m != this.o) break block6;
                    sgSimpleShapePointArray = new SgSimpleShapePoint[]{new SgSimpleShapePoint(this.l, this.m), new SgSimpleShapePoint(this.n, this.o)};
                    sgShape.generateSimpleLine(2, 1, null, sgSimpleShapePointArray, null, null);
                    if (GeometryException.a == 0) break block7;
                }
                sgSimpleShapePointArray = new SgShapeEnvelope(this.l, this.m, this.n, this.o);
                sgShape.generateRectangle((SgShapeEnvelope)sgSimpleShapePointArray);
            }
            geometryArray[0] = SeMultiPolygon.b(sgShape);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon.envelope(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public Geometry buffer(double d2) throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = sgShape.generateBuffer(d2, 125000);
            geometryArray[0] = SeMultiSurface.b(sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon.buffer(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public Geometry boundary() throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.u == null) {
            return null;
        }
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = sgShape.asLine();
            geometryArray[0] = SeMultiSurface.b(sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon.boundary(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public Geometry geometryN(int n2) throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.u == null) {
            return null;
        }
        if (n2 < 1) {
            return null;
        }
        if (this.j == 0) {
            return null;
        }
        if (n2 > this.x.length) {
            return null;
        }
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = sgShape.generateFromPart(n2);
            geometryArray[0] = SeMultiSurface.b(sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon.geometryN(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isMeasured() {
        return this.w != null;
    }

    public boolean is3D() {
        return this.v != null;
    }

    public int numGeometries() throws SeGeometryException {
        int n2 = 0;
        try {
            SgShape sgShape = this.a();
            int[] nArray = sgShape.getNumParts();
            n2 = nArray[0];
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeMultiPolygon.numGeometries(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public String toString() {
        int n2;
        int n3;
        int n4;
        int n5 = GeometryException.a;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.u == null) {
            stringBuffer.append("SeMultiPolygon Empty");
            if (n5 == 0) return new String(stringBuffer);
        }
        stringBuffer.append("SeMultiPolygon:\n");
        if (this.is3D() && this.isMeasured()) {
            n4 = 0;
            do {
                if (n4 >= this.x.length) return new String(stringBuffer);
                stringBuffer.append("Part").append(n4).append(":\n");
                n3 = this.u.length;
                if (n4 < this.x.length - 1) {
                    n3 = this.x[n4 + 1];
                }
                for (n2 = this.x[n4]; n2 < n3; ++n2) {
                    stringBuffer.append("(SePoint : ").append(n2).append(" dx=").append(this.u[n2].getX()).append(",dy=").append(this.u[n2].getY()).append(" z=").append(this.v[n2]).append(" m=").append(this.w[n2]).append(")\n");
                    if (n5 == 0) continue;
                }
                ++n4;
            } while (n5 == 0);
        }
        if (this.is3D()) {
            n4 = 0;
            do {
                if (n4 >= this.x.length) return new String(stringBuffer);
                stringBuffer.append("Part").append(n4).append(":\n");
                n3 = this.u.length;
                if (n4 < this.x.length - 1) {
                    n3 = this.x[n4 + 1];
                }
                for (n2 = this.x[n4]; n2 < n3; ++n2) {
                    stringBuffer.append("(SePoint: ").append(n2).append(" dx=").append(this.u[n2].getX()).append(",dy=").append(this.u[n2].getY()).append(" z=").append(this.v[n2]).append(")\n");
                    if (n5 == 0) continue;
                }
                ++n4;
            } while (n5 == 0);
        }
        if (this.isMeasured()) {
            n4 = 0;
            do {
                if (n4 >= this.x.length) return new String(stringBuffer);
                stringBuffer.append("Part").append(n4).append(":\n");
                n3 = this.u.length;
                if (n4 < this.x.length - 1) {
                    n3 = this.x[n4 + 1];
                }
                for (n2 = this.x[n4]; n2 < n3; ++n2) {
                    stringBuffer.append("(SePoint : ").append(n2).append(" dx=").append(this.u[n2].getX()).append(",dy=").append(this.u[n2].getY()).append(" m=").append(this.w[n2]).append(")\n");
                    if (n5 == 0) continue;
                }
                ++n4;
            } while (n5 == 0);
        }
        n4 = 0;
        do {
            if (n4 >= this.x.length) return new String(stringBuffer);
            stringBuffer.append("Part").append(n4).append(":\n");
            n3 = this.u.length;
            if (n4 < this.x.length - 1) {
                n3 = this.x[n4 + 1];
            }
            for (n2 = this.x[n4]; n2 < n3; ++n2) {
                stringBuffer.append("(SePoint : ").append(n2).append(" dx=").append(this.u[n2].getX()).append(",dy=").append(this.u[n2].getY()).append(")\n");
                if (n5 == 0) continue;
            }
            ++n4;
        } while (n5 == 0);
        return new String(stringBuffer);
    }

    public int dimension() {
        return 2;
    }

    public String geometryType() {
        return "MultiPolygon";
    }
}

