/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.geom;

import com.esri.sde.sdk.geom.Geometry;
import com.esri.sde.sdk.geom.GeometryException;
import com.esri.sde.sdk.geom.SeCoordRef;
import com.esri.sde.sdk.geom.SeEnvelope;
import com.esri.sde.sdk.geom.SeGeometryException;
import com.esri.sde.sdk.geom.SeLinestring;
import com.esri.sde.sdk.geom.SeMultiLinestring;
import com.esri.sde.sdk.geom.SeMultiPoint;
import com.esri.sde.sdk.geom.SeMultiPolygon;
import com.esri.sde.sdk.geom.SePoint;
import com.esri.sde.sdk.geom.SePolygon;
import com.esri.sde.sdk.geom.b;
import com.esri.sde.sdk.sg.ENVELOPE;
import com.esri.sde.sdk.sg.SgBinaryShape;
import com.esri.sde.sdk.sg.SgCoordRef;
import com.esri.sde.sdk.sg.SgException;
import com.esri.sde.sdk.sg.SgShape;
import com.esri.sde.sdk.sg.SgShapeEnvelope;
import com.esri.sde.sdk.sg.SgSimpleIntPoint;
import com.esri.sde.sdk.sg.SgSimpleShapePoint;
import com.esri.sde.sdk.sg.SgTextShape;
import com.esri.sde.sdk.sg.Sgs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class SeGeometry
implements Geometry,
Cloneable,
Serializable {
    public static final int UNSPECIFIED_TYPE = 0;
    public static final int POINT_TYPE = 4;
    public static final int POINTM_TYPE = 5;
    public static final int POINTZ_TYPE = 6;
    public static final int POINTZM_TYPE = 7;
    public static final int MULTIPOINT_TYPE = 8;
    public static final int MULTIPOINTM_TYPE = 9;
    public static final int MULTIPOINTZ_TYPE = 10;
    public static final int MULTIPOINTZM_TYPE = 11;
    public static final int LINESTRING_TYPE = 12;
    public static final int LINESTRINGM_TYPE = 13;
    public static final int LINESTRINGZ_TYPE = 14;
    public static final int LINESTRINGZM_TYPE = 15;
    public static final int POLYGON_TYPE = 16;
    public static final int POLYGONM_TYPE = 17;
    public static final int POLYGONZ_TYPE = 18;
    public static final int POLYGONZM_TYPE = 19;
    public static final int MULTILINESTRING_TYPE = 20;
    public static final int MULTILINESTRINGM_TYPE = 21;
    public static final int MULTILINESTRINGZ_TYPE = 22;
    public static final int MULTILINESTRINGZM_TYPE = 23;
    public static final int MULTIPOLYGON_TYPE = 24;
    public static final int MULTIPOLYGONM_TYPE = 25;
    public static final int MULTIPOLYGONZ_TYPE = 26;
    public static final int MULTIPOLYGONZM_TYPE = 27;
    protected int a;
    protected double b;
    protected double c;
    protected double d;
    protected double e;
    protected double f;
    protected double g;
    protected double h;
    protected String i;
    protected int j;
    protected int k;
    protected double l;
    protected double m;
    protected double n;
    protected double o;
    protected double p;
    protected double q;
    protected double r;
    protected double s;
    protected byte[] t;

    public abstract Geometry interior() throws SeGeometryException;

    public abstract Geometry exterior() throws SeGeometryException;

    public abstract Geometry boundary() throws SeGeometryException;

    public abstract Geometry buffer(double var1) throws SeGeometryException;

    public abstract boolean isSimple() throws SeGeometryException;

    public abstract boolean isEmpty() throws SeGeometryException;

    public boolean isValid() throws SeGeometryException {
        boolean bl2 = true;
        SgShape sgShape = this.a();
        bl2 = false;
        return bl2;
    }

    public abstract int numPoints() throws SeGeometryException;

    public abstract Geometry envelope() throws SeGeometryException;

    public abstract int dimension() throws SeGeometryException;

    public abstract boolean is3D() throws SeGeometryException;

    public abstract boolean isMeasured() throws SeGeometryException;

    public int srid() throws SeGeometryException {
        return this.a;
    }

    public abstract String geometryType() throws SeGeometryException;

    public ByteArrayOutputStream asBinary() throws SeGeometryException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            SgShape sgShape = this.a();
            SgBinaryShape sgBinaryShape = new SgBinaryShape();
            byteArrayOutputStream = SgBinaryShape.shapeToBinary(sgShape);
        }
        catch (SgException sgException) {
            throw new SeGeometryException(sgException.getMessage());
        }
        return byteArrayOutputStream;
    }

    public String asText() throws SeGeometryException {
        String string = null;
        SgShape sgShape = this.a();
        SgTextShape sgTextShape = new SgTextShape();
        string = sgTextShape.shapeToText(sgShape, 0);
        return string;
    }

    public ByteArrayOutputStream asBinaryShape() throws SeGeometryException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            SgShape sgShape = this.a();
            SgBinaryShape sgBinaryShape = new SgBinaryShape();
            byteArrayOutputStream = SgBinaryShape.shapeToBinary(sgShape);
        }
        catch (SgException sgException) {
            throw new SeGeometryException(sgException.getMessage());
        }
        return byteArrayOutputStream;
    }

    public abstract Geometry convexhull() throws SeGeometryException;

    public Geometry locateAlong(double d2) throws SeGeometryException {
        return null;
    }

    public Geometry locateBetween(double d2, double d3) throws SeGeometryException {
        return null;
    }

    public boolean envelopesIntersect(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = !SgShape.isDisjoint(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.envelopesIntersect(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public boolean equal(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = SgShape.isEqual(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.equal(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public boolean disjoint(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = SgShape.isDisjoint(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.disjoint(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public boolean intersect(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = !SgShape.isDisjoint(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.intersect(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public boolean touch(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = SgShape.isTouching(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.touch(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public boolean overlap(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = SgShape.isOverlapping(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.overlap(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public boolean crosses(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = SgShape.isCrossing(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.crosses(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public boolean within(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = SgShape.isWithin(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.within(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public boolean contains(Geometry geometry) throws SeGeometryException {
        boolean bl2 = false;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            bl2 = SgShape.isContaining(sgShape, sgShape2);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.contains(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return bl2;
    }

    public double distance(Geometry geometry) throws SeGeometryException {
        double d2 = 0.0;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            if (sgShape.isNil() || sgShape2.isNil()) {
                return 0.0;
            }
            d2 = SgShape.calculateDistance(sgShape, sgShape2, false);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.distance(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return d2;
    }

    public Geometry[] intersection(Geometry geometry) throws SeGeometryException {
        Geometry[] geometryArray = null;
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            SgShape[] sgShapeArray = SgShape.intersect(sgShape, sgShape2);
            geometryArray = new Geometry[sgShapeArray.length];
            for (int i2 = 0; i2 < sgShapeArray.length; ++i2) {
                geometryArray[i2] = SeGeometry.b(sgShapeArray[i2]);
                if (GeometryException.a == 0) continue;
                break;
            }
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.intersection(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray;
    }

    public Geometry difference(Geometry geometry) throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            SgShape sgShape3 = SgShape.difference(sgShape, sgShape2);
            geometryArray[0] = SeGeometry.b(sgShape3);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.difference(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public Geometry union(Geometry geometry) throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            SgShape sgShape3 = SgShape.union(sgShape, sgShape2);
            geometryArray[0] = SeGeometry.b(sgShape3);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.union(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public Geometry symmetricDiff(Geometry geometry) throws SeGeometryException {
        Geometry[] geometryArray = new Geometry[]{null};
        try {
            SgShape sgShape = this.a();
            SgShape sgShape2 = ((SeGeometry)geometry).a();
            SgShape sgShape3 = SgShape.symmetricalDifference(sgShape, sgShape2);
            geometryArray[0] = SeGeometry.b(sgShape3);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.symmetricDiff(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return geometryArray[0];
    }

    public double getMinX() throws SeGeometryException {
        return this.l;
    }

    public double getMinY() throws SeGeometryException {
        return this.m;
    }

    public double getMaxX() throws SeGeometryException {
        return this.n;
    }

    public double getMaxY() throws SeGeometryException {
        return this.o;
    }

    public void setCoordRef(SeCoordRef seCoordRef) {
        this.a = seCoordRef.getSrid();
        this.b = seCoordRef.getFalseX();
        this.c = seCoordRef.getFalseY();
        this.d = seCoordRef.getXYUnits();
        this.e = seCoordRef.getFalseZ();
        this.f = seCoordRef.getZUnits();
        this.g = seCoordRef.getFalseM();
        this.h = seCoordRef.getMUnits();
        this.i = seCoordRef.getProjectionStr();
    }

    public String toString() {
        return null;
    }

    protected SgShape a() throws SeGeometryException {
        SgShape sgShape;
        block6: {
            sgShape = null;
            SgCoordRef sgCoordRef = null;
            try {
                sgCoordRef = SgCoordRef.create();
                sgCoordRef.setXY(this.b, this.b, this.d);
                sgCoordRef.setZ(this.e, this.f);
                sgCoordRef.setM(this.g, this.h);
                sgCoordRef.setDescription(this.i);
                sgCoordRef.setSrId(this.a);
                sgShape = SgShape.create(sgCoordRef);
                if (this.j == 0) {
                    sgShape.makeNil();
                    if (GeometryException.a == 0) break block6;
                }
                try {
                    if (this.t != null) {
                        this.a(sgShape);
                    }
                }
                catch (IOException iOException) {
                    String string = "\nERROR: SeGeometry.sdeMakeShapeFromArgs(), " + iOException.getMessage();
                    System.out.println(string);
                    throw new SeGeometryException(string);
                }
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SeGeometry.sdeMakeShapeFromArgs(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
        return sgShape;
    }

    private void a(SgShape sgShape) throws IOException {
        int n2 = GeometryException.a;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.t);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n3;
            com.esri.sde.sdk.geom.b.f(sgShape, dataInputStream.readInt());
            com.esri.sde.sdk.geom.b.g(sgShape, dataInputStream.readInt());
            int n4 = dataInputStream.readInt();
            long l2 = dataInputStream.readLong();
            long l3 = dataInputStream.readLong();
            boolean bl2 = false;
            if ((l2 & 1L) == 1L) {
                bl2 = true;
            }
            boolean bl3 = false;
            if ((l2 & 2L) == 2L) {
                bl3 = true;
            }
            int n5 = com.esri.sde.sdk.geom.b.A(sgShape);
            SgSimpleIntPoint[] sgSimpleIntPointArray = new SgSimpleIntPoint[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                sgSimpleIntPointArray[i2] = new SgSimpleIntPoint(dataInputStream.readLong(), dataInputStream.readLong());
                if (n2 == 0) continue;
            }
            com.esri.sde.sdk.geom.b.b(sgShape, sgSimpleIntPointArray);
            long[] lArray = null;
            if (bl2) {
                lArray = new long[n5];
                for (int i3 = 0; i3 < n5; ++i3) {
                    lArray[i3] = dataInputStream.readLong();
                    if (n2 == 0) continue;
                }
                com.esri.sde.sdk.geom.b.c(sgShape, lArray);
            }
            long[] lArray2 = null;
            if (bl3) {
                lArray2 = new long[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    lArray2[n3] = dataInputStream.readLong();
                    if (n2 == 0) continue;
                }
                com.esri.sde.sdk.geom.b.d(sgShape, lArray2);
            }
            for (n3 = 1; n3 < n5; ++n3) {
                sgSimpleIntPointArray[n3].setX(sgSimpleIntPointArray[n3 - 1].getX() + sgSimpleIntPointArray[n3].getX());
                sgSimpleIntPointArray[n3].setY(sgSimpleIntPointArray[n3 - 1].getY() + sgSimpleIntPointArray[n3].getY());
                if (n2 == 0) continue;
            }
            com.esri.sde.sdk.geom.b.b(sgShape, sgSimpleIntPointArray);
            if (lArray != null) {
                for (n3 = 1; n3 < n5; ++n3) {
                    lArray[n3] = lArray[n3 - 1] + lArray[n3];
                    if (n2 == 0) continue;
                }
                com.esri.sde.sdk.geom.b.c(sgShape, lArray);
            }
            if (lArray2 != null) {
                for (n3 = 1; n3 < n5; ++n3) {
                    lArray2[n3] = lArray2[n3 - 1] + lArray2[n3];
                    if (n2 == 0) continue;
                }
                com.esri.sde.sdk.geom.b.d(sgShape, lArray2);
            }
            sgShape.getExtent(0);
            sgShape.getArea(0);
            sgShape.getLength(0);
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.featureCompress(), " + sgException.getMessage());
            throw new IOException();
        }
    }

    protected void a(SgShape sgShape, boolean bl2) throws SeGeometryException {
        block4: {
            try {
                int n2;
                if (sgShape.getType() == 0) break block4;
                boolean bl3 = sgShape.is3D();
                boolean bl4 = sgShape.isMeasured();
                this.k = n2 = SeGeometry.a(sgShape.getType(), bl3, bl4);
                this.j = com.esri.sde.sdk.geom.b.A(sgShape);
                ENVELOPE eNVELOPE = new ENVELOPE(com.esri.sde.sdk.geom.b.t(sgShape), com.esri.sde.sdk.geom.b.u(sgShape), com.esri.sde.sdk.geom.b.v(sgShape), com.esri.sde.sdk.geom.b.w(sgShape));
                SeEnvelope seEnvelope = new SeEnvelope();
                seEnvelope.a(eNVELOPE);
                seEnvelope.a(sgShape.getCoordRef());
                double[] dArray = sgShape.getZRange(0);
                this.p = dArray[0];
                this.q = dArray[1];
                double[] dArray2 = sgShape.getMRange(0);
                this.r = dArray2[0];
                this.s = dArray2[1];
                this.l = seEnvelope.getMinX();
                this.m = seEnvelope.getMinY();
                this.n = seEnvelope.getMaxX();
                this.o = seEnvelope.getMaxY();
                try {
                    this.c(sgShape);
                }
                catch (IOException iOException) {
                    String string = "\nERROR: SeGeometry.sdeShapeGetParams(), " + iOException.getMessage();
                    System.out.println(string);
                    throw new SeGeometryException(string);
                }
            }
            catch (SgException sgException) {
                System.out.println("\nERROR: SeGeometry.sdeShapeGetParams(), " + sgException.getMessage());
                throw new SeGeometryException(sgException.getCode());
            }
        }
    }

    protected static SeGeometry b(SgShape sgShape) throws SeGeometryException {
        int n2 = GeometryException.a;
        SeGeometry[] seGeometryArray = new SeGeometry[]{null};
        try {
            if (sgShape.getType() != 0) {
                Object object;
                boolean bl2 = sgShape.is3D();
                boolean bl3 = sgShape.isMeasured();
                int n3 = sgShape.getType();
                int n4 = SeGeometry.a(n3, bl2, bl3);
                int n5 = com.esri.sde.sdk.geom.b.A(sgShape);
                SgSimpleShapePoint[] sgSimpleShapePointArray = new SgSimpleShapePoint[n5];
                double[] dArray = new double[n5];
                double[] dArray2 = new double[n5];
                int[] nArray = sgShape.getNumParts();
                int[] nArray2 = new int[nArray[0]];
                SgSimpleIntPoint[] sgSimpleIntPointArray = com.esri.sde.sdk.geom.b.C(sgShape);
                int n6 = 0;
                int n7 = 0;
                for (int i2 = 0; i2 < n5; ++i2) {
                    nArray2[n6] = n7;
                    if (!com.esri.sde.sdk.geom.b.a(sgSimpleIntPointArray[i2])) continue;
                    n7 = i2 + 1;
                    ++n6;
                    if (n2 == 0) continue;
                }
                long[] lArray = com.esri.sde.sdk.geom.b.z(sgShape);
                long[] lArray2 = com.esri.sde.sdk.geom.b.y(sgShape);
                ArrayList arrayList = Sgs.simplePointsToPlane(sgShape.getCoordRef(), n5, false, sgSimpleIntPointArray, lArray, lArray2);
                sgSimpleShapePointArray = (SgSimpleShapePoint[])arrayList.get(0);
                dArray = (double[])arrayList.get(1);
                dArray2 = (double[])arrayList.get(2);
                switch (n4) {
                    case 0: {
                        seGeometryArray[0] = null;
                        if (n2 == 0) break;
                    }
                    case 4: {
                        seGeometryArray[0] = new SePoint(sgSimpleShapePointArray[0].getX(), sgSimpleShapePointArray[0].getY());
                        if (n2 == 0) break;
                    }
                    case 5: {
                        seGeometryArray[0] = new SePoint(sgSimpleShapePointArray[0].getX(), sgSimpleShapePointArray[0].getY(), dArray2[0]);
                        if (n2 == 0) break;
                    }
                    case 6: {
                        seGeometryArray[0] = new SePoint(sgSimpleShapePointArray[0].getX(), sgSimpleShapePointArray[0].getY(), dArray[0], Double.NaN);
                        if (n2 == 0) break;
                    }
                    case 7: {
                        seGeometryArray[0] = new SePoint(sgSimpleShapePointArray[0].getX(), sgSimpleShapePointArray[0].getY(), dArray[0], dArray2[0]);
                        if (n2 == 0) break;
                    }
                    case 8: {
                        seGeometryArray[0] = new SeMultiPoint(sgSimpleShapePointArray);
                        if (n2 == 0) break;
                    }
                    case 9: {
                        seGeometryArray[0] = new SeMultiPoint(sgSimpleShapePointArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 10: {
                        seGeometryArray[0] = new SeMultiPoint(sgSimpleShapePointArray, dArray, null);
                        if (n2 == 0) break;
                    }
                    case 11: {
                        seGeometryArray[0] = new SeMultiPoint(sgSimpleShapePointArray, dArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 12: {
                        seGeometryArray[0] = new SeLinestring(sgSimpleShapePointArray);
                        if (n2 == 0) break;
                    }
                    case 13: {
                        seGeometryArray[0] = new SeLinestring(sgSimpleShapePointArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 14: {
                        seGeometryArray[0] = new SeLinestring(sgSimpleShapePointArray, dArray, null);
                        if (n2 == 0) break;
                    }
                    case 15: {
                        seGeometryArray[0] = new SeLinestring(sgSimpleShapePointArray, dArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 16: {
                        object = new SePolygon(sgSimpleShapePointArray);
                        seGeometryArray[0] = object;
                        if (n2 == 0) break;
                    }
                    case 17: {
                        seGeometryArray[0] = new SePolygon(sgSimpleShapePointArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 18: {
                        seGeometryArray[0] = new SePolygon(sgSimpleShapePointArray, dArray, null);
                        if (n2 == 0) break;
                    }
                    case 19: {
                        seGeometryArray[0] = new SePolygon(sgSimpleShapePointArray, dArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 20: {
                        seGeometryArray[0] = new SeMultiLinestring(nArray2, sgSimpleShapePointArray);
                        if (n2 == 0) break;
                    }
                    case 21: {
                        seGeometryArray[0] = new SeMultiLinestring(nArray2, sgSimpleShapePointArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 22: {
                        seGeometryArray[0] = new SeMultiLinestring(nArray2, sgSimpleShapePointArray, dArray, null);
                        if (n2 == 0) break;
                    }
                    case 23: {
                        seGeometryArray[0] = new SeMultiLinestring(nArray2, sgSimpleShapePointArray, dArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 24: {
                        seGeometryArray[0] = new SeMultiPolygon(nArray2, sgSimpleShapePointArray);
                        if (n2 == 0) break;
                    }
                    case 25: {
                        seGeometryArray[0] = new SeMultiPolygon(nArray2, sgSimpleShapePointArray, dArray2);
                        if (n2 == 0) break;
                    }
                    case 26: {
                        seGeometryArray[0] = new SeMultiPolygon(nArray2, sgSimpleShapePointArray, dArray, null);
                        if (n2 == 0) break;
                    }
                    case 27: {
                        seGeometryArray[0] = new SeMultiPolygon(nArray2, sgSimpleShapePointArray, dArray, dArray2);
                        if (n2 == 0) break;
                    }
                    default: {
                        seGeometryArray[0] = null;
                    }
                }
                if (seGeometryArray[0] != null) {
                    seGeometryArray[0].k = n3;
                    seGeometryArray[0].j = sgShape.getNumPoints(0, 0);
                    object = sgShape.getExtent(0);
                    double[] dArray3 = sgShape.getZRange(0);
                    seGeometryArray[0].p = dArray3[0];
                    seGeometryArray[0].q = dArray3[1];
                    double[] dArray4 = sgShape.getMRange(0);
                    seGeometryArray[0].r = dArray4[0];
                    seGeometryArray[0].s = dArray4[1];
                    seGeometryArray[0].l = ((SgShapeEnvelope)object).getMinX();
                    seGeometryArray[0].m = ((SgShapeEnvelope)object).getMinY();
                    seGeometryArray[0].n = ((SgShapeEnvelope)object).getMaxX();
                    seGeometryArray[0].o = ((SgShapeEnvelope)object).getMaxY();
                }
            }
            try {
                if (seGeometryArray[0] != null) {
                    seGeometryArray[0].c(sgShape);
                }
            }
            catch (IOException iOException) {
                String string = "\nERROR: SeGeometry.sdeShapeGetParams(), " + iOException.getMessage();
                System.out.println(string);
                throw new SeGeometryException(string);
            }
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.sdeShapeGetParams(), " + sgException.getMessage());
            throw new SeGeometryException(sgException.getCode());
        }
        return seGeometryArray[0];
    }

    private void c(SgShape sgShape) throws IOException {
        int n2 = GeometryException.a;
        long l2 = 0L;
        long l3 = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n3 = com.esri.sde.sdk.geom.b.B(sgShape);
            int n4 = com.esri.sde.sdk.geom.b.A(sgShape);
            SgSimpleIntPoint[] sgSimpleIntPointArray = com.esri.sde.sdk.geom.b.C(sgShape);
            long[] lArray = com.esri.sde.sdk.geom.b.z(sgShape);
            long[] lArray2 = com.esri.sde.sdk.geom.b.y(sgShape);
            if (sgSimpleIntPointArray != null) {
                int n5;
                int n6;
                if (lArray != null) {
                    l2 |= 1L;
                }
                if (lArray2 != null) {
                    l2 |= 2L;
                }
                for (n6 = n4 - 1; n6 > 0; --n6) {
                    sgSimpleIntPointArray[n6].setX(sgSimpleIntPointArray[n6].getX() - sgSimpleIntPointArray[n6 - 1].getX());
                    sgSimpleIntPointArray[n6].setY(sgSimpleIntPointArray[n6].getY() - sgSimpleIntPointArray[n6 - 1].getY());
                    if (n2 == 0) continue;
                }
                com.esri.sde.sdk.geom.b.b(sgShape, sgSimpleIntPointArray);
                if (lArray != null) {
                    for (n6 = n4 - 1; n6 > 0; --n6) {
                        lArray[n6] = lArray[n6] - lArray[n6 - 1];
                        if (n2 == 0) continue;
                    }
                    com.esri.sde.sdk.geom.b.c(sgShape, lArray);
                }
                if (lArray2 != null) {
                    for (n6 = n4 - 1; n6 > 0; --n6) {
                        lArray2[n6] = lArray2[n6] - lArray2[n6 - 1];
                        if (n2 == 0) continue;
                    }
                    com.esri.sde.sdk.geom.b.d(sgShape, lArray2);
                }
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeInt(n3);
                n6 = n4;
                dataOutputStream.writeInt(n6);
                dataOutputStream.writeLong(l2);
                dataOutputStream.writeLong(l3);
                for (n5 = 0; n5 < n4; ++n5) {
                    dataOutputStream.writeLong(sgSimpleIntPointArray[n5].getX());
                    dataOutputStream.writeLong(sgSimpleIntPointArray[n5].getY());
                    if (n2 == 0) continue;
                }
                if (lArray != null) {
                    for (n5 = 0; n5 < n4; ++n5) {
                        dataOutputStream.writeLong(lArray[n5]);
                        if (n2 == 0) continue;
                    }
                }
                if (lArray2 != null) {
                    for (n5 = 0; n5 < n4; ++n5) {
                        dataOutputStream.writeLong(lArray2[n5]);
                        if (n2 == 0) continue;
                    }
                }
                this.t = byteArrayOutputStream.toByteArray();
            }
        }
        catch (SgException sgException) {
            System.out.println("\nERROR: SeGeometry.featureCompress(), " + sgException.getMessage());
            throw new IOException();
        }
    }

    private static int a(int n2, boolean bl2, boolean bl3) throws SgException {
        int n3 = GeometryException.a;
        int n4 = 0;
        switch (n2) {
            case 0: 
            case 1: {
                if (!bl2 && !bl3) {
                    n4 = 4;
                    if (n3 == 0) break;
                }
                if (bl2) {
                    if (bl3) {
                        n4 = 7;
                        if (n3 == 0) break;
                    }
                    n4 = 6;
                    if (n3 == 0) break;
                }
                n4 = 5;
                if (n3 == 0) break;
            }
            case 257: {
                if (!bl2 && !bl3) {
                    n4 = 8;
                    if (n3 == 0) break;
                }
                if (bl2) {
                    if (bl3) {
                        n4 = 11;
                        if (n3 == 0) break;
                    }
                    n4 = 10;
                    if (n3 == 0) break;
                }
                n4 = 9;
                if (n3 == 0) break;
            }
            case 258: 
            case 260: {
                if (!bl2 && !bl3) {
                    n4 = 20;
                    if (n3 == 0) break;
                }
                if (bl2) {
                    if (bl3) {
                        n4 = 23;
                        if (n3 == 0) break;
                    }
                    n4 = 22;
                    if (n3 == 0) break;
                }
                n4 = 21;
                if (n3 == 0) break;
            }
            case 2: 
            case 4: {
                if (!bl2 && !bl3) {
                    n4 = 12;
                    if (n3 == 0) break;
                }
                if (bl2) {
                    if (bl3) {
                        n4 = 15;
                        if (n3 == 0) break;
                    }
                    n4 = 14;
                    if (n3 == 0) break;
                }
                n4 = 13;
                if (n3 == 0) break;
            }
            case 8: {
                if (!bl2 && !bl3) {
                    n4 = 16;
                    if (n3 == 0) break;
                }
                if (bl2) {
                    if (bl3) {
                        n4 = 19;
                        if (n3 == 0) break;
                    }
                    n4 = 18;
                    if (n3 == 0) break;
                }
                n4 = 17;
                if (n3 == 0) break;
            }
            case 264: {
                if (!bl2 && !bl3) {
                    n4 = 24;
                    if (n3 == 0) break;
                }
                if (bl2) {
                    if (bl3) {
                        n4 = 27;
                        if (n3 == 0) break;
                    }
                    n4 = 26;
                    if (n3 == 0) break;
                }
                n4 = 25;
                if (n3 == 0) break;
            }
            default: {
                n4 = 0;
            }
        }
        return n4;
    }
}

