/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.geom;

import com.esri.sde.sdk.geom.GeometryException;
import java.io.ByteArrayOutputStream;

public interface Geometry {
    public Geometry interior() throws GeometryException;

    public Geometry exterior() throws GeometryException;

    public Geometry boundary() throws GeometryException;

    public Geometry buffer(double var1) throws GeometryException;

    public boolean isSimple() throws GeometryException;

    public boolean isValid() throws GeometryException;

    public boolean isEmpty() throws GeometryException;

    public int numPoints() throws GeometryException;

    public Geometry envelope() throws GeometryException;

    public int dimension() throws GeometryException;

    public boolean is3D() throws GeometryException;

    public boolean isMeasured() throws GeometryException;

    public int srid() throws GeometryException;

    public String geometryType() throws GeometryException;

    public ByteArrayOutputStream asBinary() throws GeometryException;

    public String asText() throws GeometryException;

    public Geometry convexhull() throws GeometryException;

    public Geometry locateAlong(double var1) throws GeometryException;

    public Geometry locateBetween(double var1, double var3) throws GeometryException;

    public boolean envelopesIntersect(Geometry var1) throws GeometryException;

    public boolean equal(Geometry var1) throws GeometryException;

    public boolean disjoint(Geometry var1) throws GeometryException;

    public boolean intersect(Geometry var1) throws GeometryException;

    public boolean touch(Geometry var1) throws GeometryException;

    public boolean overlap(Geometry var1) throws GeometryException;

    public boolean crosses(Geometry var1) throws GeometryException;

    public boolean within(Geometry var1) throws GeometryException;

    public boolean contains(Geometry var1) throws GeometryException;

    public double distance(Geometry var1) throws GeometryException;

    public Geometry[] intersection(Geometry var1) throws GeometryException;

    public Geometry difference(Geometry var1) throws GeometryException;

    public Geometry union(Geometry var1) throws GeometryException;

    public Geometry symmetricDiff(Geometry var1) throws GeometryException;
}

