/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.client;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeTransformCustom;
import com.esri.sde.sdk.client.SeTransformPolynomial;
import com.esri.sde.sdk.client.SeTransformProjected;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeGeogTransformations;
import com.esri.sde.sdk.pe.PeProjectionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class SeTransform
implements Cloneable {
    protected int a;
    protected String b;
    public static final int SE_TRANSFORM_UNKNOWN = 0;
    public static final int SE_TRANSFORM_PLANER = 1;
    public static final int SE_TRANSFORM_PROJECTIVE = 2;
    public static final int SE_TRANSFORM_POLYNOMIAL = 3;
    public static final int SE_TRANSFORM_CUSTOM = 4;
    public static final int SE_POLYNOMIAL_1ST_ORDER = 0;
    public static final int SE_POLYNOMIAL_2ND_ORDER = 1;
    public static final int SE_POLYNOMIAL_3RD_ORDER = 2;

    protected SeTransform(int n2, String string) throws SeException {
        this.a = n2;
        this.setName(string);
    }

    public Object clone() throws CloneNotSupportedException {
        SeTransform seTransform = null;
        switch (this.a) {
            case 4: {
                seTransform = (SeTransformCustom)((SeTransformCustom)this).clone();
                break;
            }
            case 1: {
                if (SeException.b == 0) break;
            }
            case 3: {
                seTransform = (SeTransformPolynomial)((SeTransformPolynomial)this).clone();
                break;
            }
            case 2: {
                seTransform = (SeTransformProjected)((SeTransformProjected)this).clone();
            }
        }
        return seTransform;
    }

    public String getName() {
        return new String(this.b);
    }

    public int getType() throws SeException {
        return this.a;
    }

    public void setName(String string) throws SeException {
        block5: {
            block4: {
                if (string != null && string.length() > 256) {
                    throw new SeException(-66, "SE_INVALID_PARAM_VALUE");
                }
                if (string != null) break block4;
                this.b = new String("");
                if (SeException.b == 0) break block5;
            }
            this.b = new String(string);
        }
    }

    static byte[] a(SeTransform[] seTransformArray) throws Exception {
        Object object;
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        int n2 = SeException.b;
        int n3 = seTransformArray.length >> 1;
        int n4 = 0;
        if (seTransformArray.length <= 1 || seTransformArray.length != n3 << 1) {
            throw new IllegalArgumentException("invalid transform list");
        }
        int n5 = 12 + seTransformArray.length;
        block9: for (int i2 = 0; i2 < seTransformArray.length; ++i2) {
            if (seTransformArray[i2] == null) continue;
            n5 += 432;
            switch (seTransformArray[i2].getType()) {
                case 2: {
                    n5 += 1024;
                    if (!((SeTransformProjected)seTransformArray[i2]).a()) continue block9;
                    n5 += 1024;
                    if (n2 == 0) continue block9;
                }
                case 4: {
                    n5 += ((SeTransformCustom)seTransformArray[i2]).a();
                }
            }
            if (n2 == 0) continue;
        }
        StringBuffer stringBuffer = null;
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(n5);
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
        dataOutputStream2.writeInt(0);
        dataOutputStream2.writeInt(0);
        dataOutputStream2.writeInt(n3);
        block10: for (int i3 = 0; i3 < seTransformArray.length; ++i3) {
            if (seTransformArray[i3] == null) {
                dataOutputStream2.writeByte(0);
                if (n2 == 0) continue;
            }
            dataOutputStream2.writeByte(1);
            stringBuffer = new StringBuffer("XfM");
            stringBuffer.setLength(4);
            dataOutputStream2.writeBytes(stringBuffer.toString());
            n4 = seTransformArray[i3].getType();
            dataOutputStream2.writeInt(n4);
            stringBuffer = new StringBuffer(seTransformArray[i3].getName());
            stringBuffer.setLength(256);
            dataOutputStream2.writeBytes(stringBuffer.toString());
            switch (n4) {
                case 2: {
                    SeTransformProjected seTransformProjected = (SeTransformProjected)seTransformArray[i3];
                    byteArrayOutputStream = seTransformProjected.getCoordSys();
                    stringBuffer = new StringBuffer(byteArrayOutputStream.toString());
                    stringBuffer.setLength(1024);
                    dataOutputStream2.writeBytes(stringBuffer.toString());
                    dataOutputStream = seTransformProjected.getGeogTran();
                    if (dataOutputStream != null) {
                        dataOutputStream2.writeByte(1);
                        stringBuffer = new StringBuffer(dataOutputStream.toString());
                        stringBuffer.setLength(1024);
                        dataOutputStream2.writeBytes(stringBuffer.toString());
                        if (n2 == 0) continue block10;
                    }
                    dataOutputStream2.writeByte(0);
                    if (n2 == 0) continue block10;
                }
                case 3: {
                    object = (SeTransformPolynomial)seTransformArray[i3];
                    dataOutputStream2.writeInt(((SeTransformPolynomial)object).getPolynomialType());
                    double[] dArray = ((SeTransformPolynomial)object).getPolynomial();
                    for (int i4 = 0; i4 < dArray.length; ++i4) {
                        dataOutputStream2.writeDouble(dArray[i4]);
                        if (n2 == 0) continue;
                    }
                    continue block10;
                }
                {
                    case 4: {
                        SeTransformCustom seTransformCustom = (SeTransformCustom)seTransformArray[i3];
                        dataOutputStream2.writeInt(seTransformCustom.getCustomType());
                        byte[] byArray = seTransformCustom.getCustomData();
                        dataOutputStream2.writeInt(byArray.length);
                        dataOutputStream2.write(byArray, 0, byArray.length);
                        continue block10;
                        break;
                    }
                }
            }
            if (n2 == 0) continue;
        }
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        int n6 = byteArrayOutputStream2.size();
        dataOutputStream2.close();
        byteArrayOutputStream2.close();
        byteArrayOutputStream = new ByteArrayOutputStream(4);
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n6);
        object = byteArrayOutputStream.toByteArray();
        dataOutputStream.close();
        byteArrayOutputStream.close();
        System.arraycopy(object, 0, byArray, 0, 4);
        return byArray;
    }

    static SeTransform[] a(byte[] byArray) throws SeException {
        int n2 = SeException.b;
        SeTransform[] seTransformArray = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n3 = dataInputStream.readInt();
            if (n3 > byArray.length) {
                throw new IllegalArgumentException("SeTransform.deserilize: invalid buff length");
            }
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[1024];
            seTransformArray = new SeTransform[n5 * 2];
            block8: for (int i2 = 0; i2 < seTransformArray.length; ++i2) {
                if (dataInputStream.readByte() == 0) {
                    seTransformArray[i2] = null;
                    if (n2 == 0) continue;
                }
                int n6 = dataInputStream.read(byArray2, 0, 4);
                int n7 = dataInputStream.readInt();
                n6 = dataInputStream.read(byArray2, 0, 256);
                String string = new String(byArray2);
                string = string.trim();
                switch (n7) {
                    case 2: {
                        n6 = dataInputStream.read(byArray3, 0, 1024);
                        String string2 = new String(byArray3);
                        string2 = string2.trim();
                        PeCoordinateSystem peCoordinateSystem = PeCoordinateSystem.fromString((String)string2);
                        PeGeogTransformations peGeogTransformations = null;
                        if (dataInputStream.readByte() == 1) {
                            n6 = dataInputStream.read(byArray3, 0, 1024);
                            String string3 = new String(byArray3);
                            string3 = string3.trim();
                            peGeogTransformations = PeGeogTransformations.fromString((String)string3);
                        }
                        seTransformArray[i2] = new SeTransformProjected(peCoordinateSystem, peGeogTransformations, string);
                        if (n2 == 0) continue block8;
                    }
                    case 3: {
                        int n8;
                        int n9 = dataInputStream.readInt();
                        double[] dArray = SeTransformPolynomial.a(n9);
                        for (n8 = 0; n8 < dArray.length; ++n8) {
                            dArray[n8] = dataInputStream.readDouble();
                            if (n2 == 0) continue;
                        }
                        seTransformArray[i2] = new SeTransformPolynomial(n9, dArray, string);
                        if (n2 == 0) continue block8;
                    }
                    case 4: {
                        int n8 = dataInputStream.readInt();
                        int n10 = dataInputStream.readInt();
                        byte[] byArray4 = new byte[n10];
                        dataInputStream.read(byArray4, 0, n10);
                        seTransformArray[i2] = new SeTransformCustom(n8, byArray4, string);
                        continue block8;
                    }
                }
                if (n2 == 0) continue;
            }
            dataInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            throw new SeException(-59, iOException.getMessage());
        }
        catch (PeProjectionException peProjectionException) {
            throw new SeException(-145, peProjectionException.getMessage());
        }
        return seTransformArray;
    }
}

