/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.client;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExceptionFactory;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.f;
import com.esri.sde.sdk.client.n;
import com.esri.sde.sdk.client.q;
import com.esri.sde.sdk.client.t;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeGeographicCS;
import com.esri.sde.sdk.pe.PeProjectedCS;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.esri.sde.sdk.sg.SgCoordRef;
import com.esri.sde.sdk.sg.SgException;
import java.io.IOException;

public class SeCoordinateReference
extends f
implements Cloneable {
    private PeCoordinateSystem b;
    private SgCoordRef c;

    public SeCoordinateReference() {
        try {
            this.c = SgCoordRef.create();
        }
        catch (SgException sgException) {
            this.c = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SeCoordinateReference seCoordinateReference = new SeCoordinateReference();
        try {
            seCoordinateReference.c = this.c.duplicate();
            if (this.b != null) {
                seCoordinateReference.b = (PeCoordinateSystem)this.b.clone();
            }
        }
        catch (SgException sgException) {
            throw new CloneNotSupportedException();
        }
        return seCoordinateReference;
    }

    public String getProjectionDescription() {
        String string = null;
        try {
            string = this.c.getDescription();
        }
        catch (SgException sgException) {
            // empty catch block
        }
        return string;
    }

    public double getFalseM() {
        return this.c.getFalseM();
    }

    public double getMUnits() {
        return this.c.getMUnits();
    }

    public double getMinMValue() {
        return this.c.getFalseM();
    }

    public double getMaxMValue() {
        return this.a(this.getMinMValue(), this.getMUnits());
    }

    public SeObjectId getSrid() {
        int n2 = 0;
        try {
            n2 = this.c.getSrId();
        }
        catch (SgException sgException) {
            // empty catch block
        }
        return new SeObjectId(n2);
    }

    public double getFalseX() {
        return this.c.getFalseX();
    }

    public double getFalseY() {
        return this.c.getFalseY();
    }

    public double getXYUnits() {
        return this.c.getXYUnits();
    }

    public double getFalseZ() {
        return this.c.getFalseZ();
    }

    public double getZUnits() {
        return this.c.getZUnits();
    }

    public double getMinZValue() {
        return this.c.getFalseZ();
    }

    public double getMaxZValue() {
        return this.a(this.getMinZValue(), this.getZUnits());
    }

    private double a(double d2, double d3) {
        return d2 + 2.147483645E9 / d3;
    }

    private double a(double d2) {
        return 2.147483645E9 / d2;
    }

    private double b(double d2, double d3) {
        return d2 - 1.0 / d3;
    }

    public boolean isEqual(SeCoordinateReference seCoordinateReference) throws SeException {
        boolean bl2 = false;
        try {
            bl2 = this.c.isEqual(seCoordinateReference.c());
        }
        catch (SgException sgException) {
            // empty catch block
        }
        return bl2;
    }

    public void setCoordSysByDescription(String string) {
        int n2 = SeException.b;
        try {
            block9: {
                block10: {
                    block8: {
                        if (!string.startsWith("PROJCS[")) break block8;
                        this.b = new PeProjectedCS(string);
                        if (n2 == 0) break block9;
                    }
                    if (!string.startsWith("GEOGCS[")) break block10;
                    this.b = new PeGeographicCS(string);
                    if (n2 == 0) break block9;
                }
                this.b = null;
            }
            if (this.b != null && this.c != null) {
                this.c.setByDescription(string);
            }
        }
        catch (PeProjectionException peProjectionException) {
            this.b = null;
        }
        catch (SgException sgException) {
            this.b = null;
        }
    }

    public String getCoordSysDescription() {
        if (this.b != null) {
            return this.b.toString();
        }
        return "UNKNOWN";
    }

    public void setCoordSysByID(SeObjectId seObjectId) throws SeException {
        try {
            this.c.setById(seObjectId.a());
        }
        catch (SgException sgException) {
            SeShape.f(sgException.getCode());
        }
    }

    public void setM(double d2, double d3) {
        try {
            this.c.setM(d2, d3);
        }
        catch (SgException sgException) {
            // empty catch block
        }
    }

    public void setMByRange(double d2, double d3) {
        double d4 = this.a(d3 - d2);
        double d5 = this.b(d2, d4);
        this.setM(d5, d4);
    }

    public void setPrecision(int n2) throws SeException {
        try {
            this.c.setPrecision(n2);
        }
        catch (SgException sgException) {
            SeShape.f(sgException.getCode());
        }
    }

    public void setXY(double d2, double d3, double d4) {
        try {
            this.c.setXY(d2, d3, d4);
        }
        catch (SgException sgException) {
            // empty catch block
        }
    }

    public SeExtent getXYEnvelope() throws SeException {
        double d2 = this.getXYUnits();
        double d3 = this.getFalseX();
        double d4 = this.a(d3, d2);
        double d5 = this.getFalseY();
        double d6 = this.a(d5, d2);
        return new SeExtent(d3, d5, d4, d6);
    }

    public void setXYByEnvelope(SeExtent seExtent) throws SeException {
        if (seExtent.getMinX() >= seExtent.getMaxX() || seExtent.getMinY() >= seExtent.getMaxY()) {
            SeExceptionFactory.throwException(null, -58, "");
        }
        double d2 = Math.min(seExtent.getMaxX() - seExtent.getMinX(), seExtent.getMaxY() - seExtent.getMinY());
        double d3 = this.a(d2);
        double d4 = this.b(seExtent.getMinX(), d3);
        double d5 = this.b(seExtent.getMinY(), d3);
        this.setXY(d4, d5, d3);
    }

    public void setZ(double d2, double d3) {
        try {
            this.c.setZ(d2, d3);
        }
        catch (SgException sgException) {
            // empty catch block
        }
    }

    public void setZByRange(double d2, double d3) {
        double d4 = this.a(d3 - d2);
        double d5 = this.b(d2, d4);
        this.setM(d5, d4);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        try {
            stringBuffer.append("(SeCoordRef : ").append("srid=").append(this.c.getSrId()).append(",falsex=").append(this.c.getFalseX()).append(",falsey=").append(this.c.getFalseY()).append(",xyunits=").append(this.c.getXYUnits()).append(",falsez=").append(this.c.getFalseZ()).append(",zunits=").append(this.c.getZUnits()).append(",falsem=").append(this.c.getFalseM()).append(",munits=").append(this.c.getMUnits()).append(",projstr=").append(this.c.getDescription()).append(")");
            System.out.println("\n" + stringBuffer);
        }
        catch (SgException sgException) {
            stringBuffer = null;
        }
        return new String(stringBuffer);
    }

    void a() throws SeException {
        block6: {
            int n2 = SeException.b;
            try {
                String string = this.c.getDescription();
                if (string.startsWith("PROJCS[")) {
                    this.b = new PeProjectedCS(string);
                    if (n2 == 0) break block6;
                }
                if (string.startsWith("GEOGCS[")) {
                    this.b = new PeGeographicCS(string);
                    if (n2 == 0) break block6;
                }
                this.b = null;
            }
            catch (PeProjectionException peProjectionException) {
                this.b = null;
            }
            catch (SgException sgException) {
                SeShape.f(sgException.getCode());
            }
        }
    }

    void b() throws SeException {
        block4: {
            try {
                if (this.b != null) {
                    String string = this.b.toString();
                    this.c.setByDescription(string);
                    if (SeException.b == 0) break block4;
                }
                this.c.setByDescription("UNKNOWN");
            }
            catch (SgException sgException) {
                SeShape.f(sgException.getCode());
            }
        }
    }

    void read(n n2, int n3) throws IOException {
        block6: {
            try {
                this.c.setFalseX(n2.d());
                this.c.setFalseY(n2.d());
                this.c.setFalseZ(n2.d());
                this.c.setFalseM(n2.d());
                this.c.setXYUnits(n2.d());
                this.c.setZUnits(n2.d());
                this.c.setMUnits(n2.d());
                this.c.setXYCRound(n2.d());
                this.c.setZCRound(n2.d());
                this.c.setMCRound(n2.d());
                this.c.setXYHalfSU(n2.d());
                this.c.setZHalfSU(n2.d());
                this.c.setMHalfSU(n2.d());
                int n4 = n2.b();
                if (n4 > 0) {
                    this.c.setByDescription(n2.f());
                }
                this.setCoordSysByDescription(this.c.getDescription());
                if (n3 > 3020) {
                    this.c.setSrId(n2.b());
                }
                if (this.a >= 89001) {
                    this.c.setPrecision(n2.b());
                    if (SeException.b == 0) break block6;
                }
                t.c(this.c, 0);
                t.d(this.c, 0);
            }
            catch (SgException sgException) {
                throw new IOException();
            }
        }
    }

    void write(q q2, int n2) throws IOException {
        try {
            q2.a(this.c.getFalseX());
            q2.a(this.c.getFalseY());
            q2.a(this.c.getFalseZ());
            q2.a(this.c.getFalseM());
            q2.a(this.c.getXYUnits());
            q2.a(this.c.getZUnits());
            q2.a(this.c.getMUnits());
            q2.a(this.c.getXYCRound());
            q2.a(this.c.getZCRound());
            q2.a(this.c.getMCRound());
            q2.a(this.c.getXYHalfSU());
            q2.a(this.c.getZHalfSU());
            q2.a(this.c.getMHalfSU());
            String string = this.c.getDescription();
            int n3 = string.length();
            q2.b(n3);
            if (n3 > 0) {
                q2.b(string);
            }
            if (n2 > 3020) {
                q2.b(this.c.getSrId());
            }
            if (this.a >= 89001) {
                q2.b(this.c.getPrecision());
            }
        }
        catch (SgException sgException) {
            throw new IOException();
        }
    }

    void a(int n2) {
        this.a = n2;
    }

    SgCoordRef c() {
        return this.c;
    }

    void a(SgCoordRef sgCoordRef) {
        this.c = sgCoordRef;
    }
}

