/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffleop;

import it.geosolutions.jaiext.jiffle.runtime.BandTransform;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import it.geosolutions.jaiext.jiffleop.JiffleOpImage;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public class JiffleRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        String script = (String)paramBlock.getObjectParameter(2);
        String destVarName = (String)paramBlock.getObjectParameter(1);
        Rectangle destBounds = (Rectangle)paramBlock.getObjectParameter(3);
        int dataType = paramBlock.getIntParameter(4);
        ImageLayout layout = (ImageLayout)renderHints.get(JAI.KEY_IMAGE_LAYOUT);
        if (destBounds != null) {
            layout = this.buildLayout(destBounds, this.getPreferredTileSize(paramBlock), dataType);
        } else if (layout == null) {
            destBounds = this.getSourceBounds(paramBlock);
            layout = this.buildLayout(destBounds, this.getPreferredTileSize(paramBlock), dataType);
        }
        Map<String, JiffleOpImage.ImageSpecification> sourceImages = this.buildSourceImageMap(paramBlock);
        return new JiffleOpImage(sourceImages, layout, renderHints, script, destVarName);
    }

    private Dimension getPreferredTileSize(ParameterBlock pb) {
        if (pb.getSources() == null || pb.getSources().size() == 0) {
            return JAI.getDefaultTileSize();
        }
        RenderedImage ref = (RenderedImage)pb.getSource(0);
        return new Dimension(ref.getWidth(), ref.getHeight());
    }

    private Map<String, JiffleOpImage.ImageSpecification> buildSourceImageMap(ParameterBlock pb) {
        HashMap<String, JiffleOpImage.ImageSpecification> result = new HashMap<String, JiffleOpImage.ImageSpecification>();
        Vector<Object> sources = pb.getSources();
        String[] names = (String[])pb.getObjectParameter(0);
        CoordinateTransform[] cts = (CoordinateTransform[])pb.getObjectParameter(5);
        BandTransform[] bts = (BandTransform[])pb.getObjectParameter(6);
        if (sources == null || sources.size() == 0) {
            return result;
        }
        if (names == null) {
            for (int i = 0; i < sources.size(); ++i) {
                if (i == 0) {
                    result.put("src", this.getImageSpecification(sources, cts, bts, i));
                    continue;
                }
                result.put("src" + i, this.getImageSpecification(sources, cts, bts, i));
            }
        } else {
            if (names.length != sources.size()) {
                throw new IllegalArgumentException("Have " + sources.size() + " sources, but the source name argument contains " + names.length + " entries instead");
            }
            for (int i = 0; i < sources.size(); ++i) {
                result.put(names[i], this.getImageSpecification(sources, cts, bts, i));
            }
        }
        return result;
    }

    private JiffleOpImage.ImageSpecification getImageSpecification(Vector<Object> sources, CoordinateTransform[] cts, BandTransform[] bts, int i) {
        RenderedImage image = (RenderedImage)sources.get(i);
        CoordinateTransform ct = null;
        if (cts != null) {
            if (cts.length != sources.size()) {
                throw new IllegalArgumentException(String.format("Have %d sources, but the coordinate transformation argument contains %d entries instead" + sources.size() + cts.length, new Object[0]));
            }
            ct = cts[i];
        }
        BandTransform bt = null;
        if (bts != null) {
            if (bts.length != sources.size()) {
                throw new IllegalArgumentException(String.format("Have %d sources, but the band transformation argument contains %d entries instead" + sources.size() + bts.length, new Object[0]));
            }
            bt = bts[i];
        }
        return new JiffleOpImage.ImageSpecification(image, ct, bt);
    }

    private ImageLayout buildLayout(Rectangle bounds, Dimension tileSize, int dataType) {
        if (bounds == null) {
            throw new IllegalStateException("Cannot determine output image layout, dest bounds have not been provided");
        }
        ImageLayout layout = new ImageLayout(bounds.x, bounds.y, bounds.width, bounds.height);
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)dataType, (int)tileSize.width, (int)tileSize.height, (int)1);
        layout.setSampleModel(sm);
        layout.setColorModel(PlanarImage.createColorModel((SampleModel)sm));
        return layout;
    }

    private Rectangle getSourceBounds(ParameterBlock pb) {
        Rectangle boundsUnion = null;
        if (pb.getNumSources() > 0) {
            boundsUnion = this.getSourceBounds(pb, 0);
            for (int i = 1; i < pb.getNumSources(); ++i) {
                Rectangle imageBounds = this.getSourceBounds(pb, i);
                boundsUnion = boundsUnion.union(imageBounds);
            }
        }
        return boundsUnion;
    }

    private Rectangle getSourceBounds(ParameterBlock pb, int imageIdx) {
        RenderedImage source = (RenderedImage)pb.getSource(imageIdx);
        return new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
    }
}

