/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffleop;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.runtime.BandTransform;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.JiffleIndirectRuntime;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public class JiffleOpImage
extends OpImage {
    private final JiffleIndirectRuntime runtime;
    private final int band = 0;

    public JiffleOpImage(Map<String, ImageSpecification> sourceImages, ImageLayout layout, Map configuration, String script, String destVarName) {
        super(JiffleOpImage.specsToImages(sourceImages), layout, configuration, false);
        try {
            Jiffle jiffle = new Jiffle();
            jiffle.setScript(script);
            HashMap<String, Jiffle.ImageRole> imageParams = new HashMap<String, Jiffle.ImageRole>();
            for (String string : sourceImages.keySet()) {
                imageParams.put(string, Jiffle.ImageRole.SOURCE);
            }
            imageParams.put(destVarName, Jiffle.ImageRole.DEST);
            jiffle.setImageParams(imageParams);
            jiffle.compile();
            this.runtime = (JiffleIndirectRuntime)jiffle.getRuntimeInstance(Jiffle.RuntimeModel.INDIRECT);
            for (Map.Entry entry : sourceImages.entrySet()) {
                String name = (String)entry.getKey();
                ImageSpecification spec = (ImageSpecification)entry.getValue();
                this.runtime.setSourceImage(name, spec.image, spec.coordinateTransform);
                if (spec.bandTransform == null) continue;
                this.runtime.setSourceImageBandTransform(name, spec.bandTransform);
            }
            Rectangle bounds = new Rectangle(layout.getMinX(null), layout.getMinY(null), layout.getWidth(null), layout.getHeight(null));
            this.runtime.setWorldByResolution((Rectangle2D)bounds, 1.0, 1.0);
        }
        catch (JiffleException ex) {
            throw new RuntimeException(ex);
        }
        this.setProperty("GC_NODATA", new NoDataContainer(Double.NaN));
    }

    private static Vector specsToImages(Map<String, ImageSpecification> sourceImages) {
        return new Vector(sourceImages.values().stream().map(is -> is.image).collect(Collectors.toList()));
    }

    public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
        return null;
    }

    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        return this.getSourceImage(sourceIndex).getBounds();
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        int y = destRect.y;
        for (int iy = 0; iy < destRect.height; ++iy) {
            int x = destRect.x;
            for (int ix = 0; ix < destRect.width; ++ix) {
                double value = this.runtime.evaluate((double)x, (double)y);
                dest.setSample(x, y, 0, value);
                ++x;
            }
            ++y;
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        super.computeRect(sources, dest, destRect);
    }

    public Raster computeTile(int tileX, int tileY) {
        return super.computeTile(tileX, tileY);
    }

    static class ImageSpecification {
        RenderedImage image;
        CoordinateTransform coordinateTransform;
        BandTransform bandTransform;

        public ImageSpecification(RenderedImage image, CoordinateTransform coordinateTransform, BandTransform bandTransform) {
            this.image = image;
            this.coordinateTransform = coordinateTransform;
            this.bandTransform = bandTransform;
        }
    }
}

