/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.parser.JiffleParserException;
import it.geosolutions.jaiext.jiffle.parser.OptionLookup;
import it.geosolutions.jaiext.jiffle.parser.UndefinedOptionException;
import it.geosolutions.jaiext.jiffle.parser.node.GlobalVars;
import it.geosolutions.jaiext.jiffle.parser.node.Node;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import it.geosolutions.jaiext.jiffle.parser.node.StatementList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Script
implements Node {
    private final StatementList stmts;
    private Map<String, String> options;
    private Set<String> sourceImages;
    private Set<String> destImages;
    private final GlobalVars globals;

    public Script(Map<String, String> options, Set<String> sourceImages, Set<String> destImages, GlobalVars globals, StatementList stmts) {
        this.options = options;
        this.sourceImages = sourceImages;
        this.destImages = destImages;
        this.globals = globals;
        this.stmts = stmts;
    }

    @Override
    public void write(SourceWriter w) {
        String packageName = "it.geosolutions.jaiext.jiffle.runtime";
        w.line("package " + packageName + ";");
        w.newLine();
        w.line("import java.util.List;");
        w.line("import java.util.ArrayList;");
        w.line("import java.util.Arrays;");
        w.newLine();
        String script = w.getScript();
        if (script != null) {
            String[] lines = script.split("\n");
            w.line("/**");
            w.line(" * Java runtime class generated from the following Jiffle script: ");
            w.line(" *<code>");
            for (String line : lines) {
                w.append(" * ").append(line).newLine();
            }
            w.line(" *</code>");
            w.line(" */");
        }
        String template = "public class %s extends %s {";
        Jiffle.RuntimeModel model = w.getRuntimeModel();
        String className = model == Jiffle.RuntimeModel.DIRECT ? "JiffleDirectRuntimeImpl" : "JiffleIndirectRuntimeImpl";
        w.line(String.format(template, className, w.getBaseClassName()));
        w.inc();
        if (w.isInternalBaseClass()) {
            for (String sourceImage : this.sourceImages) {
                w.indent().append("SourceImage s_").append(sourceImage).append(";").newLine();
            }
            if (model == Jiffle.RuntimeModel.DIRECT) {
                for (String destImage : this.destImages) {
                    w.indent().append("DestinationImage d_").append(destImage).append(";").newLine();
                }
            }
        }
        this.globals.writeFields(w);
        w.newLine();
        w.indent().append("public ").append(className).append("() {").newLine();
        w.inc();
        w.indent().append("super(new String[] {");
        this.globals.listNames(w);
        w.append("});").newLine();
        w.dec();
        w.line("}");
        w.newLine();
        if (this.options != null && !this.options.isEmpty()) {
            w.line("protected void initOptionVars() {");
            w.inc();
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                try {
                    String activeExpr = OptionLookup.getActiveRuntimExpr(name, value);
                    w.line(activeExpr);
                }
                catch (UndefinedOptionException e) {
                    throw new JiffleParserException(e);
                }
            }
            w.dec();
            w.line("}");
        }
        w.line("protected void initImageScopeVars() {");
        w.inc();
        if (w.isInternalBaseClass()) {
            for (String sourceImage : this.sourceImages) {
                w.indent().append("s_").append(sourceImage).append(" = (SourceImage) _images.get(\"").append(sourceImage).append("\");").newLine();
            }
            if (model == Jiffle.RuntimeModel.DIRECT) {
                for (String destImage : this.destImages) {
                    w.indent().append("d_").append(destImage).append("= (DestinationImage) _destImages.get(\"").append(destImage).append("\");").newLine();
                }
            }
        }
        this.globals.write(w);
        w.line("_imageScopeVarsInitialized = true;");
        w.dec();
        w.line("}");
        w.newLine();
        if (model == Jiffle.RuntimeModel.DIRECT) {
            w.line("public void evaluate(double _x, double _y) {");
        } else {
            w.line("public double evaluate(double _x, double _y) {");
        }
        w.inc();
        w.line("if (!isWorldSet()) {");
        w.inc();
        w.line("setDefaultBounds();");
        w.dec();
        w.line("}");
        w.line("if (!_imageScopeVarsInitialized) {");
        w.inc();
        w.line("initImageScopeVars();");
        w.dec();
        w.line("}");
        w.line("_stk.clear();");
        if (model == Jiffle.RuntimeModel.INDIRECT) {
            w.line("double result = Double.NaN;");
        }
        w.newLine();
        this.stmts.write(w);
        if (model == Jiffle.RuntimeModel.INDIRECT) {
            w.line("return result;");
        }
        w.dec();
        w.line("}");
        w.dec();
        w.line("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Script script = (Script)o;
        return Objects.equals(this.stmts, script.stmts) && Objects.equals(this.options, script.options) && Objects.equals(this.sourceImages, script.sourceImages) && Objects.equals(this.destImages, script.destImages) && Objects.equals(this.globals, script.globals);
    }

    public int hashCode() {
        return Objects.hash(this.stmts, this.options, this.sourceImages, this.destImages, this.globals);
    }

    public StatementList getStmts() {
        return this.stmts;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public Set<String> getSourceImages() {
        return Collections.unmodifiableSet(this.sourceImages);
    }

    public Set<String> getDestImages() {
        return Collections.unmodifiableSet(this.destImages);
    }

    public GlobalVars getGlobals() {
        return this.globals;
    }
}

