/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;

public final class RasterShortSingleBandProvider
extends AbstractScanlineProvider {
    final short[] shorts;

    public RasterShortSingleBandProvider(Raster raster) {
        super(raster, 16, raster.getWidth() * 2);
        this.shorts = ((DataBufferUShort)raster.getDataBuffer()).getData();
    }

    public RasterShortSingleBandProvider(Raster raster, int bidDepth, int scanlineLength, IndexColorModel palette) {
        super(raster, bidDepth, scanlineLength, palette);
        this.shorts = ((DataBufferUShort)raster.getDataBuffer()).getData();
    }

    @Override
    public void next(byte[] scanline, int offset, int length) {
        int shortsIdx = this.cursor.next();
        int i = offset;
        int max = offset + length;
        while (i < max) {
            short gray = this.shorts[shortsIdx++];
            scanline[i++] = (byte)(gray >> 8 & 0xFF);
            if (i >= max) continue;
            scanline[i++] = (byte)(gray & 0xFF);
        }
    }
}

