/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.xmlview.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import uk.ac.rdg.resc.godiva.client.handlers.ElevationSelectionHandler;
import uk.ac.rdg.resc.godiva.client.handlers.LayerSelectionHandler;
import uk.ac.rdg.resc.godiva.client.handlers.TimeDateSelectionHandler;
import uk.ac.rdg.resc.godiva.client.requests.ConnectionException;
import uk.ac.rdg.resc.godiva.client.requests.ErrorHandler;
import uk.ac.rdg.resc.godiva.client.requests.LayerDetails;
import uk.ac.rdg.resc.godiva.client.requests.LayerRequestBuilder;
import uk.ac.rdg.resc.godiva.client.requests.LayerRequestCallback;
import uk.ac.rdg.resc.godiva.client.requests.LayerTreeJSONParser;
import uk.ac.rdg.resc.godiva.client.requests.TimeRequestBuilder;
import uk.ac.rdg.resc.godiva.client.requests.TimeRequestCallback;
import uk.ac.rdg.resc.godiva.client.state.ElevationSelectorIF;
import uk.ac.rdg.resc.godiva.client.state.LayerSelectorIF;
import uk.ac.rdg.resc.godiva.client.state.TimeSelectorIF;
import uk.ac.rdg.resc.godiva.client.widgets.ElevationSelector;
import uk.ac.rdg.resc.godiva.client.widgets.LayerSelectorCombo;
import uk.ac.rdg.resc.godiva.client.widgets.TimeSelector;
import uk.ac.rdg.resc.godiva.shared.LayerMenuItem;

public class XMLView
implements EntryPoint,
LayerSelectionHandler,
ErrorHandler,
TimeDateSelectionHandler,
ElevationSelectionHandler {
    private Image image;
    private Label sizeLabel;
    private TextBox width;
    private Label xLabel;
    private TextBox height;
    private TextArea xmlEntry;
    private Label idList;
    private PushButton button;
    private LayerSelectorIF layerSelector;
    private TimeSelectorIF timeSelector;
    private ElevationSelectorIF elevationSelector;
    private String bbox = null;

    public void onModuleLoad() {
        VerticalPanel mainPanel = new VerticalPanel();
        VerticalPanel widgetPanel = new VerticalPanel();
        HorizontalPanel xmlMapPanel = new HorizontalPanel();
        this.xmlEntry = new TextArea();
        this.xmlEntry.setName("XML_STYLE");
        this.xmlEntry.setSize("600px", "400px");
        this.image = new Image();
        xmlMapPanel.add((Widget)this.xmlEntry);
        xmlMapPanel.add((Widget)this.image);
        this.button = new PushButton("Process XML");
        this.button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                System.out.println(XMLView.this.getUrl());
                XMLView.this.image.setUrl(XMLView.this.getUrl());
            }
        });
        this.layerSelector = new LayerSelectorCombo((LayerSelectionHandler)this);
        this.timeSelector = new TimeSelector("timeselector", (TimeDateSelectionHandler)this);
        this.elevationSelector = new ElevationSelector("elevationselector", "Depth", (ElevationSelectionHandler)this);
        this.idList = new Label("ID: ");
        this.idList.setStylePrimaryName("labelStyle");
        widgetPanel.add((IsWidget)this.layerSelector);
        widgetPanel.add((IsWidget)this.timeSelector);
        widgetPanel.add((IsWidget)this.elevationSelector);
        widgetPanel.add((Widget)this.idList);
        HorizontalPanel sizePanel = new HorizontalPanel();
        this.sizeLabel = new Label("Size: ");
        this.width = new TextBox();
        this.width.setText("800");
        this.xLabel = new Label(" x ");
        this.height = new TextBox();
        this.height.setText("400");
        sizePanel.add((Widget)this.sizeLabel);
        sizePanel.add((Widget)this.width);
        sizePanel.add((Widget)this.xLabel);
        sizePanel.add((Widget)this.height);
        widgetPanel.add((Widget)sizePanel);
        HorizontalPanel topPanel = new HorizontalPanel();
        topPanel.add((Widget)widgetPanel);
        topPanel.add((Widget)new HTML("First select one of the layers you wish to plot.<br/>This will give the available times and depths, and will set the bounding box to the full extents.<br/>It will also show the layer ID for use in the XML<br/>Select the desired time/depth values (or leave the defaults).<br/>Change the image size if you want<br/>Then enter some valid XML in the box and click \"Process XML\"<br/>If your XML was valid, you'll get an image<br/>This is a minimal client for developer testing<br/>"));
        mainPanel.add((Widget)topPanel);
        mainPanel.add((Widget)xmlMapPanel);
        mainPanel.add((Widget)this.button);
        RootLayoutPanel rootLayoutPanel = RootLayoutPanel.get();
        rootLayoutPanel.add((Widget)mainPanel);
        this.requestAndPopulateMenu();
    }

    private String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append(URL.encode((String)"wms?REQUEST=GetMap&VERSION=1.3.0&CRS=CRS:84&XML_STYLE=") + URL.encodeQueryString((String)this.xmlEntry.getValue()) + "&BBOX=" + URL.encodeQueryString((String)this.bbox) + "&FORMAT=" + URL.encodeQueryString((String)"image/png") + "&WIDTH=" + URL.encodeQueryString((String)this.width.getText()) + "&HEIGHT=" + URL.encodeQueryString((String)this.height.getText()));
        if (this.timeSelector.getSelectedDateTime() != null) {
            url.append("&TIME=" + this.timeSelector.getSelectedDateTime());
        }
        if (this.timeSelector.getSelectedDateTimeRange() != null) {
            url.append("&COLORBY/TIME=" + this.timeSelector.getSelectedDateTimeRange());
        }
        if (this.elevationSelector.getSelectedElevation() != null) {
            url.append("&ELEVATION=" + this.elevationSelector.getSelectedElevation());
        }
        if (this.elevationSelector.getSelectedElevationRange() != null) {
            url.append("&COLORBY/DEPTH=" + this.elevationSelector.getSelectedElevationRange());
        }
        return url.toString();
    }

    private void requestAndPopulateMenu() {
        String wmsUrl = "wms";
        RequestBuilder getMenuRequest = new RequestBuilder(RequestBuilder.GET, URL.encode((String)"wms?request=GetMetadata&item=menu"));
        getMenuRequest.setCallback(new RequestCallback(){

            public void onResponseReceived(Request req, Response response) {
                try {
                    if (response.getStatusCode() != 200) {
                        throw new ConnectionException("Error contacting server");
                    }
                    JSONValue jsonMap = JSONParser.parseLenient((String)response.getText());
                    JSONObject parentObj = jsonMap.isObject();
                    LayerMenuItem menuTree = LayerTreeJSONParser.getTreeFromJson((String)"wms", (JSONObject)parentObj);
                    XMLView.this.menuLoaded(menuTree);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onError(Request request, Throwable e) {
                e.printStackTrace();
            }
        });
        try {
            getMenuRequest.send();
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
    }

    protected void menuLoaded(LayerMenuItem menuTree) {
        if (menuTree.isLeaf()) {
            menuTree.addChildItem(new LayerMenuItem("No georeferencing data found!", null, null, false, null));
        }
        this.layerSelector.populateLayers(menuTree);
    }

    public void layerSelected(String wmsUrl, String layerId, boolean autoZoomAndPalette) {
        this.requestLayerDetails(wmsUrl, layerId, autoZoomAndPalette);
        this.idList.setText("ID: " + layerId);
    }

    public void layerDeselected(String layerId) {
    }

    public void refreshLayerList() {
        this.requestAndPopulateMenu();
    }

    protected void requestLayerDetails(String wmsUrl, String layerId, final boolean autoZoomAndPalette) {
        if (layerId == null) {
            return;
        }
        LayerRequestBuilder getLayerDetailsRequest = new LayerRequestBuilder(layerId, wmsUrl, null);
        getLayerDetailsRequest.setCallback(new LayerRequestCallback(layerId, this){

            public void onResponseReceived(Request req, Response response) {
                try {
                    super.onResponseReceived(req, response);
                    if (response.getStatusCode() != 200) {
                        throw new ConnectionException("Error contacting server");
                    }
                    XMLView.this.layerDetailsLoaded(this.getLayerDetails(), autoZoomAndPalette);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onError(Request request, Throwable e) {
                XMLView.this.handleError(e);
            }
        });
        try {
            getLayerDetailsRequest.send();
        }
        catch (RequestException e) {
            this.handleError(e);
        }
    }

    protected void layerDetailsLoaded(LayerDetails layerDetails, boolean autoZoomAndPalette) {
        this.bbox = layerDetails.getExtents();
        this.elevationSelector.setId(layerDetails.getId());
        this.timeSelector.setId(layerDetails.getId());
        this.elevationSelector.setUnitsAndDirection(layerDetails.getZUnits(), layerDetails.isZPositive());
        this.timeSelector.setContinuous(layerDetails.isMultiFeature());
        this.elevationSelector.setContinuous(layerDetails.isMultiFeature());
        if (layerDetails.isMultiFeature()) {
            if (layerDetails.getStartTime().equals(layerDetails.getEndTime())) {
                this.timeSelector.populateDates(null);
            } else {
                ArrayList<String> startEndDates = new ArrayList<String>();
                startEndDates.add(layerDetails.getStartTime());
                startEndDates.add(layerDetails.getEndTime());
                this.timeSelector.populateDates(startEndDates);
            }
            if (layerDetails.getStartZ().equals(layerDetails.getEndZ())) {
                this.elevationSelector.populateElevations(null);
            } else {
                ArrayList<String> startEndZs = new ArrayList<String>();
                startEndZs.add(layerDetails.getStartZ());
                startEndZs.add(layerDetails.getEndZ());
                this.elevationSelector.populateElevations(startEndZs);
            }
            if (layerDetails.getNearestDateTime() != null) {
                this.timeSelector.selectDateTime(layerDetails.getNearestDateTime());
            }
        } else {
            this.timeSelector.populateDates(layerDetails.getAvailableDates());
            this.elevationSelector.populateElevations(layerDetails.getAvailableZs());
            if (layerDetails.getNearestDateTime() != null) {
                this.timeSelector.selectDate(layerDetails.getNearestDate());
            }
        }
    }

    public void handleError(Throwable e) {
        e.printStackTrace();
    }

    public void dateSelected(final String layerId, String selectedDate) {
        if (selectedDate == null) {
            return;
        }
        TimeRequestBuilder getTimeRequest = new TimeRequestBuilder(layerId, selectedDate, this.layerSelector.getWmsUrl());
        getTimeRequest.setCallback(new TimeRequestCallback(){

            public void onResponseReceived(Request request, Response response) {
                try {
                    super.onResponseReceived(request, response);
                    if (response.getStatusCode() != 200) {
                        throw new ConnectionException("Error contacting server");
                    }
                    XMLView.this.timeSelector.populateTimes(this.getAvailableTimesteps());
                    XMLView.this.datetimeSelected(layerId, XMLView.this.timeSelector.getSelectedDateTime());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onError(Request request, Throwable exception) {
                XMLView.this.handleError(exception);
            }
        });
        try {
            getTimeRequest.send();
        }
        catch (RequestException e) {
            this.handleError(e);
        }
    }

    public void datetimeSelected(String layerId, String selectedDatetime) {
    }

    public void elevationSelected(String layerId, String elevation) {
    }
}

