/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.util;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotoolkit.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.coverage.grid.RegularGrid;
import uk.ac.rdg.resc.edal.coverage.grid.impl.RegularGridImpl;
import uk.ac.rdg.resc.edal.coverage.metadata.RangeMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.ScalarMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.StatisticsCollection;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.GridFeature;
import uk.ac.rdg.resc.edal.feature.GridSeriesFeature;
import uk.ac.rdg.resc.edal.feature.PointSeriesFeature;
import uk.ac.rdg.resc.edal.feature.ProfileFeature;
import uk.ac.rdg.resc.edal.feature.TrajectoryFeature;
import uk.ac.rdg.resc.edal.geometry.BoundingBox;
import uk.ac.rdg.resc.edal.geometry.impl.BoundingBoxImpl;
import uk.ac.rdg.resc.edal.graphics.PlotStyle;
import uk.ac.rdg.resc.edal.position.CalendarSystem;
import uk.ac.rdg.resc.edal.position.HorizontalPosition;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.position.VerticalPosition;
import uk.ac.rdg.resc.edal.position.impl.GeoPositionImpl;
import uk.ac.rdg.resc.edal.util.Extents;
import uk.ac.rdg.resc.edal.util.GISUtils;
import uk.ac.rdg.resc.edal.util.TimeUtils;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.config.FeaturePlottingMetadata;
import uk.ac.rdg.resc.ncwms.controller.GetMapDataRequest;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidCrsException;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidDimensionValueException;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.wms.Dataset;

public class WmsUtils {
    public static final Set<String> SUPPORTED_VERSIONS = new HashSet<String>();

    private WmsUtils() {
        throw new AssertionError();
    }

    public static void createDirectory(File dir) throws Exception {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return;
            }
            throw new Exception(dir.getPath() + " already exists but it is a regular file");
        }
        boolean created = dir.mkdirs();
        if (!created) {
            throw new Exception("Could not create directory " + dir.getPath());
        }
    }

    public static double[] parseBbox(String bboxStr, boolean lonFirst) throws WmsException {
        String[] bboxEls = bboxStr.split(",");
        if (bboxEls.length != 4) {
            throw new WmsException("Invalid bounding box format: need four elements");
        }
        double[] bbox = new double[4];
        try {
            if (lonFirst) {
                bbox[0] = Double.parseDouble(bboxEls[0]);
                bbox[1] = Double.parseDouble(bboxEls[1]);
                bbox[2] = Double.parseDouble(bboxEls[2]);
                bbox[3] = Double.parseDouble(bboxEls[3]);
            } else {
                bbox[0] = Double.parseDouble(bboxEls[1]);
                bbox[1] = Double.parseDouble(bboxEls[0]);
                bbox[2] = Double.parseDouble(bboxEls[3]);
                bbox[3] = Double.parseDouble(bboxEls[2]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new WmsException("Invalid bounding box format: all elements must be numeric");
        }
        if (bbox[0] >= bbox[2] || bbox[1] >= bbox[3]) {
            throw new WmsException("Invalid bounding box format");
        }
        return bbox;
    }

    public static boolean isOpendapLocation(String location) {
        return location.startsWith("http://") || location.startsWith("dods://") || location.startsWith("https://");
    }

    public static boolean isNcmlAggregation(String location) {
        return location.endsWith(".xml") || location.endsWith(".ncml");
    }

    public static CoordinateReferenceSystem getCrs(String crsCode) throws InvalidCrsException {
        if (crsCode == null) {
            throw new NullPointerException("CRS code cannot be null");
        }
        try {
            return CRS.decode((String)crsCode, (boolean)true);
        }
        catch (Exception e) {
            throw new InvalidCrsException(crsCode);
        }
    }

    public static RegularGrid getImageGrid(GetMapDataRequest dr) throws InvalidCrsException {
        CoordinateReferenceSystem crs = WmsUtils.getCrs(dr.getCrsCode());
        BoundingBoxImpl bbox = new BoundingBoxImpl(dr.getBbox(), crs);
        return new RegularGridImpl((BoundingBox)bbox, dr.getWidth(), dr.getHeight());
    }

    public static Dataset getDataset(Config serverConfig, String layerName) {
        int slashIndex = layerName.indexOf("/");
        String datasetId = layerName.substring(0, slashIndex);
        return serverConfig.getDatasetById(datasetId);
    }

    public static FeaturePlottingMetadata getMetadata(Config serverConfig, String layerName) throws WmsException {
        String[] layerParts = layerName.split("/");
        if (layerParts.length != 2) {
            throw new WmsException("Layers should be of the form Dataset/Variable");
        }
        String datasetId = layerParts[0];
        String memberId = layerParts[1];
        uk.ac.rdg.resc.ncwms.config.Dataset dataset = serverConfig.getDatasetById(datasetId);
        FeaturePlottingMetadata metadata = dataset.getPlottingMetadataMap().get(memberId);
        if (metadata == null) {
            metadata = new FeaturePlottingMetadata();
        }
        return metadata;
    }

    public static String getWmsLayerName(GetMapDataRequest getMapDataRequest) throws WmsException {
        String[] layers = getMapDataRequest.getLayers();
        if (layers.length == 0) {
            throw new WmsException("Must provide a value for the LAYERS parameter");
        }
        if (layers.length > 1) {
            throw new WmsException("You may only create a map from 1 layer(s) at a time");
        }
        return layers[0];
    }

    public static String getDatasetId(String layerName) throws WmsException {
        String[] layerParts = layerName.split("/");
        if (layerParts.length != 2) {
            throw new WmsException("Layers should be of the form Dataset/Variable");
        }
        return layerParts[0];
    }

    public static String getMemberName(String layerName) throws WmsException {
        String[] layerParts = layerName.split("/");
        if (layerParts.length != 2) {
            throw new WmsException("Layers should be of the form Dataset/Variable");
        }
        return layerParts[1];
    }

    public static List<StyleInfo> getStylesWithPalettes(Feature feature, String memberName, Set<String> palettes) {
        Set<PlotStyle> baseStyles = WmsUtils.getBaseStyles(feature, memberName);
        ArrayList<StyleInfo> ret = new ArrayList<StyleInfo>();
        for (PlotStyle style : baseStyles) {
            boolean usesPalette = false;
            if (style == PlotStyle.DEFAULT) {
                ScalarMetadata scalarMetadata = MetadataUtils.getScalarMetadata((Feature)feature, (String)memberName);
                if (scalarMetadata != null) {
                    usesPalette = PlotStyle.getDefaultPlotStyle((Feature)feature, (ScalarMetadata)scalarMetadata).usesPalette();
                }
            } else {
                usesPalette = style.usesPalette();
            }
            if (usesPalette) {
                for (String palette : palettes) {
                    ret.add(new StyleInfo(style.name(), palette));
                }
                continue;
            }
            ret.add(new StyleInfo(style.name(), ""));
        }
        return ret;
    }

    public static Set<PlotStyle> getBaseStyles(Feature feature, String memberName) {
        LinkedHashSet<PlotStyle> styles = new LinkedHashSet<PlotStyle>();
        styles.add(PlotStyle.DEFAULT);
        RangeMetadata metadata = MetadataUtils.getMetadataForFeatureMember((Feature)feature, (String)memberName);
        if (metadata instanceof ScalarMetadata) {
            ScalarMetadata scalarMetadata = (ScalarMetadata)metadata;
            for (PlotStyle style : PlotStyle.getAllowedPlotStyles((Feature)feature, (ScalarMetadata)scalarMetadata)) {
                styles.add(style);
            }
        }
        if (metadata instanceof StatisticsCollection) {
            styles.add(PlotStyle.DEFAULT_CONFIDENCE);
            styles.add(PlotStyle.DEFAULT_CONTOUR);
            styles.add(PlotStyle.DEFAULT_CONTOUR_SMOOTH);
            styles.add(PlotStyle.DEFAULT_STIPPLE);
            styles.add(PlotStyle.DEFAULT_FADE_BLACK);
            styles.add(PlotStyle.DEFAULT_FADE_WHITE);
        }
        return styles;
    }

    public static String getExceptionName(Exception e) {
        return e.getClass().getName();
    }

    public static boolean memberIsScalar(RangeMetadata metadata, String memberName) {
        return metadata.getMemberMetadata(memberName) instanceof ScalarMetadata;
    }

    public static RangeMetadata getChildMetadata(RangeMetadata metadata, String memberName) {
        return metadata.getMemberMetadata(memberName);
    }

    public static Object getFeatureValue(Feature feature, HorizontalPosition pos, VerticalPosition zPos, TimePosition time, String memberName) {
        if (feature instanceof GridSeriesFeature) {
            return ((GridSeriesFeature)feature).getCoverage().evaluate((Object)new GeoPositionImpl(pos, zPos, time), memberName);
        }
        if (feature instanceof PointSeriesFeature) {
            return ((PointSeriesFeature)feature).getCoverage().evaluate((Object)time, memberName);
        }
        if (feature instanceof ProfileFeature) {
            return ((ProfileFeature)feature).getCoverage().evaluate((Object)zPos, memberName);
        }
        if (feature instanceof GridFeature) {
            return ((GridFeature)feature).getCoverage().evaluate((Object)pos, memberName);
        }
        if (feature instanceof TrajectoryFeature) {
            return ((TrajectoryFeature)feature).getCoverage().evaluate((Object)new GeoPositionImpl(pos, zPos, time), memberName);
        }
        return null;
    }

    public static BoundingBox getWmsBoundingBox(Feature feature) {
        BoundingBox inBbox;
        if (feature instanceof GridSeriesFeature) {
            inBbox = ((GridSeriesFeature)feature).getCoverage().getDomain().getHorizontalGrid().getCoordinateExtent();
        } else if (feature instanceof GridFeature) {
            inBbox = ((GridFeature)feature).getCoverage().getDomain().getCoordinateExtent();
        } else {
            if (feature instanceof PointSeriesFeature) {
                HorizontalPosition pos = ((PointSeriesFeature)feature).getHorizontalPosition();
                return WmsUtils.getBoundingBoxForSinglePosition(pos);
            }
            if (feature instanceof ProfileFeature) {
                HorizontalPosition pos = ((ProfileFeature)feature).getHorizontalPosition();
                return WmsUtils.getBoundingBoxForSinglePosition(pos);
            }
            if (feature instanceof TrajectoryFeature) {
                TrajectoryFeature trajectoryFeature = (TrajectoryFeature)feature;
                trajectoryFeature.getCoverage().getDomain().getDomainObjects();
                return ((TrajectoryFeature)feature).getCoverage().getDomain().getCoordinateBounds();
            }
            throw new IllegalArgumentException("Unknown feature type");
        }
        double minLon = inBbox.getMinX() % 360.0;
        double maxLon = inBbox.getMaxX() % 360.0;
        double minLat = inBbox.getMinY();
        double maxLat = inBbox.getMaxY();
        if (minLon < 180.0 && maxLon > 180.0 || minLon < -180.0 && maxLon > -180.0 || minLon >= maxLon) {
            minLon = -180.0;
            maxLon = 180.0;
        }
        if (minLat >= maxLat) {
            minLat = -90.0;
            maxLat = 90.0;
        }
        minLon = Double.isNaN(minLon) ? -180.0 : minLon;
        minLat = Double.isNaN(minLat) ? -90.0 : minLat;
        maxLon = Double.isNaN(maxLon) ? 180.0 : maxLon;
        maxLat = Double.isNaN(maxLat) ? 90.0 : maxLat;
        double[] bbox = new double[]{minLon, minLat, maxLon, maxLat};
        return new BoundingBoxImpl(bbox, inBbox.getCoordinateReferenceSystem());
    }

    private static BoundingBox getBoundingBoxForSinglePosition(HorizontalPosition pos) {
        return new BoundingBoxImpl(new double[]{pos.getX() - 1.0, pos.getY() - 1.0, pos.getX() + 1.0, pos.getY() + 1.0}, pos.getCoordinateReferenceSystem());
    }

    public static Extent<Double> getElevationRangeForString(String elevationString) {
        double secondVal;
        if (elevationString == null || elevationString.equals("")) {
            return null;
        }
        String[] parts = elevationString.split("/");
        if (parts.length < 1 || parts.length > 2) {
            throw new IllegalArgumentException("Cannot determine depths from string: " + elevationString);
        }
        if (parts.length == 1) {
            return Extents.newExtent((Object)Double.parseDouble(parts[0]), (Object)Double.parseDouble(parts[0]));
        }
        double firstVal = Double.parseDouble(parts[0]);
        if (firstVal < (secondVal = Double.parseDouble(parts[1]))) {
            return Extents.newExtent((Object)Double.parseDouble(parts[0]), (Object)Double.parseDouble(parts[1]));
        }
        return Extents.newExtent((Object)Double.parseDouble(parts[1]), (Object)Double.parseDouble(parts[0]));
    }

    public static List<TimePosition> getTimePositionsForString(String timeString, Feature feature) throws InvalidDimensionValueException {
        ArrayList<TimePosition> tValues = new ArrayList<TimePosition>();
        if (feature == null) {
            return tValues;
        }
        List tAxis = GISUtils.getTimes((Feature)feature, (boolean)false);
        if (tAxis == null || tAxis.size() == 0) {
            return tValues;
        }
        if (timeString == null || timeString.equals("")) {
            return tAxis.subList(0, 1);
        }
        for (String t : timeString.split(",")) {
            String[] startStop = t.split("/");
            if (startStop.length == 1) {
                TimePosition time = WmsUtils.findTValue(startStop[0], tAxis);
                tValues.add(time);
                continue;
            }
            if (startStop.length == 2) {
                tValues.addAll(WmsUtils.findTValues(startStop[0], startStop[1], tAxis));
                continue;
            }
            throw new InvalidDimensionValueException("time", t);
        }
        return tValues;
    }

    private static TimePosition findTValue(String isoDateTime, List<TimePosition> tValues) throws InvalidDimensionValueException {
        if (tValues == null) {
            return null;
        }
        int tIndex = WmsUtils.findTIndex(isoDateTime, tValues);
        if (tIndex < 0) {
            throw new InvalidDimensionValueException("time", isoDateTime);
        }
        return tValues.get(tIndex);
    }

    private static List<TimePosition> findTValues(String isoDateTimeStart, String isoDateTimeEnd, List<TimePosition> tValues) throws InvalidDimensionValueException {
        int endIndex;
        if (tValues == null) {
            throw new InvalidDimensionValueException("time", isoDateTimeStart + "/" + isoDateTimeEnd);
        }
        int startIndex = WmsUtils.findTIndex(isoDateTimeStart, tValues);
        if (startIndex > (endIndex = WmsUtils.findTIndex(isoDateTimeEnd, tValues))) {
            throw new InvalidDimensionValueException("time", isoDateTimeStart + "/" + isoDateTimeEnd);
        }
        ArrayList<TimePosition> returnTValues = new ArrayList<TimePosition>();
        for (int i = startIndex; i <= endIndex; ++i) {
            returnTValues.add(tValues.get(i));
        }
        return returnTValues;
    }

    public static int findTIndex(String isoDateTime, List<TimePosition> tValues) throws InvalidDimensionValueException {
        TimePosition target;
        if (isoDateTime.equalsIgnoreCase("current")) {
            target = GISUtils.getClosestToCurrentTime(tValues);
        } else {
            if (tValues == null || tValues.size() == 0) {
                return -1;
            }
            try {
                isoDateTime = isoDateTime.replaceAll(" ", "+");
                target = TimeUtils.iso8601ToDateTime((String)isoDateTime, (CalendarSystem)tValues.get(0).getCalendarSystem());
            }
            catch (ParseException e) {
                throw new InvalidDimensionValueException("time", isoDateTime);
            }
        }
        long targetMillis = target.getValue();
        for (int i = 0; i < tValues.size(); ++i) {
            if (targetMillis != tValues.get(i).getValue()) continue;
            return i;
        }
        return -1;
    }

    static {
        SUPPORTED_VERSIONS.add("1.1.1");
        SUPPORTED_VERSIONS.add("1.3.0");
    }

    public static class StyleInfo {
        private String stylename;
        private String palettename;

        public StyleInfo(String stylename, String palettename) {
            this.stylename = stylename;
            this.palettename = palettename;
        }

        public String getStylename() {
            return this.stylename;
        }

        public String getPalettename() {
            return this.palettename;
        }

        public String toString() {
            return this.stylename + "/" + this.palettename;
        }
    }
}

