/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.util;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.factory.epsg.EpsgInstaller;
import org.opengis.util.FactoryException;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import uk.ac.rdg.resc.ncwms.config.NcwmsContext;

public class EPSGDatabaseInitialiser {
    private DataSource dataSource;
    private Connection conn;
    private NcwmsContext ncwmsContext;

    public void init() {
        try {
            String databasePath = new File(this.ncwmsContext.getWorkingDirectory(), "epsgcodes.db").getCanonicalPath();
            Class.forName("org.h2.Driver");
            this.conn = DriverManager.getConnection("jdbc:h2:" + databasePath);
            this.conn.setAutoCommit(true);
            this.dataSource = new SingleConnectionDataSource(this.conn, true);
            Hints.putSystemDefault((RenderingHints.Key)Hints.EPSG_DATA_SOURCE, (Object)this.dataSource);
            EpsgInstaller i = new EpsgInstaller();
            i.setDatabase(this.conn);
            if (!i.exists()) {
                i.call();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setNcwmsContext(NcwmsContext ncwmsContext) {
        this.ncwmsContext = ncwmsContext;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

