/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

class WmsVersion
implements Comparable<WmsVersion> {
    private Integer value;
    private String str;
    private int hashCode;
    public static final WmsVersion VERSION_1_1_1 = new WmsVersion("1.1.1");
    public static final WmsVersion VERSION_1_3_0 = new WmsVersion("1.3.0");

    public WmsVersion(String versionStr) {
        int z;
        int y;
        int x;
        String[] els = versionStr.split("\\.");
        if (els.length != 3) {
            throw new IllegalArgumentException(versionStr + " is not a valid WMS version number");
        }
        try {
            x = Integer.parseInt(els[0]);
            y = Integer.parseInt(els[1]);
            z = Integer.parseInt(els[2]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(versionStr + " is not a valid WMS version number");
        }
        if (y > 99 || z > 99) {
            throw new IllegalArgumentException(versionStr + " is not a valid WMS version number");
        }
        this.str = x + "." + y + "." + z;
        this.value = 10000 * x + 100 * y + z;
        this.hashCode = 7 + 79 * this.value.hashCode();
    }

    @Override
    public int compareTo(WmsVersion otherVersion) {
        return this.value.compareTo(otherVersion.value);
    }

    public String toString() {
        return this.str;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof WmsVersion) {
            WmsVersion other = (WmsVersion)obj;
            return this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

