/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.FeatureCollection;
import uk.ac.rdg.resc.edal.feature.UniqueMembersFeatureCollection;
import uk.ac.rdg.resc.edal.graphics.formats.AviFormat;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.util.TimeUtils;
import uk.ac.rdg.resc.ncwms.controller.AbstractWmsController;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.MetadataException;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;

public class ScreenshotController
extends MultiActionController {
    private AbstractWmsController.FeatureFactory featureFactory;

    public void setFeatureFactory(AbstractWmsController.FeatureFactory featureFactory) {
        this.featureFactory = featureFactory;
    }

    public ModelAndView createScreenshot(HttpServletRequest request, HttpServletResponse response) throws MetadataException, WmsException, IOException {
        String fullRequest = request.getRequestURL().toString();
        String servletUrl = fullRequest.substring(0, fullRequest.indexOf(request.getServletPath()) + 1);
        RequestParams params = new RequestParams(request.getParameterMap());
        if (params.getString("image") != null && params.getString("image").equalsIgnoreCase("true")) {
            String time = params.getString("time");
            BufferedImage image = this.drawScreenshot(params, servletUrl, time);
            response.setContentType("image/png");
            ServletOutputStream output = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "png", (OutputStream)output);
            return null;
        }
        PrintWriter out = response.getWriter();
        String url = request.getRequestURL() + "?" + request.getQueryString() + "&image=true";
        out.println("<html><body>To save the image, right click and select \"Save As\"<br>Note: The image may take a long time to appear, depending on the speed of the data servers<br><img src=\"" + url + "\"</body></html>");
        return null;
    }

    public ModelAndView createAvi(HttpServletRequest request, HttpServletResponse response) throws MetadataException, WmsException, IOException {
        String fullRequest = request.getRequestURL().toString();
        String servletUrl = fullRequest.substring(0, fullRequest.indexOf(request.getServletPath()) + 1);
        RequestParams params = new RequestParams(request.getParameterMap());
        String layerName = params.getMandatoryString("layer");
        String memberName = WmsUtils.getMemberName(layerName);
        FeatureCollection<? extends Feature> featureCollection = this.featureFactory.getFeatureCollection(layerName);
        if (featureCollection instanceof UniqueMembersFeatureCollection) {
            Feature feature = ((UniqueMembersFeatureCollection)featureCollection).getFeatureContainingMember(memberName);
            String timeString = params.getString("time");
            ArrayList<String> tValueStrings = new ArrayList<String>();
            List<TimePosition> timeValues = WmsUtils.getTimePositionsForString(timeString, feature);
            for (TimePosition timeValue : timeValues) {
                String tValueStr = null;
                if (timeValue != null) {
                    tValueStr = TimeUtils.dateTimeToISO8601((TimePosition)timeValue);
                }
                tValueStrings.add(tValueStr);
            }
            ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
            for (String time : tValueStrings) {
                frames.add(this.drawScreenshot(params, servletUrl, time));
            }
            int frameRate = params.getPositiveInt("frameRate", 24);
            AviFormat aviFormat = new AviFormat();
            response.setContentType(aviFormat.getMimeType());
            response.setHeader("Content-Disposition", "attachment; filename=ncwms-export.avi");
            ServletOutputStream output = response.getOutputStream();
            aviFormat.writeImage(frames, (OutputStream)output, Integer.valueOf(frameRate));
            return null;
        }
        throw new WmsException("Cannot create an AVI from this type of dataset");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage drawScreenshot(RequestParams params, String servletUrl, String time) throws WmsException, IOException {
        String[] scaleVals;
        String el;
        String crs;
        Float lonRange;
        Float maxLat;
        Float minLat;
        Float maxLon;
        Float minLon;
        String baseLayerUrl;
        block33: {
            baseLayerUrl = params.getString("baseUrl");
            String baseLayerNames = params.getString("baseLayers");
            if (baseLayerNames != null) {
                baseLayerUrl = baseLayerUrl + "&LAYERS=" + baseLayerNames;
            }
            minLon = Float.valueOf(Float.parseFloat(params.getString("bbox").split(",")[0]));
            maxLon = Float.valueOf(Float.parseFloat(params.getString("bbox").split(",")[2]));
            minLat = Float.valueOf(Float.parseFloat(params.getString("bbox").split(",")[1]));
            maxLat = Float.valueOf(Float.parseFloat(params.getString("bbox").split(",")[3]));
            lonRange = Float.valueOf(maxLon.floatValue() - minLon.floatValue());
            crs = params.getString("crs");
            URL baseUrl = this.createWMSUrl(params, true, minLon, minLat, maxLon, maxLat, 100, 100, baseLayerUrl, time);
            try {
                ImageIO.read(baseUrl);
            }
            catch (Exception e) {
                if (crs.equalsIgnoreCase("EPSG:4326") || crs.equalsIgnoreCase("CRS:84")) {
                    baseLayerUrl = "http://www2.demis.nl/wms/wms.ashx?WMS=BlueMarble&LAYERS=Earth%20Image";
                }
                if (!crs.equalsIgnoreCase("EPSG:32661") && !crs.equalsIgnoreCase("EPSG:32761")) break block33;
                baseLayerUrl = "http://wms-basemaps.appspot.com/wms?LAYERS=bluemarble_file&FORMAT=image/jpeg";
            }
        }
        int mapHeight = params.getPositiveInt("mapHeight", 384);
        int mapWidth = params.getPositiveInt("mapWidth", 512);
        int textSpace = 25;
        if (params.getString("layerTitle") != null) {
            String[] titleElements = params.getString("layerTitle").split(",");
            textSpace += 15 * titleElements.length;
        }
        if (time != null) {
            textSpace += 20;
        }
        if (params.getString("elevation") != null) {
            textSpace += 20;
        }
        BufferedImage image = new BufferedImage(mapWidth + 180, mapHeight + textSpace, 1);
        Graphics2D g = image.createGraphics();
        g.setPaint(Color.white);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setBackground(Color.white);
        Font font = new Font("SansSerif", 1, 16);
        g.setPaint(Color.black);
        g.setFont(font);
        int vPos = 20;
        int hPos = 10;
        String title = params.getString("layerTitle");
        if (title != null) {
            int indent = 0;
            String[] titleElements = title.split(",");
            if (titleElements.length >= 2) {
                for (int i = titleElements.length - 1; i > 0; --i) {
                    g.drawString(titleElements[i], hPos + indent, vPos);
                    g.drawString("\u21b3", hPos + indent + 8, (vPos += 15) - 2);
                    indent += 20;
                    font = new Font("SansSerif", 1, 14);
                    g.setFont(font);
                }
            }
            if (titleElements.length > 0) {
                g.drawString(titleElements[0], hPos + indent, vPos);
                vPos += 15;
            }
        }
        vPos += 5;
        font = new Font("SansSerif", 1, 14);
        g.setFont(font);
        if (time != null) {
            g.drawString("Time: " + time, hPos, vPos);
            vPos += 20;
        }
        if ((el = params.getString("elevation")) != null) {
            String depth = el;
            String u = params.getString("zUnits");
            String units = "";
            if (u != null) {
                units = u;
            }
            if (depth.startsWith("-")) {
                g.drawString("Depth: " + el.substring(1) + units, hPos, vPos);
            } else {
                g.drawString("Elevation: " + el + units, hPos, vPos);
            }
            vPos += 30;
        }
        if (!crs.equalsIgnoreCase("EPSG:4326") && !crs.equalsIgnoreCase("CRS:84") || minLon.floatValue() >= -180.0f && maxLon.floatValue() <= 180.0f) {
            BufferedImage im = this.getImage(params, minLon, minLat, maxLon, maxLat, mapWidth, mapHeight, baseLayerUrl, time);
            g.drawImage((Image)im, 0, textSpace, null);
        } else if (minLon.floatValue() < -180.0f && maxLon.floatValue() <= 180.0f) {
            int lefWidth = (int)((float)mapWidth * (-180.0f - minLon.floatValue()) / lonRange.floatValue());
            BufferedImage im = this.getImage(params, Float.valueOf(minLon.floatValue() + 360.0f), minLat, Float.valueOf(180.0f), maxLat, lefWidth, mapHeight, baseLayerUrl, time);
            g.drawImage((Image)im, 0, textSpace, null);
            im = this.getImage(params, Float.valueOf(-180.0f), minLat, maxLon, maxLat, mapWidth - lefWidth, mapHeight, baseLayerUrl, time);
            g.drawImage((Image)im, lefWidth, textSpace, null);
        } else if (minLon.floatValue() >= -180.0f && maxLon.floatValue() > 180.0f) {
            int rightWidth = (int)((float)mapWidth * (maxLon.floatValue() - 180.0f) / lonRange.floatValue());
            BufferedImage im = this.getImage(params, minLon, minLat, Float.valueOf(180.0f), maxLat, mapWidth - rightWidth, mapHeight, baseLayerUrl, time);
            g.drawImage((Image)im, 0, textSpace, null);
            im = this.getImage(params, Float.valueOf(-180.0f), minLat, Float.valueOf(maxLon.floatValue() - 360.0f), maxLat, rightWidth, mapHeight, baseLayerUrl, time);
            g.drawImage((Image)im, mapWidth - rightWidth, textSpace, null);
        } else if (minLon.floatValue() < -180.0f && maxLon.floatValue() > 180.0f) {
            int leftWidth = (int)((float)mapWidth * (-180.0f - minLon.floatValue()) / lonRange.floatValue());
            BufferedImage im = this.getImage(params, Float.valueOf(minLon.floatValue() + 360.0f), minLat, Float.valueOf(180.0f), maxLat, leftWidth, mapHeight, baseLayerUrl, time);
            g.drawImage((Image)im, 0, textSpace, null);
            int rightWidth = (int)((float)mapWidth * (maxLon.floatValue() - 180.0f) / lonRange.floatValue());
            im = this.getImage(params, Float.valueOf(-180.0f), minLat, Float.valueOf(maxLon.floatValue() - 360.0f), maxLat, rightWidth, mapHeight, baseLayerUrl, time);
            g.drawImage((Image)im, mapWidth - rightWidth, textSpace, null);
            im = this.getImage(params, Float.valueOf(-180.0f), minLat, Float.valueOf(180.0f), maxLat, mapWidth - leftWidth - rightWidth, mapHeight, baseLayerUrl, time);
            g.drawImage((Image)im, leftWidth, textSpace, null);
        }
        URL url = this.createWMSUrl(params, false, minLon, minLat, maxLon, maxLat, mapWidth, mapHeight, servletUrl, time);
        if (url != null) {
            BufferedImage wmsLayer = ImageIO.read(url);
            g.drawImage((Image)wmsLayer, 0, textSpace, null);
        }
        if ((url = this.createColorbarUrl(params, mapHeight, servletUrl)) != null) {
            InputStream in = null;
            try {
                URLConnection conn = url.openConnection();
                in = conn.getInputStream();
                BufferedImage colorBar = ImageIO.read(in);
                g.drawImage(colorBar, mapWidth, textSpace, mapWidth + 30, textSpace + mapHeight, 0, 0, 1, colorBar.getHeight(), null);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        String sr = params.getString("scaleRange");
        int topPos = textSpace + 10;
        int botPos = topPos + mapHeight - 10;
        int midPos = botPos + (topPos - botPos) / 2;
        hPos = mapWidth + 40;
        String u = params.getString("units");
        if (u != null && !u.equals("")) {
            g.drawString("Units: " + u, hPos, midPos);
        }
        font = new Font("SansSerif", 0, 11);
        g.setFont(font);
        if (sr != null && (scaleVals = sr.split(",")).length == 2) {
            double lowMedVal;
            double highMedVal;
            float topVal = Float.parseFloat(scaleVals[1]);
            float botVal = Float.parseFloat(scaleVals[0]);
            String log = params.getString("logScale");
            if (log != null && Boolean.parseBoolean(log)) {
                double aThird = Math.log(topVal / botVal) / 3.0;
                highMedVal = Math.exp(Math.log(botVal) + 2.0 * aThird);
                lowMedVal = Math.exp(Math.log(botVal) + aThird);
            } else {
                highMedVal = botVal + 2.0f * (topVal - botVal) / 3.0f;
                lowMedVal = botVal + (topVal - botVal) / 3.0f;
            }
            int highMedPos = botPos + 2 * (topPos - botPos) / 3;
            int lowMedPos = botPos + (topPos - botPos) / 3;
            DecimalFormat format = new DecimalFormat("##0.00");
            g.drawString(format.format(topVal), hPos, topPos);
            g.drawString(format.format(highMedVal), hPos, highMedPos);
            g.drawString(format.format(lowMedVal), hPos, lowMedPos);
            g.drawString(format.format(botVal), hPos, botPos);
        }
        return image;
    }

    private BufferedImage getImage(RequestParams params, Float minLon, Float minLat, Float maxLon, Float maxLat, int width, int height, String bgUrl, String time) throws IOException {
        BufferedImage image = null;
        URL baseUrl = this.createWMSUrl(params, true, minLon, minLat, maxLon, maxLat, width, height, bgUrl, time);
        try {
            image = ImageIO.read(baseUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BufferedImage(width, height, 2);
        }
        return image;
    }

    private URL createWMSUrl(RequestParams params, boolean baseLayer, Float minLon, Float minLat, Float maxLon, Float maxLat, int width, int height, String baseWmsUrl, String time) {
        StringBuilder url = new StringBuilder();
        if (baseLayer) {
            Matcher m;
            Pattern p = Pattern.compile(" ");
            if (baseWmsUrl != null && (m = p.matcher(baseWmsUrl)) != null) {
                baseWmsUrl = m.replaceAll("%20");
            }
            url.append(baseWmsUrl);
            url.append("&STYLES=");
        } else {
            String colorbyTime;
            String colorbyDepth;
            String elevation;
            String numColorBands;
            String dataset = params.getString("dataset");
            if (dataset == null || dataset.equalsIgnoreCase("null")) {
                return null;
            }
            url.append(baseWmsUrl);
            url.append(dataset + "?SERVICE=WMS&LAYERS=" + params.getString("layer"));
            String style = params.getString("style");
            String palette = params.getString("palette");
            if (style != null && palette != null) {
                url.append("&STYLES=" + style + "/" + palette);
            } else {
                url.append("&STYLES=");
            }
            String scaleRange = params.getString("scaleRange");
            if (scaleRange != null) {
                url.append("&COLORSCALERANGE=" + scaleRange);
            }
            if ((numColorBands = params.getString("numColorBands")) != null) {
                url.append("&NUMCOLORBANDS=" + numColorBands);
            }
            if (time != null) {
                url.append("&TIME=" + time);
            }
            if ((elevation = params.getString("elevation")) != null) {
                url.append("&ELEVATION=" + elevation);
            }
            if ((colorbyDepth = params.getString("colorby/depth")) != null) {
                url.append("&COLORBY/DEPTH=" + colorbyDepth);
            }
            if ((colorbyTime = params.getString("colorby/time")) != null) {
                url.append("&COLORBY/TIME=" + colorbyTime);
            }
        }
        url.append("&TRANSPARENT=true");
        url.append("&VERSION=1.1.1&SERVICE=WMS&REQUEST=GetMap&FORMAT=image/png&WIDTH=" + width + "&HEIGHT=" + height);
        url.append("&BBOX=" + minLon + "," + minLat + "," + maxLon + "," + maxLat);
        String crs = params.getString("crs");
        if (crs.equalsIgnoreCase("CRS:84")) {
            crs = "EPSG:4326";
        }
        url.append("&SRS=" + crs);
        try {
            return new URL(url.toString().replaceAll(" ", "%20"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private URL createColorbarUrl(RequestParams params, int mapHeight, String baseUrl) {
        String palette;
        String dataset = params.getString("dataset");
        if (dataset == null || dataset.equalsIgnoreCase("null")) {
            return null;
        }
        String url = baseUrl + dataset + "?REQUEST=GetLegendGraphic&COLORBARONLY=true&WIDTH=1&HEIGHT=" + mapHeight;
        String numColorBands = params.getString("numColorBands");
        if (numColorBands != null) {
            url = url + "&NUMCOLORBANDS=" + numColorBands;
        }
        if ((palette = params.getString("palette")) != null) {
            url = url + "&PALETTE=" + palette;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

