/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;

public class RequestParams {
    private Map<String, String> paramMap = new HashMap<String, String>();

    public RequestParams(Map<?, ?> httpRequestParamMap) {
        Map<?, ?> httpParamMap = httpRequestParamMap;
        for (String name : httpParamMap.keySet()) {
            String[] values = (String[])httpParamMap.get(name);
            assert (values.length >= 1);
            try {
                String key = URLDecoder.decode(name.trim(), "UTF-8").toLowerCase();
                String value = URLDecoder.decode(values[0].trim(), "UTF-8");
                this.paramMap.put(key, value);
            }
            catch (UnsupportedEncodingException uee) {
                throw new AssertionError((Object)uee);
            }
        }
    }

    public String getString(String paramName) {
        return this.paramMap.get(paramName.toLowerCase());
    }

    public String getMandatoryString(String paramName) throws WmsException {
        String value = this.getString(paramName);
        if (value == null) {
            throw new WmsException("Must provide a value for parameter " + paramName.toUpperCase());
        }
        return value;
    }

    public String getWmsVersion() {
        String version = this.getString("version");
        if (version == null) {
            version = this.getString("wmtver");
        }
        return version;
    }

    public String getMandatoryWmsVersion() throws WmsException {
        String version = this.getWmsVersion();
        if (version == null) {
            throw new WmsException("Must provide a value for VERSION");
        }
        return version;
    }

    public int getPositiveInt(String paramName, int defaultValue) throws WmsException {
        String value = this.getString(paramName);
        if (value == null) {
            return defaultValue;
        }
        return RequestParams.parsePositiveInt(paramName, value);
    }

    public int getMandatoryPositiveInt(String paramName) throws WmsException {
        String value = this.getString(paramName);
        if (value == null) {
            throw new WmsException("Must provide a value for parameter " + paramName.toUpperCase());
        }
        return RequestParams.parsePositiveInt(paramName, value);
    }

    private static int parsePositiveInt(String paramName, String value) throws WmsException {
        try {
            int i = Integer.parseInt(value);
            if (i < 0) {
                throw new WmsException("Parameter " + paramName.toUpperCase() + " must be a valid positive integer");
            }
            return i;
        }
        catch (NumberFormatException nfe) {
            throw new WmsException("Parameter " + paramName.toUpperCase() + " must be a valid positive integer");
        }
    }

    public String getString(String paramName, String defaultValue) {
        String value = this.getString(paramName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean getBoolean(String paramName, boolean defaultValue) throws WmsException {
        String value = this.getString(paramName);
        if (value == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(value = value.trim())) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new WmsException("Invalid boolean value for parameter " + paramName);
    }

    public float getFloat(String paramName, float defaultValue) throws WmsException {
        String value = this.getString(paramName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            throw new WmsException("Parameter " + paramName.toUpperCase() + " must be a valid floating-point number");
        }
    }
}

