/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.coverage.PointSeriesCoverage;
import uk.ac.rdg.resc.edal.coverage.ProfileCoverage;
import uk.ac.rdg.resc.edal.coverage.domain.DiscreteDomain;
import uk.ac.rdg.resc.edal.coverage.domain.PointSeriesDomain;
import uk.ac.rdg.resc.edal.coverage.domain.impl.HorizontalDomain;
import uk.ac.rdg.resc.edal.coverage.domain.impl.PointSeriesDomainImpl;
import uk.ac.rdg.resc.edal.coverage.grid.GridCell2D;
import uk.ac.rdg.resc.edal.coverage.grid.GridCoordinates2D;
import uk.ac.rdg.resc.edal.coverage.grid.HorizontalGrid;
import uk.ac.rdg.resc.edal.coverage.grid.RegularGrid;
import uk.ac.rdg.resc.edal.coverage.grid.VerticalAxis;
import uk.ac.rdg.resc.edal.coverage.grid.impl.GridCoordinates2DImpl;
import uk.ac.rdg.resc.edal.coverage.impl.PointSeriesCoverageImpl;
import uk.ac.rdg.resc.edal.coverage.metadata.RangeMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.ScalarMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.exceptions.InvalidCrsException;
import uk.ac.rdg.resc.edal.exceptions.InvalidLineStringException;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.FeatureCollection;
import uk.ac.rdg.resc.edal.feature.GridFeature;
import uk.ac.rdg.resc.edal.feature.GridSeriesFeature;
import uk.ac.rdg.resc.edal.feature.PointSeriesFeature;
import uk.ac.rdg.resc.edal.feature.ProfileFeature;
import uk.ac.rdg.resc.edal.feature.TrajectoryFeature;
import uk.ac.rdg.resc.edal.feature.UniqueMembersFeatureCollection;
import uk.ac.rdg.resc.edal.feature.impl.PointSeriesFeatureImpl;
import uk.ac.rdg.resc.edal.geometry.BoundingBox;
import uk.ac.rdg.resc.edal.geometry.impl.BoundingBoxImpl;
import uk.ac.rdg.resc.edal.geometry.impl.LineString;
import uk.ac.rdg.resc.edal.graphics.Charting;
import uk.ac.rdg.resc.edal.graphics.ColorPalette;
import uk.ac.rdg.resc.edal.graphics.formats.ImageFormat;
import uk.ac.rdg.resc.edal.graphics.formats.SimpleFormat;
import uk.ac.rdg.resc.edal.graphics.style.FeatureCollectionAndMemberName;
import uk.ac.rdg.resc.edal.graphics.style.GlobalPlottingParams;
import uk.ac.rdg.resc.edal.graphics.style.Id2FeatureAndMember;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Image;
import uk.ac.rdg.resc.edal.position.CalendarSystem;
import uk.ac.rdg.resc.edal.position.GeoPosition;
import uk.ac.rdg.resc.edal.position.HorizontalPosition;
import uk.ac.rdg.resc.edal.position.LonLatPosition;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.position.Vector2D;
import uk.ac.rdg.resc.edal.position.VerticalPosition;
import uk.ac.rdg.resc.edal.position.impl.HorizontalPositionImpl;
import uk.ac.rdg.resc.edal.position.impl.TimePositionJoda;
import uk.ac.rdg.resc.edal.util.BigList;
import uk.ac.rdg.resc.edal.util.CollectionUtils;
import uk.ac.rdg.resc.edal.util.Extents;
import uk.ac.rdg.resc.edal.util.GISUtils;
import uk.ac.rdg.resc.edal.util.LittleBigList;
import uk.ac.rdg.resc.edal.util.TimeUtils;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.config.FeaturePlottingMetadata;
import uk.ac.rdg.resc.ncwms.controller.FeatureInfo;
import uk.ac.rdg.resc.ncwms.controller.GetFeatureInfoDataRequest;
import uk.ac.rdg.resc.ncwms.controller.GetFeatureInfoRequest;
import uk.ac.rdg.resc.ncwms.controller.GetMapDataRequest;
import uk.ac.rdg.resc.ncwms.controller.GetMapParameters;
import uk.ac.rdg.resc.ncwms.controller.GetMapStyleParams;
import uk.ac.rdg.resc.ncwms.controller.GetMapStyleRequest;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.controller.ServerConfig;
import uk.ac.rdg.resc.ncwms.controller.WmsVersion;
import uk.ac.rdg.resc.ncwms.exceptions.CurrentUpdateSequence;
import uk.ac.rdg.resc.ncwms.exceptions.FeatureNotDefinedException;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidDimensionValueException;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidFormatException;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidUpdateSequence;
import uk.ac.rdg.resc.ncwms.exceptions.Wms1_1_1Exception;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.CapabilitiesLayer;
import uk.ac.rdg.resc.ncwms.wms.Dataset;

public abstract class AbstractWmsController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(AbstractWmsController.class);
    private static final String FEATURE_INFO_XML_FORMAT = "text/xml";
    private static final String FEATURE_INFO_GML_FORMAT = "application/vnd.ogc.gml";
    private static final String FEATURE_INFO_PNG_FORMAT = "image/png";
    private static final Object FEATURE_INFO_TEXT_FORMAT = "text/plain";
    public static final int LAYER_LIMIT = 1;
    protected ServerConfig serverConfig;

    public void init() throws Exception {
        File paletteLocationDir = this.serverConfig.getPaletteFilesLocation(this.getServletContext());
        if (paletteLocationDir != null && paletteLocationDir.exists() && paletteLocationDir.isDirectory()) {
            ColorPalette.loadPalettes((File)paletteLocationDir);
        } else {
            log.info("Directory of palette files does not exist or is not a directory");
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RequestParams params = new RequestParams(httpServletRequest.getParameterMap());
        try {
            String request = params.getMandatoryString("request");
            return this.dispatchWmsRequest(request, params, httpServletRequest, httpServletResponse);
        }
        catch (WmsException wmse) {
            wmse.printStackTrace();
            String wmsVersion = params.getWmsVersion();
            if (wmsVersion != null && wmsVersion.equals("1.1.1")) {
                throw new Wms1_1_1Exception(wmse);
            }
            throw wmse;
        }
        catch (SocketException se) {
            return null;
        }
        catch (IOException ioe) {
            if (ioe.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                return null;
            }
            throw ioe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected abstract ModelAndView dispatchWmsRequest(String var1, RequestParams var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected ModelAndView getCapabilities(Collection<? extends Dataset> datasets, TimePosition lastUpdateTime, RequestParams params, HttpServletRequest httpServletRequest) throws WmsException, IOException {
        WmsVersion wmsVersion;
        String service = params.getMandatoryString("service");
        if (!service.equals("WMS")) {
            throw new WmsException("The value of the SERVICE parameter must be \"WMS\"");
        }
        String versionStr = params.getWmsVersion();
        String updateSeqStr = params.getString("updatesequence");
        if (updateSeqStr != null) {
            TimePosition updateSequence;
            try {
                updateSequence = TimeUtils.iso8601ToDateTime((String)updateSeqStr, (CalendarSystem)CalendarSystem.CAL_ISO_8601);
            }
            catch (ParseException iae) {
                throw new InvalidUpdateSequence(updateSeqStr + " is not a valid ISO date-time");
            }
            if (updateSequence.getValue() == lastUpdateTime.getValue()) {
                throw new CurrentUpdateSequence(updateSeqStr);
            }
            if (updateSequence.getValue() > lastUpdateTime.getValue()) {
                throw new InvalidUpdateSequence(updateSeqStr + " is later than the current server updatesequence value");
            }
        }
        boolean verboseTimes = params.getBoolean("verbose", false);
        HashMap<String, Object> models = new HashMap<String, Object>();
        models.put("config", this.serverConfig);
        models.put("lastUpdate", lastUpdateTime == null ? new TimePositionJoda() : lastUpdateTime);
        models.put("wmsBaseUrl", httpServletRequest.getRequestURL().toString());
        String[] supportedCrsCodes = new String[]{"EPSG:4326", "CRS:84", "EPSG:41001", "EPSG:27700", "EPSG:3408", "EPSG:3409", "EPSG:3857", "EPSG:32661", "EPSG:32761"};
        models.put("supportedCrsCodes", supportedCrsCodes);
        models.put("supportedImageFormats", ImageFormat.getSupportedMimeTypes());
        models.put("layerLimit", 1);
        models.put("featureInfoFormats", new String[]{FEATURE_INFO_PNG_FORMAT, FEATURE_INFO_XML_FORMAT});
        models.put("legendWidth", 110);
        models.put("legendHeight", 264);
        models.put("paletteNames", ColorPalette.getAvailablePaletteNames());
        models.put("verboseTimes", verboseTimes);
        ArrayList<CapabilitiesLayer> layers = new ArrayList<CapabilitiesLayer>();
        for (Dataset dataset : datasets) {
            if (dataset.isDisabled()) continue;
            CapabilitiesLayer topLayer = new CapabilitiesLayer(dataset.isReady(), null, dataset.getTitle(), null, null, (Extent<TimePosition>)Extents.emptyExtent(TimePosition.class), null, null, false);
            FeatureCollection<? extends Feature> featureCollection = dataset.getFeatureCollection();
            if (featureCollection == null) continue;
            if (featureCollection instanceof UniqueMembersFeatureCollection) {
                for (Feature feature : featureCollection.getFeatures()) {
                    RangeMetadata rangeMetadata = feature.getCoverage().getRangeMetadata();
                    List<CapabilitiesLayer> childLayers = this.getCapabilitiesLayerFromRangeMetadata(dataset, feature, rangeMetadata);
                    topLayer.getChildLayers().addAll(childLayers);
                }
            } else {
                WmsUtils.StyleInfo style = new WmsUtils.StyleInfo("DEFAULT", "");
                CapabilitiesLayer parentLayer = new CapabilitiesLayer(true, featureCollection.getId() + "/*", featureCollection.getName(), "", featureCollection.getCollectionBoundingBox(), (Extent<TimePosition>)featureCollection.getCollectionTimeExtent(), (Extent<VerticalPosition>)featureCollection.getCollectionVerticalExtent(), Arrays.asList(style), true);
                for (String memberId : featureCollection.getMemberIdsInCollection()) {
                    FeaturePlottingMetadata featurePlottingMetadata = dataset.getPlottingMetadataMap().get(memberId);
                    Collection features = featureCollection.findFeatures(null, null, null, CollectionUtils.setOf((Object[])new String[]{memberId}));
                    if (features.size() <= 0) continue;
                    Feature feature = (Feature)features.iterator().next();
                    CapabilitiesLayer childLayer = new CapabilitiesLayer(true, featureCollection.getId() + "/" + memberId, featurePlottingMetadata.getTitle(), feature.getDescription(), featureCollection.getCollectionBoundingBox(), (Extent<TimePosition>)featureCollection.getCollectionTimeExtent(), (Extent<VerticalPosition>)featureCollection.getCollectionVerticalExtent(), WmsUtils.getStylesWithPalettes(feature, memberId, ColorPalette.getAvailablePaletteNames()), true);
                    parentLayer.getChildLayers().add(childLayer);
                }
                topLayer.getChildLayers().add(parentLayer);
            }
            layers.add(topLayer);
        }
        models.put("layers", layers);
        WmsVersion wmsVersion2 = wmsVersion = versionStr == null ? WmsVersion.VERSION_1_3_0 : new WmsVersion(versionStr);
        if (wmsVersion.compareTo(WmsVersion.VERSION_1_3_0) >= 0) {
            return new ModelAndView("capabilities_xml", models);
        }
        return new ModelAndView("capabilities_xml_1_1_1", models);
    }

    private List<CapabilitiesLayer> getCapabilitiesLayerFromRangeMetadata(Dataset dataset, Feature feature, RangeMetadata rangeMetadata) {
        ArrayList<CapabilitiesLayer> ret = new ArrayList<CapabilitiesLayer>();
        for (String member : rangeMetadata.getMemberNames()) {
            RangeMetadata memberMetadata = rangeMetadata.getMemberMetadata(member);
            FeaturePlottingMetadata featurePlottingMetadata = dataset.getPlottingMetadataMap().get(member);
            CapabilitiesLayer layer = new CapabilitiesLayer(false, feature.getFeatureCollection().getId() + "/" + member, featurePlottingMetadata.getTitle(), feature.getDescription(), feature.getFeatureCollection().getCollectionBoundingBox(), GISUtils.getTimeAxis((Feature)feature), GISUtils.getVerticalAxis((Feature)feature), WmsUtils.getStylesWithPalettes(feature, member, ColorPalette.getAvailablePaletteNames()), true);
            layer.getChildLayers().addAll(this.getCapabilitiesLayerFromRangeMetadata(dataset, feature, memberMetadata));
            ret.add(layer);
        }
        return ret;
    }

    protected ModelAndView getMap(RequestParams params, final FeatureFactory featureFactory, HttpServletResponse httpServletResponse) throws WmsException {
        Id2FeatureAndMember id2Feature = new Id2FeatureAndMember(){

            public FeatureCollectionAndMemberName getFeatureAndMemberName(String id) {
                try {
                    return new FeatureCollectionAndMemberName(featureFactory.getFeatureCollection(id), WmsUtils.getMemberName(id));
                }
                catch (FeatureNotDefinedException e) {
                    e.printStackTrace();
                }
                catch (WmsException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        GetMapParameters getMapParams = new GetMapParameters(params, id2Feature, ((Config)this.serverConfig).getAllDatasets());
        GlobalPlottingParams plottingParameters = getMapParams.getPlottingParameters();
        GetMapStyleParams styleParameters = getMapParams.getStyleParameters();
        if (!(getMapParams.getImageFormat() instanceof SimpleFormat)) {
            throw new WmsException("Currently KML is not supported.");
        }
        SimpleFormat simpleFormat = (SimpleFormat)getMapParams.getImageFormat();
        if (!styleParameters.isXmlDefined()) {
            if (styleParameters.isTransparent() && !getMapParams.getImageFormat().supportsFullyTransparentPixels()) {
                throw new WmsException("The image format " + getMapParams.getImageFormat().getMimeType() + " does not support fully-transparent pixels");
            }
            if (styleParameters.getOpacity() < 100 && !getMapParams.getImageFormat().supportsPartiallyTransparentPixels()) {
                throw new WmsException("The image format " + getMapParams.getImageFormat().getMimeType() + " does not support partially-transparent pixels");
            }
            if (styleParameters.getNumLayers() > 1) {
                throw new WmsException("Only 1 layer(s) can be plotted at once");
            }
        }
        if (plottingParameters.getHeight() > this.serverConfig.getMaxImageHeight() || plottingParameters.getWidth() > this.serverConfig.getMaxImageWidth()) {
            throw new WmsException("Requested image size exceeds the maximum of " + this.serverConfig.getMaxImageWidth() + "x" + this.serverConfig.getMaxImageHeight());
        }
        Image imageGenerator = styleParameters.getImageGenerator();
        try {
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            simpleFormat.writeImage(Arrays.asList(imageGenerator.drawImage(plottingParameters, id2Feature)), (OutputStream)outputStream, null);
            outputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    protected ModelAndView getFeatureInfo(RequestParams params, FeatureFactory featureFactory, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WmsException, Exception {
        StringBuffer requestParams;
        StringBuffer requestURL;
        GetFeatureInfoRequest request = new GetFeatureInfoRequest(params);
        GetFeatureInfoDataRequest featureDataRequest = request.getDataRequest();
        String outputFormat = request.getOutputFormat();
        if (!(outputFormat.equals(FEATURE_INFO_XML_FORMAT) || outputFormat.equals(FEATURE_INFO_GML_FORMAT) || outputFormat.equals(FEATURE_INFO_TEXT_FORMAT))) {
            throw new InvalidFormatException("The output format " + request.getOutputFormat() + " is not valid for GetFeatureInfo");
        }
        String[] layers = featureDataRequest.getLayers();
        if (layers.length > 1) {
            throw new WmsException("Only 1 layer(s) can be requested at once");
        }
        String layerName = layers[0];
        String memberName = WmsUtils.getMemberName(layerName);
        FeatureCollection<? extends Feature> featureCollection = featureFactory.getFeatureCollection(layerName);
        if (featureCollection == null) {
            throw new WmsException("Layer not yet loaded");
        }
        RegularGrid grid = WmsUtils.getImageGrid(featureDataRequest);
        int j = featureDataRequest.getHeight() - featureDataRequest.getPixelRow() - 1;
        HorizontalPosition pos = grid.transformCoordinates((GridCoordinates2D)new GridCoordinates2DImpl(featureDataRequest.getPixelColumn(), j));
        final LonLatPosition lonLat = GISUtils.transformToWgs84LonLat((HorizontalPosition)pos);
        HashMap<String, Object> models = new HashMap<String, Object>();
        models.put("longitude", lonLat.getLongitude());
        models.put("latitude", lonLat.getLatitude());
        models.put("crs", featureDataRequest.getCrsCode());
        String timeString = featureDataRequest.getTimeString();
        List<FeatureInfo> featureData = new ArrayList<FeatureInfo>();
        if (featureCollection instanceof UniqueMembersFeatureCollection) {
            GridCell2D gridCell;
            Feature feature = ((UniqueMembersFeatureCollection)featureCollection).getFeatureContainingMember(memberName);
            memberName = MetadataUtils.getScalarMemberName((Feature)feature, (String)memberName);
            VerticalPosition zValue = GISUtils.getExactElevation((String)featureDataRequest.getElevationString(), (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature));
            HorizontalGrid horizGrid = null;
            if (feature instanceof GridSeriesFeature) {
                horizGrid = ((GridSeriesFeature)feature).getCoverage().getDomain().getHorizontalGrid();
            } else if (feature instanceof GridFeature) {
                GridFeature gridFeature = (GridFeature)feature;
                horizGrid = gridFeature.getCoverage().getDomain();
            }
            LonLatPosition gridCellCentre = null;
            if (horizGrid != null && (gridCell = horizGrid.findContainingCell(pos)) != null) {
                gridCellCentre = GISUtils.transformToWgs84LonLat((HorizontalPosition)gridCell.getCentre());
            }
            List<TimePosition> tValues = WmsUtils.getTimePositionsForString(timeString, feature);
            HashMap<TimePosition, Object> timesAndValues = new HashMap<TimePosition, Object>();
            if (tValues.isEmpty()) {
                Object val = WmsUtils.getFeatureValue(feature, pos, zValue, null, memberName);
                timesAndValues.put(null, val);
            } else {
                for (TimePosition timePosition : tValues) {
                    Object val = WmsUtils.getFeatureValue(feature, pos, zValue, timePosition, memberName);
                    timesAndValues.put(timePosition, val);
                }
            }
            featureData.add(new FeatureInfo(featureCollection.getId(), feature.getId(), memberName, (HorizontalPosition)gridCellCentre, timesAndValues));
        } else {
            HorizontalPosition lowerCorner = grid.transformCoordinates((GridCoordinates2D)new GridCoordinates2DImpl(featureDataRequest.getPixelColumn() - 4, j - 4));
            HorizontalPosition upperCorner = grid.transformCoordinates((GridCoordinates2D)new GridCoordinates2DImpl(featureDataRequest.getPixelColumn() + 4, j + 4));
            BoundingBoxImpl bbox = new BoundingBoxImpl(lowerCorner, upperCorner);
            Collection<? extends Feature> features = AbstractWmsController.getMatchingFeatures(featureDataRequest, featureCollection, (BoundingBox)bbox, memberName);
            TimePosition colorByTime = null;
            if (featureDataRequest.getColorbyTimeString() != null) {
                colorByTime = TimeUtils.iso8601ToDateTime((String)featureDataRequest.getColorbyTimeString(), (CalendarSystem)CalendarSystem.CAL_ISO_8601);
            }
            Double colorByDepth = null;
            if (featureDataRequest.getColorbyElevationString() != null) {
                colorByDepth = Double.parseDouble(featureDataRequest.getColorbyElevationString());
            }
            for (Feature feature : features) {
                TimePosition tPos;
                VerticalPosition vPos;
                memberName = memberName == null || memberName.equals("*") ? null : MetadataUtils.getScalarMemberName((Feature)feature, (String)memberName);
                if (feature instanceof TrajectoryFeature) {
                    GeoPosition trajectoryPosition = GISUtils.getTrajectoryPosition((TrajectoryFeature)((TrajectoryFeature)feature), (HorizontalPosition)pos, (BoundingBox)bbox);
                    if (trajectoryPosition == null) continue;
                    pos = trajectoryPosition.getHorizontalPosition();
                    vPos = trajectoryPosition.getVerticalPosition();
                    tPos = trajectoryPosition.getTimePosition();
                } else {
                    vPos = GISUtils.getClosestElevationTo((Double)colorByDepth, (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature));
                    tPos = GISUtils.getClosestTimeTo((TimePosition)colorByTime, (List)GISUtils.getTimes((Feature)feature, (boolean)false));
                }
                Object value = WmsUtils.getFeatureValue(feature, pos, vPos, tPos, memberName);
                HashMap<TimePosition, Object> timesAndValues = new HashMap<TimePosition, Object>();
                timesAndValues.put(tPos, value);
                HorizontalPosition actualPos = GISUtils.getClosestHorizontalPositionTo((HorizontalPosition)pos, (Feature)feature);
                FeatureInfo featureInfo = new FeatureInfo(featureCollection.getId(), feature.getId(), memberName, actualPos, timesAndValues);
                featureData.add(featureInfo);
            }
        }
        Extent tExtent = featureCollection.getCollectionTimeExtent();
        if (!tExtent.isEmpty() && !((TimePosition)tExtent.getLow()).equals((Object)tExtent.getHigh())) {
            requestURL = httpServletRequest.getRequestURL();
            requestParams = new StringBuffer();
            requestURL.append("?REQUEST=GetTimeseries");
            requestURL.append("&FORMAT=image/png");
            requestURL.append("&CRS=" + featureDataRequest.getCrsCode());
            requestURL.append("&POINT=" + lonLat.getLongitude() + " " + lonLat.getLatitude());
            String elevationString = featureDataRequest.getColorbyElevationString();
            if (elevationString == null && featureDataRequest.getElevationString() != null && !featureDataRequest.getElevationString().contains("/")) {
                elevationString = featureDataRequest.getElevationString();
            }
            if (elevationString != null && !elevationString.equals("")) {
                requestURL.append("&ELEVATION=" + elevationString);
            }
            requestURL.append("&TIME=" + TimeUtils.dateTimeToISO8601((TimePosition)((TimePosition)tExtent.getLow())) + "/" + TimeUtils.dateTimeToISO8601((TimePosition)((TimePosition)tExtent.getHigh())));
            requestURL.append("&LAYER=");
            for (FeatureInfo info : featureData) {
                requestURL.append(info.getFeatureCollectionId() + "/" + info.getFeatureId() + "/" + info.getMemberId() + ",");
            }
            requestURL.deleteCharAt(requestURL.length() - 1);
            models.put("timeseriesUrl", requestURL.toString() + URLEncoder.encode(requestParams.toString(), "UTF-8"));
        }
        if (!featureCollection.getCollectionVerticalExtent().isEmpty()) {
            requestURL = httpServletRequest.getRequestURL();
            requestParams = new StringBuffer();
            requestURL.append("?REQUEST=GetVerticalProfile");
            requestURL.append("&FORMAT=image/png");
            requestURL.append("&CRS=" + featureDataRequest.getCrsCode());
            requestURL.append("&POINT=" + lonLat.getLongitude() + " " + lonLat.getLatitude());
            String featureTimeString = featureDataRequest.getColorbyTimeString();
            if (featureTimeString == null && !featureDataRequest.getTimeString().contains("/")) {
                featureTimeString = featureDataRequest.getTimeString();
            }
            if (featureTimeString != null && !featureTimeString.equals("")) {
                requestURL.append("&TIME=" + featureTimeString);
            }
            requestURL.append("&LAYER=");
            for (FeatureInfo info : featureData) {
                requestURL.append(info.getFeatureCollectionId() + "/" + info.getFeatureId() + "/" + info.getMemberId() + ",");
            }
            requestURL.deleteCharAt(requestURL.length() - 1);
            models.put("profileUrl", requestURL.toString() + URLEncoder.encode(requestParams.toString(), "UTF-8"));
        }
        Collections.sort(featureData, new Comparator<FeatureInfo>(){

            @Override
            public int compare(FeatureInfo arg0, FeatureInfo arg1) {
                Double dist0 = Math.pow(arg0.getActualPos().getY() - lonLat.getLatitude(), 2.0) + Math.pow(arg0.getActualPos().getX() - lonLat.getLongitude(), 2.0);
                Double dist1 = Math.pow(arg1.getActualPos().getY() - lonLat.getLatitude(), 2.0) + Math.pow(arg1.getActualPos().getX() - lonLat.getLongitude(), 2.0);
                return dist0.compareTo(dist1);
            }
        });
        if (featureData.size() > featureDataRequest.getFeatureCount()) {
            featureData = featureData.subList(0, featureDataRequest.getFeatureCount());
        }
        models.put("data", featureData);
        if (FEATURE_INFO_XML_FORMAT.equals(outputFormat)) {
            return new ModelAndView("showFeatureInfo_xml", models);
        }
        if (FEATURE_INFO_GML_FORMAT.equals(outputFormat)) {
            return new ModelAndView("showFeatureInfo_gml", models);
        }
        if (FEATURE_INFO_TEXT_FORMAT.equals(outputFormat)) {
            return new ModelAndView("showFeatureInfo_plain", models);
        }
        return null;
    }

    private static Collection<? extends Feature> getMatchingFeatures(GetMapDataRequest dataRequest, FeatureCollection<? extends Feature> featureCollection, BoundingBox bbox, String memberName) throws WmsException {
        Extent tRange = null;
        Extent<Double> zRange = null;
        try {
            tRange = TimeUtils.getTimeRangeForString((String)dataRequest.getTimeString(), (CalendarSystem)CalendarSystem.CAL_ISO_8601);
        }
        catch (ParseException pe) {
            throw new WmsException("Cannot create time range from string: " + dataRequest.getTimeString());
        }
        try {
            zRange = WmsUtils.getElevationRangeForString(dataRequest.getElevationString());
        }
        catch (IllegalArgumentException e) {
            throw new WmsException("Cannot create depth range from string: " + dataRequest.getElevationString());
        }
        Set members = memberName.equals("*") ? null : CollectionUtils.setOf((Object[])new String[]{memberName});
        return featureCollection.findFeatures(bbox, zRange, tRange, members);
    }

    protected ModelAndView getColorbar(RequestParams params, FeatureFactory featureFactory, HttpServletResponse httpServletResponse) throws Exception {
        int numColourBands = GetMapStyleRequest.getNumColourBands(params);
        String paletteName = params.getString("palette");
        boolean vertical = params.getBoolean("vertical", true);
        int width = params.getPositiveInt("width", 50);
        int height = params.getPositiveInt("height", 200);
        ColorPalette palette = ColorPalette.get((String)paletteName);
        BufferedImage legend = palette.createColorBar(width, height, numColourBands, vertical);
        httpServletResponse.setContentType(FEATURE_INFO_PNG_FORMAT);
        ImageIO.write((RenderedImage)legend, "png", (OutputStream)httpServletResponse.getOutputStream());
        return null;
    }

    protected ModelAndView getTransect(RequestParams params, FeatureFactory featureFactory, HttpServletResponse response) throws Exception {
        String layerName = params.getMandatoryString("layer");
        String memberName = WmsUtils.getMemberName(layerName);
        FeatureCollection<? extends Feature> featureCollection = featureFactory.getFeatureCollection(layerName);
        if (featureCollection == null) {
            throw new WmsException("Layer not yet loaded");
        }
        if (!(featureCollection instanceof UniqueMembersFeatureCollection)) {
            throw new WmsException("Cannot get a transect - we have multiple features which make up this layer");
        }
        Feature feature = ((UniqueMembersFeatureCollection)featureCollection).getFeatureContainingMember(memberName);
        memberName = MetadataUtils.getScalarMemberName((Feature)feature, (String)memberName);
        GridFeature gridFeature = null;
        boolean hasVerticalAxis = false;
        TimePosition tValue = null;
        VerticalPosition zValue = null;
        VerticalAxis vAxis = null;
        if (feature instanceof GridFeature) {
            gridFeature = (GridFeature)feature;
        } else if (feature instanceof GridSeriesFeature) {
            GridSeriesFeature gridSeriesFeature = (GridSeriesFeature)feature;
            List<TimePosition> tValues = WmsUtils.getTimePositionsForString(params.getString("time"), feature);
            tValue = tValues.isEmpty() ? null : tValues.get(0);
            zValue = GISUtils.getExactElevation((String)params.getString("elevation"), (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature));
            vAxis = gridSeriesFeature.getCoverage().getDomain().getVerticalAxis();
            if (vAxis != null && vAxis.size() > 1) {
                hasVerticalAxis = true;
            }
            gridFeature = gridSeriesFeature.extractGridFeature(gridSeriesFeature.getCoverage().getDomain().getHorizontalGrid(), zValue, tValue, CollectionUtils.setOf((Object[])new String[]{memberName}));
        } else {
            throw new WmsException("Cannot get a transect for a non-gridded feature");
        }
        String crsCode = params.getMandatoryString("crs");
        String lineString = params.getMandatoryString("linestring");
        String outputFormat = params.getMandatoryString("format");
        if (!outputFormat.equals(FEATURE_INFO_PNG_FORMAT) && !outputFormat.equals(FEATURE_INFO_XML_FORMAT)) {
            throw new InvalidFormatException(outputFormat);
        }
        LineString transect = new LineString(lineString, WmsUtils.getCrs(crsCode), params.getWmsVersion());
        log.debug("Got {} control points", (Object)transect.getControlPoints().size());
        HorizontalDomain transectDomain = Charting.getOptimalTransectDomain((HorizontalGrid)gridFeature.getCoverage().getDomain(), (LineString)transect);
        log.debug("Using transect consisting of {} points", (Object)transectDomain.getDomainObjects().size());
        response.setContentType(outputFormat);
        if (outputFormat.equals(FEATURE_INFO_PNG_FORMAT)) {
            String datasetId = WmsUtils.getDatasetId(layerName);
            String copyright = ((Config)this.serverConfig).getDatasetById(datasetId).getCopyrightStatement();
            JFreeChart chart = Charting.createTransectPlot((GridFeature)gridFeature, (String)memberName, (LineString)transect, (String)copyright, (boolean)hasVerticalAxis);
            int width = 400;
            int height = 300;
            if (hasVerticalAxis) {
                JFreeChart verticalSectionChart = this.createVerticalSectionChart(params, (GridSeriesFeature)feature, tValue, transect, transectDomain);
                CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("distance along path (arbitrary units)"));
                plot.setGap(20.0);
                plot.add(chart.getXYPlot(), 1);
                plot.add(verticalSectionChart.getXYPlot(), 1);
                plot.setOrientation(PlotOrientation.VERTICAL);
                String title = MetadataUtils.getScalarMetadata((Feature)feature, (String)memberName).getTitle() + " at " + zValue;
                chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
                if (copyright != null) {
                    TextTitle textTitle = new TextTitle(copyright);
                    textTitle.setFont(new Font("SansSerif", 0, 10));
                    textTitle.setPosition(RectangleEdge.BOTTOM);
                    textTitle.setHorizontalAlignment(HorizontalAlignment.RIGHT);
                    chart.addSubtitle((Title)textTitle);
                }
                RectangleInsets r = new RectangleInsets(0.0, 10.0, 0.0, 0.0);
                chart.setPadding(r);
                chart.addSubtitle(verticalSectionChart.getSubtitle(0));
                height = 600;
            }
            ChartUtilities.writeChartAsPNG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)width, (int)height);
        } else if (outputFormat.equals(FEATURE_INFO_XML_FORMAT)) {
            if (!Number.class.isAssignableFrom(feature.getCoverage().getScalarMetadata(memberName).getValueType())) {
                throw new IllegalArgumentException("The member " + memberName + " contains non-numerical data");
            }
            ArrayList<Float> transectData = new ArrayList<Float>();
            List positions = transectDomain.getDomainObjects();
            for (HorizontalPosition pos : positions) {
                transectData.add(Float.valueOf(((Number)gridFeature.getCoverage().evaluate((Object)pos)).floatValue()));
            }
            LinkedHashMap dataPoints = new LinkedHashMap();
            List points = transectDomain.getDomainObjects();
            for (int i = 0; i < points.size(); ++i) {
                dataPoints.put(points.get(i), transectData.get(i));
            }
            HashMap<String, Object> models = new HashMap<String, Object>();
            models.put("crs", crsCode);
            models.put("layer", feature);
            models.put("linestring", lineString);
            models.put("data", dataPoints);
            return new ModelAndView("showTransect_xml", models);
        }
        return null;
    }

    protected ModelAndView getTimeseries(RequestParams params, FeatureFactory featureFactory, HttpServletResponse response) throws WmsException, IOException {
        String outputFormat = params.getMandatoryString("format");
        if (!(FEATURE_INFO_PNG_FORMAT.equals(outputFormat) || "image/jpeg".equals(outputFormat) || "image/jpg".equals(outputFormat))) {
            throw new InvalidFormatException(outputFormat + " is not a valid output format for a profile plot");
        }
        String[] layers = params.getMandatoryString("layer").split(",");
        ArrayList<Feature> featuresToPlot = new ArrayList<Feature>();
        String baseMemberName = null;
        for (String layer : layers) {
            String[] layerParts = layer.split("/");
            if (layerParts.length != 3) {
                throw new WmsException("For timeseries', layer IDs must be of the form dataset/feature/variable.  These IDs can be obtained by performing a GetFeatureInfo request with the output format set to text/xml");
            }
            FeatureCollection<? extends Feature> featureCollection = featureFactory.getFeatureCollection(layerParts[0] + "/dummy");
            if (featureCollection == null) {
                throw new WmsException("Layer not yet loaded");
            }
            featuresToPlot.add(featureCollection.getFeatureById(layerParts[1]));
            if (baseMemberName == null) {
                baseMemberName = layerParts[2];
                continue;
            }
            if (baseMemberName.equals(layerParts[2])) continue;
            throw new WmsException("For a timeseries plot, all variables need to be the same");
        }
        String timeString = params.getMandatoryString("time");
        ArrayList<Feature> timeseriesFeatures = new ArrayList<Feature>();
        for (Feature feature : featuresToPlot) {
            Extent timeRange;
            String memberName = MetadataUtils.getScalarMemberName((Feature)feature, baseMemberName);
            Feature timeseriesFeature = null;
            if (feature instanceof PointSeriesFeature) {
                try {
                    timeRange = TimeUtils.getTimeRangeForString((String)timeString, (CalendarSystem)((PointSeriesFeature)feature).getCoverage().getDomain().getCalendarSystem());
                }
                catch (ParseException e) {
                    throw new WmsException("Time range is invalid - cannot create a time series plot");
                }
                timeseriesFeature = ((PointSeriesFeature)feature).extractSubFeature(timeRange, CollectionUtils.setOf((Object[])new String[]{memberName}));
            } else if (feature instanceof GridSeriesFeature) {
                try {
                    timeRange = TimeUtils.getTimeRangeForString((String)timeString, (CalendarSystem)((GridSeriesFeature)feature).getCoverage().getDomain().getCalendarSystem());
                }
                catch (ParseException e) {
                    throw new WmsException("Time range is invalid - cannot create a time series plot");
                }
                VerticalPosition zValue = GISUtils.getExactElevation((String)params.getString("elevation"), (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature));
                HorizontalPosition pos = this.getHorizontalPosition(params);
                GridSeriesFeature gridSeriesFeature = (GridSeriesFeature)feature;
                timeseriesFeature = gridSeriesFeature.extractPointSeriesFeature(pos, zValue, timeRange, CollectionUtils.setOf((Object[])new String[]{memberName}));
            } else if (feature instanceof TrajectoryFeature) {
                timeseriesFeature = feature;
            } else {
                List times = GISUtils.getTimes((Feature)feature, (boolean)true);
                HorizontalPosition hPos = this.getHorizontalPosition(params);
                Double targetDepth = null;
                if (params.getString("elevation") != null) {
                    targetDepth = Double.parseDouble(params.getString("elevation"));
                }
                VerticalPosition vPos = GISUtils.getClosestElevationTo(targetDepth, (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature));
                assert (times.size() == 1);
                PointSeriesDomainImpl domain = new PointSeriesDomainImpl(times);
                ScalarMetadata scalarMetadata = MetadataUtils.getScalarMetadata((Feature)feature, (String)memberName);
                PointSeriesCoverageImpl coverage = new PointSeriesCoverageImpl(scalarMetadata.getDescription(), (PointSeriesDomain)domain);
                Object value = WmsUtils.getFeatureValue(feature, hPos, vPos, (TimePosition)times.get(0), memberName);
                LittleBigList littleBigList = new LittleBigList();
                littleBigList.add(value);
                coverage.addMember(baseMemberName, (DiscreteDomain)domain, scalarMetadata.getDescription(), scalarMetadata.getParameter(), scalarMetadata.getUnits(), (BigList)littleBigList, scalarMetadata.getValueType());
                timeseriesFeature = new PointSeriesFeatureImpl(scalarMetadata.getTitle(), scalarMetadata.getName(), scalarMetadata.getDescription(), (PointSeriesCoverage)coverage, hPos, vPos, null);
            }
            if (timeseriesFeature == null) continue;
            timeseriesFeatures.add(timeseriesFeature);
        }
        if (timeseriesFeatures.size() == 0) {
            throw new WmsException("Cannot plot a timeseries of " + params.getMandatoryString("layer") + " at this point");
        }
        JFreeChart chart = Charting.createTimeseriesPlot(timeseriesFeatures, baseMemberName);
        response.setContentType(outputFormat);
        int width = 500;
        int height = 400;
        if (FEATURE_INFO_PNG_FORMAT.equals(outputFormat)) {
            ChartUtilities.writeChartAsPNG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)width, (int)height);
        } else {
            ChartUtilities.writeChartAsJPEG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)width, (int)height);
        }
        return null;
    }

    private HorizontalPosition getHorizontalPosition(RequestParams params) throws WmsException {
        double y;
        double x;
        String crsCode = params.getString("crs");
        CoordinateReferenceSystem crs = WmsUtils.getCrs(crsCode);
        String point = params.getString("point");
        String[] coords = point.trim().split(" +");
        if (coords.length != 2) {
            throw new WmsException("Invalid POINT format");
        }
        int lonIndex = 0;
        int latIndex = 1;
        if (crsCode.equalsIgnoreCase("EPSG:4326") && params.getWmsVersion().equalsIgnoreCase("1.3.0")) {
            latIndex = 0;
            lonIndex = 1;
        }
        try {
            x = Double.parseDouble(coords[lonIndex]);
            y = Double.parseDouble(coords[latIndex]);
        }
        catch (NumberFormatException nfe) {
            throw new WmsException("Invalid POINT format");
        }
        return new HorizontalPositionImpl(x, y, crs);
    }

    protected ModelAndView getVerticalProfile(RequestParams params, FeatureFactory featureFactory, HttpServletResponse response) throws WmsException, IOException {
        String outputFormat = params.getMandatoryString("format");
        if (!(FEATURE_INFO_PNG_FORMAT.equals(outputFormat) || "image/jpeg".equals(outputFormat) || "image/jpg".equals(outputFormat))) {
            throw new InvalidFormatException(outputFormat + " is not a valid output format for a profile plot");
        }
        String[] layers = params.getMandatoryString("layer").split(",");
        ArrayList<Feature> featuresToPlot = new ArrayList<Feature>();
        String baseMemberName = null;
        for (String layer : layers) {
            String[] layerParts = layer.split("/");
            if (layerParts.length != 3) {
                throw new WmsException("For vertical profiles, layer IDs must be of the form dataset/feature/variable.  These IDs can be obtained by performing a GetFeatureInfo request with the output format set to text/xml");
            }
            FeatureCollection<? extends Feature> featureCollection = featureFactory.getFeatureCollection(layerParts[0] + "/dummy");
            if (featureCollection == null) {
                throw new WmsException("Layer not yet loaded");
            }
            featuresToPlot.add(featureCollection.getFeatureById(layerParts[1]));
            if (baseMemberName == null) {
                baseMemberName = layerParts[2];
                continue;
            }
            if (baseMemberName.equals(layerParts[2])) continue;
            throw new WmsException("For a profile plot, all variables need to be the same");
        }
        String timeString = params.getMandatoryString("time");
        ArrayList<ProfileFeature> profileFeatures = new ArrayList<ProfileFeature>();
        for (Feature feature : featuresToPlot) {
            String memberName = MetadataUtils.getScalarMemberName((Feature)feature, baseMemberName);
            ProfileFeature profileFeature = null;
            if (feature instanceof ProfileFeature) {
                profileFeature = (ProfileFeature)feature;
            } else if (feature instanceof GridSeriesFeature) {
                double y;
                double x;
                GridSeriesFeature gridSeriesFeature = (GridSeriesFeature)feature;
                String crsCode = params.getMandatoryString("crs");
                String point = params.getMandatoryString("point");
                List<TimePosition> tValues = WmsUtils.getTimePositionsForString(timeString, feature);
                TimePosition tValue = tValues.isEmpty() ? null : tValues.get(0);
                CoordinateReferenceSystem crs = WmsUtils.getCrs(crsCode);
                String[] coords = point.trim().split(" +");
                if (coords.length != 2) {
                    throw new WmsException("Invalid POINT format");
                }
                int lonIndex = 0;
                int latIndex = 1;
                if (crsCode.equalsIgnoreCase("EPSG:4326") && params.getWmsVersion().equalsIgnoreCase("1.3.0")) {
                    latIndex = 0;
                    lonIndex = 1;
                }
                try {
                    x = Double.parseDouble(coords[lonIndex]);
                    y = Double.parseDouble(coords[latIndex]);
                }
                catch (NumberFormatException nfe) {
                    throw new WmsException("Invalid POINT format");
                }
                HorizontalPositionImpl pos = new HorizontalPositionImpl(x, y, crs);
                profileFeature = gridSeriesFeature.extractProfileFeature((HorizontalPosition)pos, tValue, CollectionUtils.setOf((Object[])new String[]{memberName}));
            } else {
                throw new WmsException("Cannot get a vertical profile of this type of feature");
            }
            if (profileFeature == null) continue;
            profileFeatures.add(profileFeature);
        }
        JFreeChart chart = Charting.createVerticalProfilePlot(profileFeatures, baseMemberName);
        response.setContentType(outputFormat);
        int width = 500;
        int height = 400;
        if (FEATURE_INFO_PNG_FORMAT.equals(outputFormat)) {
            ChartUtilities.writeChartAsPNG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)width, (int)height);
        } else {
            ChartUtilities.writeChartAsJPEG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)width, (int)height);
        }
        return null;
    }

    private JFreeChart createVerticalSectionChart(RequestParams params, GridSeriesFeature feature, TimePosition tValue, LineString lineString, HorizontalDomain transectDomain) throws WmsException, InvalidDimensionValueException, IOException {
        Boolean logScale;
        int numColourBands = GetMapStyleRequest.getNumColourBands(params);
        Extent scaleRange = GetMapStyleRequest.getColorScaleRange(params);
        String layerName = params.getMandatoryString("layer");
        String memberName = MetadataUtils.getScalarMemberName((Feature)feature, (String)WmsUtils.getMemberName(layerName));
        FeaturePlottingMetadata metadata = WmsUtils.getMetadata((Config)this.serverConfig, layerName);
        if (scaleRange == null) {
            scaleRange = metadata.getColorScaleRange();
        }
        if ((logScale = GetMapStyleRequest.isLogScale(params)) == null) {
            logScale = metadata.isLogScaling();
        }
        String paletteName = params.getString("palette");
        ColorPalette palette = ColorPalette.get((String)paletteName);
        ArrayList<3> sectionData = new ArrayList<3>();
        for (HorizontalPosition pos : transectDomain.getDomainObjects()) {
            final ProfileCoverage pCoverage = feature.extractProfileFeature(pos, tValue, CollectionUtils.setOf((Object[])new String[]{memberName})).getCoverage();
            final Class clazz = pCoverage.getScalarMetadata(memberName).getValueType();
            AbstractList<Float> pointProfile = new AbstractList<Float>(){

                @Override
                public Float get(int index) {
                    List values = pCoverage.getValues();
                    if (values == null) {
                        return null;
                    }
                    if (clazz == Float.class) {
                        return (Float)values.get(index);
                    }
                    if (clazz == Vector2D.class) {
                        return (Float)((Vector2D)values.get(index)).getMagnitude();
                    }
                    throw new UnsupportedOperationException("Unsupported layer type");
                }

                @Override
                public int size() {
                    return (int)pCoverage.size();
                }
            };
            sectionData.add(pointProfile);
        }
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        if (scaleRange.isEmpty()) {
            for (List list : sectionData) {
                Extent minMax = Extents.findMinMax((Collection)list);
                max = Math.max(max, ((Float)minMax.getHigh()).floatValue());
                min = Math.min(min, ((Float)minMax.getLow()).floatValue());
            }
            scaleRange = Extents.newExtent((Object)Float.valueOf(min), (Object)Float.valueOf(max));
        }
        VerticalPosition zValue = GISUtils.getExactElevation((String)params.getString("elevation"), (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature));
        return Charting.createVerticalSectionChart((GridSeriesFeature)feature, (String)memberName, (LineString)lineString, (Extent)scaleRange, (ColorPalette)palette, (int)numColourBands, (boolean)logScale, (VerticalPosition)zValue, (TimePosition)tValue);
    }

    protected ModelAndView getVerticalSection(RequestParams params, FeatureFactory featureFactory, HttpServletResponse response) throws WmsException, InvalidFormatException, IOException, InvalidCrsException, InvalidLineStringException {
        String layerName = params.getMandatoryString("layer");
        String memberName = WmsUtils.getMemberName(layerName);
        FeatureCollection<? extends Feature> featureCollection = featureFactory.getFeatureCollection(layerName);
        if (featureCollection == null) {
            throw new WmsException("Layer not yet loaded");
        }
        if (!(featureCollection instanceof UniqueMembersFeatureCollection)) {
            throw new WmsException("Cannot get a vertical section - we have multiple features which make up this layer");
        }
        Feature feature = ((UniqueMembersFeatureCollection)featureCollection).getFeatureContainingMember(memberName);
        if (!(feature instanceof GridSeriesFeature)) {
            throw new WmsException("Can only create vertical section chart from a GridSeriesFeature");
        }
        GridSeriesFeature gridSeriesFeature = (GridSeriesFeature)feature;
        String crsCode = params.getMandatoryString("crs");
        String lineStr = params.getMandatoryString("linestring");
        List<TimePosition> tValues = WmsUtils.getTimePositionsForString(params.getString("time"), feature);
        TimePosition tValue = tValues.isEmpty() ? null : tValues.get(0);
        String outputFormat = params.getMandatoryString("format");
        if (!(FEATURE_INFO_PNG_FORMAT.equals(outputFormat) || "image/jpeg".equals(outputFormat) || "image/jpg".equals(outputFormat))) {
            throw new InvalidFormatException(outputFormat + " is not a valid output format");
        }
        CoordinateReferenceSystem crs = WmsUtils.getCrs(crsCode);
        LineString lineString = new LineString(lineStr, crs, params.getMandatoryWmsVersion());
        log.debug("Got {} control points", (Object)lineString.getControlPoints().size());
        HorizontalDomain transectDomain = Charting.getOptimalTransectDomain((HorizontalGrid)gridSeriesFeature.getCoverage().getDomain().getHorizontalGrid(), (LineString)lineString);
        log.debug("Using transect consisting of {} points", (Object)transectDomain.getDomainObjects().size());
        JFreeChart chart = this.createVerticalSectionChart(params, gridSeriesFeature, tValue, lineString, transectDomain);
        response.setContentType(outputFormat);
        int width = 500;
        int height = 400;
        if (FEATURE_INFO_PNG_FORMAT.equals(outputFormat)) {
            ChartUtilities.writeChartAsPNG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)width, (int)height);
        } else {
            ChartUtilities.writeChartAsJPEG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)width, (int)height);
        }
        return null;
    }

    public void shutdown() {
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public static interface FeatureFactory {
        public FeatureCollection<? extends Feature> getFeatureCollection(String var1) throws FeatureNotDefinedException;
    }
}

